/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.core.internal;

import java.io.FileNotFoundException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.jst.server.generic.core.internal.GenericServerBehaviour;
import org.eclipse.jst.server.generic.core.internal.Trace;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.util.SocketUtil;

public class PingThread {
    private static final int PING_DELAY = 2000;
    private static final int PING_INTERVAL = 250;
    private int maxPings = 56;
    private boolean stop;
    private String fUrl;
    private IServer fServer;
    private GenericServerBehaviour fGenericServer;

    public PingThread(IServer server, String url, GenericServerBehaviour genericServer) {
        this.fServer = server;
        this.fUrl = url;
        this.maxPings = this.guessMaxPings(genericServer);
        this.fGenericServer = genericServer;
        Thread t = new Thread(){

            public void run() {
                PingThread.this.ping();
            }
        };
        t.setDaemon(true);
        t.start();
    }

    private int guessMaxPings(GenericServerBehaviour server) {
        int maxpings = -1;
        int startTimeout = server.getServer().getStartTimeout() * 1000;
        if (startTimeout > 0) {
            maxpings = startTimeout / 250;
        }
        return maxpings;
    }

    private boolean isRemote() {
        return this.fServer.getServerType().supportsRemoteHosts() && !SocketUtil.isLocalhost((String)this.fServer.getHost());
    }

    protected void ping() {
        int count = 0;
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {}
        while (!this.stop) {
            try {
                if (count == this.maxPings && !this.isRemote()) {
                    try {
                        this.fServer.stop(false);
                    }
                    catch (Exception exception) {
                        Trace.trace((byte)3, "Ping: could not stop server");
                    }
                    this.stop = true;
                    break;
                }
                if (!this.isRemote()) {
                    ++count;
                }
                Trace.trace((byte)3, "Ping: pinging");
                URL pingUrl = new URL(this.fUrl);
                URLConnection conn = pingUrl.openConnection();
                ((HttpURLConnection)conn).getResponseCode();
                if (!this.stop) {
                    Trace.trace((byte)3, "Ping: success");
                    Thread.sleep(200L);
                    this.fGenericServer.setServerStarted();
                }
                if (this.isRemote()) continue;
                this.stop = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    Thread.sleep(250L);
                }
                catch (Exception exception) {}
                this.fGenericServer.setServerStarted();
                if (this.isRemote()) continue;
                this.stop = true;
            }
            catch (Exception e) {
                Trace.trace((byte)3, "Ping: failed: " + e);
                if (this.stop) continue;
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void stop() {
        Trace.trace((byte)3, "Ping: stopping");
        this.stop = true;
    }
}

