/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.core.annotations.validation;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ReferenceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.SourcePosition;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;
import javax.xml.ws.WebFault;
import org.apache.xerces.util.XMLChar;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.ws.annotations.core.processor.AbstractAnnotationProcessor;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;
import org.eclipse.jst.ws.internal.jaxws.core.utils.JAXWSUtils;
import org.eclipse.jst.ws.jaxws.core.utils.JDTUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueNamesRule
extends AbstractAnnotationProcessor {
    private static Pattern pattern = Pattern.compile("arg\\d++");

    public void process() {
        AnnotationTypeDeclaration webServiceDeclaration = (AnnotationTypeDeclaration)this.environment.getTypeDeclaration(WebService.class.getName());
        Collection annotatedTypes = this.environment.getDeclarationsAnnotatedWith(webServiceDeclaration);
        for (Declaration declaration : annotatedTypes) {
            if (!(declaration instanceof TypeDeclaration)) continue;
            TypeDeclaration typeDeclaration = (TypeDeclaration)declaration;
            this.validateNameAttributes(typeDeclaration);
            this.checkOperationNames(typeDeclaration.getMethods());
            this.checkWrapperAndFaultBeanNames(typeDeclaration.getMethods());
            this.checkDocumentBareMethods(typeDeclaration.getMethods());
            this.checkMethodParameters(typeDeclaration.getMethods());
        }
    }

    private void validateNameAttributes(TypeDeclaration typeDeclaration) {
        AnnotationMirror webService = AnnotationUtils.getAnnotation((Declaration)typeDeclaration, WebService.class);
        this.checkAttributeValue(webService, WebService.class.getSimpleName(), "name");
        this.checkAttributeValue(webService, WebService.class.getSimpleName(), "portName");
        this.checkAttributeValue(webService, WebService.class.getSimpleName(), "serviceName");
        Collection methods = typeDeclaration.getMethods();
        for (MethodDeclaration methodDeclaration : methods) {
            AnnotationMirror webMethod = AnnotationUtils.getAnnotation((Declaration)methodDeclaration, WebMethod.class);
            this.checkAttributeValue(webMethod, WebMethod.class.getSimpleName(), "operationName");
            Collection parameters = methodDeclaration.getParameters();
            for (ParameterDeclaration parameterDeclaration : parameters) {
                AnnotationMirror webParam = AnnotationUtils.getAnnotation((Declaration)parameterDeclaration, WebParam.class);
                this.checkAttributeValue(webParam, WebParam.class.getSimpleName(), "name");
                this.checkAttributeValue(webParam, WebParam.class.getSimpleName(), "partName");
            }
        }
    }

    private void checkAttributeValue(AnnotationMirror annotationMirror, String annotationName, String attributeName) {
        AnnotationValue annotationValue;
        if (annotationMirror != null && (annotationValue = AnnotationUtils.getAnnotationValue((AnnotationMirror)annotationMirror, (String)attributeName)) != null) {
            if (annotationValue.toString().trim().length() == 0) {
                this.printError(annotationValue.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.EMPTY_ATTRIBUTE_VALUE, (Object[])new Object[]{annotationName, attributeName}));
            } else if (!XMLChar.isValidName((String)annotationValue.toString())) {
                this.printError(annotationValue.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.INVALID_NCNAME_ATTRIBUTE, (Object[])new Object[]{annotationName, attributeName, annotationValue.toString()}));
            }
        }
    }

    private boolean isAsyncMethod(MethodDeclaration methodDeclaration) {
        InterfaceDeclaration id;
        String qn;
        return methodDeclaration.getReturnType() instanceof InterfaceDeclaration && ((qn = Signature.getTypeErasure((String)(id = (InterfaceDeclaration)methodDeclaration.getReturnType()).getQualifiedName())).equals("javax.xml.ws.Response") || qn.equals("java.util.concurrent.Future"));
    }

    private void checkOperationNames(Collection<? extends MethodDeclaration> methods) {
        HashMap<MethodDeclaration, QName> nameMap = new HashMap<MethodDeclaration, QName>();
        for (MethodDeclaration methodDeclaration : methods) {
            if (this.isAsyncMethod(methodDeclaration)) continue;
            nameMap.put(methodDeclaration, new QName(this.getTargetNamespace(methodDeclaration.getDeclaringType()), this.getOperationName(methodDeclaration)));
        }
        Declaration[] declarationArray = nameMap.keySet().toArray(new Declaration[nameMap.size()]);
        QName[] values = nameMap.values().toArray(new QName[nameMap.size()]);
        int i = 0;
        while (i < values.length) {
            QName qName = values[i];
            int j = i + 1;
            while (j < values.length) {
                QName otherQName = values[j];
                if (qName.equals(otherQName)) {
                    this.printError(declarationArray[i].getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.OPERATION_NAMES_MUST_BE_UNIQUE_ERROR, (Object)qName));
                    this.printError(declarationArray[j].getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.OPERATION_NAMES_MUST_BE_UNIQUE_ERROR, (Object)otherQName));
                }
                ++j;
            }
            ++i;
        }
    }

    private String getAttributeValue(Declaration declaration, Class<? extends Annotation> annotation, String attributeName) {
        AnnotationMirror annotationMirror = AnnotationUtils.getAnnotation((Declaration)declaration, annotation);
        if (annotationMirror != null) {
            return AnnotationUtils.getStringValue((AnnotationMirror)annotationMirror, (String)attributeName);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void checkWrapperAndFaultBeanNames(Collection<? extends MethodDeclaration> methodDeclarations) {
        void var9_14;
        AnnotationTypeDeclaration requestWrapperDeclaration = (AnnotationTypeDeclaration)this.environment.getTypeDeclaration(RequestWrapper.class.getName());
        AnnotationTypeDeclaration resposeWrapperDeclaration = (AnnotationTypeDeclaration)this.environment.getTypeDeclaration(ResponseWrapper.class.getName());
        HashSet methods = new HashSet();
        methods.addAll(this.environment.getDeclarationsAnnotatedWith(requestWrapperDeclaration));
        methods.addAll(this.environment.getDeclarationsAnnotatedWith(resposeWrapperDeclaration));
        Iterator methodsIter = methods.iterator();
        while (methodsIter.hasNext()) {
            Declaration dec = (Declaration)methodsIter.next();
            if (!(dec instanceof MethodDeclaration) || !this.isAsyncMethod((MethodDeclaration)dec)) continue;
            methodsIter.remove();
        }
        ArrayList<AnnotationValue> classNames = new ArrayList<AnnotationValue>();
        HashMap<Object, QName> qNames = new HashMap<Object, QName>();
        for (Declaration declaration : methods) {
            AnnotationMirror responseWrapper;
            if (!(declaration instanceof MethodDeclaration)) continue;
            AnnotationMirror requestWrapper = AnnotationUtils.getAnnotation((Declaration)declaration, RequestWrapper.class);
            if (requestWrapper != null) {
                this.addClassName(requestWrapper, "className", classNames);
                this.addLocalName(requestWrapper, "localName", (MethodDeclaration)declaration, qNames);
            }
            if ((responseWrapper = AnnotationUtils.getAnnotation((Declaration)declaration, ResponseWrapper.class)) == null) continue;
            this.addClassName(responseWrapper, "className", classNames);
            this.addLocalName(responseWrapper, "localName", (MethodDeclaration)declaration, qNames);
        }
        HashSet thrownTypes = new HashSet();
        for (MethodDeclaration methodDeclaration : methodDeclarations) {
            thrownTypes.addAll(methodDeclaration.getThrownTypes());
        }
        for (ReferenceType referenceType : thrownTypes) {
            ClassDeclaration classDeclaration;
            AnnotationMirror webFault;
            if (!(referenceType instanceof ClassDeclaration) || (webFault = AnnotationUtils.getAnnotation((Declaration)(classDeclaration = (ClassDeclaration)referenceType), WebFault.class)) == null) continue;
            this.addClassName(webFault, "faultBean", classNames);
        }
        boolean bl = false;
        while (var9_14 < classNames.size()) {
            AnnotationValue className = (AnnotationValue)classNames.get((int)var9_14);
            void j = var9_14 + true;
            while (j < classNames.size()) {
                AnnotationValue otherClassName = (AnnotationValue)classNames.get((int)j);
                if (className.getValue().toString().equalsIgnoreCase(otherClassName.getValue().toString())) {
                    this.printError(className.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.WRAPPER_FAULT_BEAN_NAMES_MUST_BE_UNIQUE, (Object)className));
                    this.printError(otherClassName.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.WRAPPER_FAULT_BEAN_NAMES_MUST_BE_UNIQUE, (Object)otherClassName));
                }
                ++j;
            }
            ++var9_14;
        }
        this.validateQNames(qNames, JAXWSCoreMessages.LOCAL_NAME_ATTRIBUTES_MUST_BE_UNIQUE);
    }

    private void validateQNames(Map<Object, QName> qNames, String errorMessage) {
        Object[] keys = qNames.keySet().toArray(new Object[qNames.size()]);
        QName[] values = qNames.values().toArray(new QName[qNames.size()]);
        int i = 0;
        while (i < values.length) {
            QName qName = values[i];
            int j = i + 1;
            while (j < values.length) {
                QName otherQName = values[j];
                if (qName.equals(otherQName)) {
                    this.printError(this.getPosition(keys[i]), JAXWSCoreMessages.bind((String)errorMessage, (Object)qName));
                    this.printError(this.getPosition(keys[j]), JAXWSCoreMessages.bind((String)errorMessage, (Object)otherQName));
                }
                ++j;
            }
            ++i;
        }
    }

    private void addClassName(AnnotationMirror annotationMirror, String attributeKey, List<AnnotationValue> classNames) {
        AnnotationValue className = AnnotationUtils.getAnnotationValue((AnnotationMirror)annotationMirror, (String)attributeKey);
        if (className != null) {
            classNames.add(className);
        }
    }

    private void addLocalName(AnnotationMirror annotationMirror, String attributeKey, MethodDeclaration methodDeclaration, Map<Object, QName> qNames) {
        AnnotationValue localNameValue = AnnotationUtils.getAnnotationValue((AnnotationMirror)annotationMirror, (String)attributeKey);
        if (localNameValue != null) {
            qNames.put(localNameValue, new QName(this.getTargetNamespace(annotationMirror, methodDeclaration), localNameValue.getValue().toString()));
        }
    }

    private void checkDocumentBareMethods(Collection<? extends MethodDeclaration> methods) {
        ArrayList<MethodDeclaration> docBareMethods = new ArrayList<MethodDeclaration>();
        for (MethodDeclaration methodDeclaration : methods) {
            if (!this.hasDocumentBareSOAPBinding((Declaration)methodDeclaration)) continue;
            docBareMethods.add(methodDeclaration);
        }
        HashMap<Object, QName> hashMap = new HashMap<Object, QName>();
        for (MethodDeclaration methodDeclaration : docBareMethods) {
            this.getDocumentBareOperationRequest(methodDeclaration, hashMap);
            this.getDocumentBareOperationResponse(methodDeclaration, hashMap);
        }
        this.validateQNames(hashMap, JAXWSCoreMessages.DOC_BARE_METHODS_UNIQUE_XML_ELEMENTS);
    }

    private SourcePosition getPosition(Object value) {
        if (value instanceof AnnotationValue) {
            return ((AnnotationValue)value).getPosition();
        }
        if (value instanceof MethodDeclaration) {
            return ((MethodDeclaration)value).getPosition();
        }
        if (value instanceof ParameterDeclaration) {
            return ((ParameterDeclaration)value).getPosition();
        }
        return null;
    }

    private void getDocumentBareOperationRequest(MethodDeclaration methodDeclaration, Map<Object, QName> qNames) {
        Collection parameters = methodDeclaration.getParameters();
        for (ParameterDeclaration parameterDeclaration : parameters) {
            AnnotationMirror webParam = AnnotationUtils.getAnnotation((Declaration)parameterDeclaration, WebParam.class);
            if (webParam != null) {
                String mode = this.getWebParamMode(webParam, parameterDeclaration);
                if (!mode.equals(WebParam.Mode.IN.name()) && !mode.equals(WebParam.Mode.INOUT.name())) continue;
                this.getOperationRequest(webParam, methodDeclaration, parameterDeclaration, qNames);
                continue;
            }
            qNames.put(parameterDeclaration, this.getOperationRequestDefault(methodDeclaration));
        }
    }

    private void getOperationRequest(AnnotationMirror annotationMirror, MethodDeclaration methodDeclaration, ParameterDeclaration parameterDeclaration, Map<Object, QName> qNames) {
        AnnotationValue name = AnnotationUtils.getAnnotationValue((AnnotationMirror)annotationMirror, (String)"name");
        if (name != null) {
            QName qName = new QName(this.getTargetNamespace(annotationMirror, methodDeclaration), name.getValue().toString());
            qNames.put(name, qName);
        } else {
            qNames.put(parameterDeclaration, this.getOperationRequestDefault(methodDeclaration));
        }
    }

    private QName getOperationRequestDefault(MethodDeclaration methodDeclaration) {
        return new QName(this.getTargetNamespace(methodDeclaration.getDeclaringType()), methodDeclaration.getSimpleName());
    }

    private void getDocumentBareOperationResponse(MethodDeclaration methodDeclaration, Map<Object, QName> qNames) {
        if (!this.returnsVoid(methodDeclaration)) {
            this.getOperationResponse(AnnotationUtils.getAnnotation((Declaration)methodDeclaration, WebResult.class), methodDeclaration, qNames);
        } else {
            Collection parameters = methodDeclaration.getParameters();
            for (ParameterDeclaration parameterDeclaration : parameters) {
                AnnotationMirror webParam = AnnotationUtils.getAnnotation((Declaration)parameterDeclaration, WebParam.class);
                if (webParam != null) {
                    String mode = this.getWebParamMode(webParam, parameterDeclaration);
                    if (!mode.equals(WebParam.Mode.OUT.name()) && (!mode.equals(WebParam.Mode.INOUT.name()) || this.isHeader(webParam))) continue;
                    this.getOperationResponse(webParam, methodDeclaration, qNames);
                    break;
                }
                if (!this.getDefaultWebParamMode(parameterDeclaration).equals(WebParam.Mode.INOUT.name())) continue;
                qNames.put(parameterDeclaration, this.getOperationResponseDefault(methodDeclaration));
                break;
            }
        }
    }

    private void getOperationResponse(AnnotationMirror annotationMirror, MethodDeclaration methodDeclaration, Map<Object, QName> qNames) {
        if (annotationMirror != null) {
            AnnotationValue name = AnnotationUtils.getAnnotationValue((AnnotationMirror)annotationMirror, (String)"name");
            if (name != null) {
                qNames.put(name, new QName(this.getTargetNamespace(annotationMirror, methodDeclaration), name.getValue().toString()));
            } else {
                qNames.put(methodDeclaration, this.getOperationResponseDefault(methodDeclaration));
            }
        } else {
            qNames.put(methodDeclaration, this.getOperationResponseDefault(methodDeclaration));
        }
    }

    private QName getOperationResponseDefault(MethodDeclaration methodDeclaration) {
        return new QName(this.getTargetNamespace(methodDeclaration.getDeclaringType()), String.valueOf(methodDeclaration.getSimpleName()) + "Response");
    }

    private boolean isHeader(AnnotationMirror annotationMirror) {
        Boolean header = AnnotationUtils.getBooleanValue((AnnotationMirror)annotationMirror, (String)"header");
        if (header != null) {
            return header;
        }
        return false;
    }

    private String getWebParamMode(AnnotationMirror annotationMirror, ParameterDeclaration parameterDeclaration) {
        String mode = AnnotationUtils.getStringValue((AnnotationMirror)annotationMirror, (String)"mode");
        if (mode == null || mode.length() == 0) {
            mode = this.getDefaultWebParamMode(parameterDeclaration);
        }
        return mode;
    }

    private String getDefaultWebParamMode(ParameterDeclaration parameterDeclaration) {
        TypeMirror typeMirror = this.environment.getTypeUtils().getErasure(parameterDeclaration.getType());
        if (typeMirror.toString().equals(Holder.class.getCanonicalName())) {
            return WebParam.Mode.INOUT.name();
        }
        return WebParam.Mode.IN.name();
    }

    private boolean returnsVoid(MethodDeclaration methodDeclaration) {
        return methodDeclaration.getReturnType().equals((Object)this.environment.getTypeUtils().getVoidType());
    }

    private void checkMethodParameters(Collection<? extends MethodDeclaration> methodDeclarations) {
        ArrayList<MethodDeclaration> methods = new ArrayList<MethodDeclaration>();
        for (MethodDeclaration methodDeclaration : methodDeclarations) {
            if (this.hasDocumentBareSOAPBinding((Declaration)methodDeclaration)) continue;
            methods.add(methodDeclaration);
        }
        for (MethodDeclaration methodDeclaration : methods) {
            ArrayList<AnnotationValue> names = new ArrayList<AnnotationValue>();
            List parameters = (List)methodDeclaration.getParameters();
            for (ParameterDeclaration parameterDeclaration : parameters) {
                AnnotationValue name;
                AnnotationMirror webParam = AnnotationUtils.getAnnotation((Declaration)parameterDeclaration, WebParam.class);
                if (webParam == null || (name = AnnotationUtils.getAnnotationValue((AnnotationMirror)webParam, (String)"name")) == null) continue;
                names.add(name);
                this.testForGeneratedNameClash(name, parameterDeclaration, parameters);
            }
            int i = 0;
            while (i < names.size()) {
                AnnotationValue name = (AnnotationValue)names.get(i);
                int j = i + 1;
                while (j < names.size()) {
                    AnnotationValue otherName = (AnnotationValue)names.get(j);
                    if (name.toString().equals(otherName.toString())) {
                        this.printError(name.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.PARAMETER_NAME_CLASH, (Object)name.getValue().toString()));
                        this.printError(otherName.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.PARAMETER_NAME_CLASH, (Object)otherName.getValue().toString()));
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void testForGeneratedNameClash(AnnotationValue webParamName, ParameterDeclaration parameter, List<ParameterDeclaration> parameters) {
        int argN;
        String name = webParamName.toString();
        Matcher matcher = pattern.matcher(name);
        if (matcher.matches() && (argN = Integer.parseInt(name.substring(3))) != parameters.indexOf(parameter) && argN < parameters.size()) {
            ParameterDeclaration parameterN = parameters.get(argN);
            AnnotationMirror webParamN = AnnotationUtils.getAnnotation((Declaration)parameterN, WebParam.class);
            if (webParamN != null) {
                AnnotationValue webParamNameN = AnnotationUtils.getAnnotationValue((AnnotationMirror)webParamN, (String)"name");
                if (webParamNameN == null) {
                    this.printError(parameterN.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.GENERATED_PARAMETER_NAME_CLASH, (Object)name));
                    this.printError(webParamName.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.GENERATED_PARAMETER_NAME_CLASH, (Object)name));
                } else if (webParamNameN.toString().length() == 0) {
                    this.printError(webParamNameN.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.GENERATED_PARAMETER_NAME_CLASH, (Object)name));
                    this.printError(webParamName.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.GENERATED_PARAMETER_NAME_CLASH, (Object)name));
                }
            } else {
                this.printError(parameterN.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.GENERATED_PARAMETER_NAME_CLASH, (Object)name));
                this.printError(webParamName.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.GENERATED_PARAMETER_NAME_CLASH, (Object)name));
            }
        }
    }

    private String getTargetNamespace(TypeDeclaration typeDeclaration) {
        String targetNamespace = this.getAttributeValue((Declaration)typeDeclaration, WebService.class, "targetNamespace");
        if (targetNamespace != null) {
            return targetNamespace;
        }
        return JDTUtils.getTargetNamespaceFromPackageName(typeDeclaration.getPackage().getQualifiedName());
    }

    private String getTargetNamespace(AnnotationMirror annotationMirror, MethodDeclaration methodDeclaration) {
        String targetNamespace = AnnotationUtils.getStringValue((AnnotationMirror)annotationMirror, (String)"targetNamespace");
        if (targetNamespace == null) {
            targetNamespace = this.getTargetNamespace(methodDeclaration.getDeclaringType());
        }
        return targetNamespace;
    }

    private String getOperationName(MethodDeclaration methodDeclaration) {
        String operationName = this.getAttributeValue((Declaration)methodDeclaration, WebMethod.class, "operationName");
        if (operationName != null) {
            return operationName;
        }
        return methodDeclaration.getSimpleName();
    }

    private boolean hasDocumentBareSOAPBinding(Declaration declaration) {
        AnnotationMirror soapBinding = AnnotationUtils.getAnnotation((Declaration)declaration, SOAPBinding.class);
        if (soapBinding != null) {
            return JAXWSUtils.isDocumentBare(soapBinding);
        }
        if (declaration instanceof MethodDeclaration) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)declaration;
            return this.hasDocumentBareSOAPBinding((Declaration)methodDeclaration.getDeclaringType());
        }
        return false;
    }
}

