/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context;

import java.util.List;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.jpa.core.context.OverrideContainer;
import org.eclipse.jpt.jpa.core.context.Override_;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.OverrideTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OverrideValidator
implements JptValidator {
    protected final PersistentAttribute persistentAttribute;
    protected final Override_ override;
    protected final OverrideContainer container;
    protected final OverrideTextRangeResolver textRangeResolver;
    protected final OverrideDescriptionProvider overrideDescriptionProvider;

    protected OverrideValidator(Override_ override, OverrideContainer container, OverrideTextRangeResolver textRangeResolver, OverrideDescriptionProvider overrideDescriptionProvider) {
        this(null, override, container, textRangeResolver, overrideDescriptionProvider);
    }

    protected OverrideValidator(PersistentAttribute persistentAttribute, Override_ override, OverrideContainer container, OverrideTextRangeResolver textRangeResolver, OverrideDescriptionProvider overrideDescriptionProvider) {
        this.persistentAttribute = persistentAttribute;
        this.override = override;
        this.container = container;
        this.textRangeResolver = textRangeResolver;
        this.overrideDescriptionProvider = overrideDescriptionProvider;
    }

    protected String getOverrideDescriptionMessage() {
        return this.overrideDescriptionProvider.getOverrideDescriptionMessage();
    }

    @Override
    public boolean validate(List<IMessage> messages, IReporter reporter) {
        if (!this.validateType(messages)) {
            return this.validateName(messages);
        }
        return true;
    }

    protected boolean validateType(List<IMessage> messages) {
        if (this.container.getOverridableTypeMapping() == null) {
            messages.add(this.buildUnresolvedOverrideTypeMessage());
            return true;
        }
        return false;
    }

    protected IMessage buildUnresolvedOverrideTypeMessage() {
        if (this.override.isVirtual()) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_OVERRIDE_INVALID_TYPE", new String[]{this.override.getName()}, this.override, this.textRangeResolver.getNameTextRange());
        }
        return DefaultJpaValidationMessages.buildMessage(1, "ATTRIBUTE_OVERRIDE_INVALID_TYPE", new String[]{this.override.getName()}, this.override, this.textRangeResolver.getNameTextRange());
    }

    protected boolean validateName(List<IMessage> messages) {
        if (!CollectionTools.contains(this.container.allOverridableNames(), (Object)this.override.getName())) {
            messages.add(this.buildUnresolvedNameMessage());
            return false;
        }
        return true;
    }

    protected IMessage buildUnresolvedNameMessage() {
        if (this.override.isVirtual()) {
            return this.buildVirtualUnresolvedNameMessage();
        }
        if (this.overrideParentIsVirtualAttribute()) {
            return this.buildVirtualAttributeUnresolvedNameMessage();
        }
        return this.buildUnresolvedNameMessage(this.getUnresolvedNameMessage());
    }

    protected IMessage buildVirtualUnresolvedNameMessage() {
        return DefaultJpaValidationMessages.buildMessage(1, this.getVirtualOverrideUnresolvedNameMessage(), new String[]{this.override.getName(), this.getOverrideDescriptionMessage(), this.container.getOverridableTypeMapping().getName()}, this.override, this.textRangeResolver.getNameTextRange());
    }

    protected abstract String getVirtualOverrideUnresolvedNameMessage();

    protected IMessage buildUnresolvedNameMessage(String message) {
        return DefaultJpaValidationMessages.buildMessage(1, message, new String[]{this.override.getName(), this.getOverrideDescriptionMessage(), this.container.getOverridableTypeMapping().getName()}, this.override, this.textRangeResolver.getNameTextRange());
    }

    protected abstract String getUnresolvedNameMessage();

    protected IMessage buildVirtualAttributeUnresolvedNameMessage() {
        return DefaultJpaValidationMessages.buildMessage(1, this.getVirtualAttributeUnresolvedNameMessage(), new String[]{this.persistentAttribute.getName(), this.override.getName(), this.getOverrideDescriptionMessage(), this.container.getOverridableTypeMapping().getName()}, this.override, this.textRangeResolver.getNameTextRange());
    }

    protected abstract String getVirtualAttributeUnresolvedNameMessage();

    protected boolean overrideParentIsVirtualAttribute() {
        return this.persistentAttribute != null && this.persistentAttribute.isVirtual();
    }

    public static interface OverrideDescriptionProvider {
        public String getOverrideDescriptionMessage();
    }
}

