/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa1.context.persistence;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaResourceType;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.JpaRootContextNode;
import org.eclipse.jpt.core.context.persistence.Persistence;
import org.eclipse.jpt.core.internal.context.persistence.AbstractPersistenceXmlContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.jpa2.context.persistence.Persistence2_0;
import org.eclipse.jpt.core.jpa2.context.persistence.PersistenceXml2_0;
import org.eclipse.jpt.core.resource.persistence.XmlPersistence;
import org.eclipse.jpt.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericPersistenceXml
extends AbstractPersistenceXmlContextNode
implements PersistenceXml2_0 {
    protected JpaXmlResource xmlResource;
    protected JpaResourceType resourceType;
    protected Persistence persistence;

    public GenericPersistenceXml(JpaRootContextNode parent, JpaXmlResource resource) {
        super(parent);
        if (!resource.getContentType().isKindOf(JptCorePlugin.PERSISTENCE_XML_CONTENT_TYPE)) {
            throw new IllegalArgumentException("Resource " + resource + " must have persistence xml content type");
        }
        this.xmlResource = resource;
        if (resource.getRootObject() != null) {
            this.persistence = this.buildPersistence((XmlPersistence)resource.getRootObject());
            this.resourceType = resource.getResourceType();
        }
    }

    @Override
    public JpaXmlResource getXmlResource() {
        return this.xmlResource;
    }

    @Override
    public IResource getResource() {
        return this.xmlResource.getFile();
    }

    @Override
    public JpaResourceType getResourceType() {
        return this.xmlResource.getResourceType();
    }

    @Override
    public Persistence getPersistence() {
        return this.persistence;
    }

    protected void setPersistence(Persistence persistence) {
        Persistence old = this.persistence;
        this.persistence = persistence;
        this.firePropertyChanged("persistence", old, persistence);
    }

    protected Persistence buildPersistence(XmlPersistence xmlPersistence) {
        return this.getContextNodeFactory().buildPersistence(this, xmlPersistence);
    }

    @Override
    public void initializeMetamodel() {
        if (this.persistence != null) {
            ((Persistence2_0)this.persistence).initializeMetamodel();
        }
    }

    @Override
    public void synchronizeMetamodel() {
        if (this.persistence != null) {
            ((Persistence2_0)this.persistence).synchronizeMetamodel();
        }
    }

    @Override
    public void disposeMetamodel() {
        if (this.persistence != null) {
            ((Persistence2_0)this.persistence).disposeMetamodel();
        }
    }

    @Override
    public void update() {
        XmlPersistence oldXmlPersistence = this.persistence == null ? null : this.persistence.getXmlPersistence();
        XmlPersistence newXmlPersistence = (XmlPersistence)this.xmlResource.getRootObject();
        JpaResourceType newResourceType = this.xmlResource.getResourceType();
        if ((oldXmlPersistence != newXmlPersistence || newXmlPersistence == null || this.valuesAreDifferent(this.resourceType, newResourceType)) && this.persistence != null) {
            this.getJpaFile().removeRootStructureNode(this.xmlResource);
            this.persistence.dispose();
            this.setPersistence(null);
        }
        this.resourceType = newResourceType;
        if (newXmlPersistence != null) {
            if (this.persistence != null) {
                this.persistence.update(newXmlPersistence);
            } else {
                this.setPersistence(this.buildPersistence(newXmlPersistence));
            }
            this.getJpaFile().addRootStructureNode(this.xmlResource, this.persistence);
        }
    }

    @Override
    public void postUpdate() {
        super.postUpdate();
        if (this.persistence != null) {
            this.persistence.postUpdate();
        }
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        if (this.persistence.containsOffset(textOffset)) {
            return this.persistence.getStructureNode(textOffset);
        }
        return this;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return TextRange.Empty.instance();
    }

    @Override
    public void dispose() {
        JpaFile jpaFile;
        if (this.persistence != null) {
            this.persistence.dispose();
        }
        if ((jpaFile = this.getJpaFile()) != null) {
            jpaFile.removeRootStructureNode(this.xmlResource);
        }
    }

    protected JpaFile getJpaFile() {
        return this.getJpaFile(this.xmlResource.getFile());
    }

    @Override
    public TextRange getValidationTextRange() {
        return TextRange.Empty.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.persistence == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_XML_INVALID_CONTENT", this));
            return;
        }
        this.persistence.validate(messages, reporter);
    }
}

