/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal;

import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.jsp.core.internal.JSPCoreMessages;
import org.eclipse.jst.jsp.core.internal.JSPCorePlugin;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.contentmodel.TaglibController;
import org.eclipse.jst.jsp.core.internal.contentproperties.JSPFContentPropertiesManager;
import org.eclipse.jst.jsp.core.internal.contenttype.DeploymentDescriptorPropertyCache;
import org.eclipse.jst.jsp.core.internal.java.search.JSPIndexManager;
import org.eclipse.jst.jsp.core.internal.taglib.TaglibHelperManager;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.osgi.framework.BundleContext;

public class JSPCorePlugin
extends Plugin {
    private static JSPCorePlugin plugin;
    private Job fPluginInitializerJob;

    public JSPCorePlugin() {
        plugin = this;
        this.fPluginInitializerJob = new PluginInitializerJob();
    }

    public static JSPCorePlugin getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        TaglibIndex.startup();
        TaglibController.startup();
        JavaCore.addElementChangedListener((IElementChangedListener)TaglibHelperManager.getInstance());
        this.fPluginInitializerJob.schedule(2000L);
        JSPFContentPropertiesManager.startup();
        DeploymentDescriptorPropertyCache.start();
    }

    public void stop(BundleContext context) throws Exception {
        DeploymentDescriptorPropertyCache.stop();
        JSPFContentPropertiesManager.shutdown();
        ResourcesPlugin.getWorkspace().removeSaveParticipant(plugin.getBundle().getSymbolicName());
        JSPIndexManager.getDefault().stop();
        JavaCore.removeElementChangedListener((IElementChangedListener)TaglibHelperManager.getInstance());
        TaglibController.shutdown();
        TaglibIndex.shutdown();
        super.stop(context);
    }

    static /* synthetic */ JSPCorePlugin access$0() {
        return plugin;
    }

    private static class PluginInitializerJob
    extends Job {
        protected PluginInitializerJob() {
            super(JSPCoreMessages.Initializing);
            this.setUser(false);
            this.setSystem(true);
            this.setPriority(30);
        }

        protected IStatus run(IProgressMonitor monitor) {
            IStatus status = Status.OK_STATUS;
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            try {
                workspace.run(new IWorkspaceRunnable(this){
                    final /* synthetic */ PluginInitializerJob this$1;
                    {
                        this.this$1 = pluginInitializerJob;
                    }

                    /*
                     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run(IProgressMonitor worspaceMonitor) throws CoreException {
                        ISavedState savedState = null;
                        try {
                            savedState = ResourcesPlugin.getWorkspace().addSaveParticipant(JSPCorePlugin.access$0().getBundle().getSymbolicName(), (ISaveParticipant)new SaveParticipant());
                        }
                        catch (CoreException e) {
                            Logger.logException("JSP Core Plugin failed at loading previously saved state. All componenets dependent on this state will start as if first workspace load.", e);
                        }
                        if (savedState == null) {
                            JSPIndexManager.getDefault().start(null, worspaceMonitor);
                            return;
                        }
                        try {
                            Thread.currentThread().setPriority(1);
                        }
                        catch (Throwable throwable) {
                            Object var3_4 = null;
                            savedState.processResourceChangeEvents(new IResourceChangeListener(this, worspaceMonitor){
                                final /* synthetic */ 1 this$2;
                                private final /* synthetic */ IProgressMonitor val$worspaceMonitor;
                                {
                                    this.this$2 = var1_1;
                                    this.val$worspaceMonitor = iProgressMonitor;
                                }

                                public void resourceChanged(IResourceChangeEvent event) {
                                    JSPIndexManager.getDefault().start(event.getDelta(), this.val$worspaceMonitor);
                                }
                            });
                            throw throwable;
                        }
                        {
                            Object var3_5 = null;
                            savedState.processResourceChangeEvents(new /* invalid duplicate definition of identical inner class */);
                            return;
                        }
                    }
                }, monitor);
            }
            catch (CoreException e) {
                status = e.getStatus();
            }
            return status;
        }
    }

    private static class SaveParticipant
    implements ISaveParticipant {
        protected SaveParticipant() {
        }

        public void doneSaving(ISaveContext context) {
        }

        public void prepareToSave(ISaveContext context) throws CoreException {
        }

        public void rollback(ISaveContext context) {
        }

        public void saving(ISaveContext context) throws CoreException {
            context.needDelta();
        }
    }
}

