/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ejb.ui.internal.wizard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jst.ejb.ui.internal.util.EJBUIMessages;
import org.eclipse.jst.ejb.ui.internal.wizard.AddSessionBeanWizardPage;
import org.eclipse.jst.ejb.ui.internal.wizard.BusinessInterfaceSelectionDialog;
import org.eclipse.jst.ejb.ui.internal.wizard.BusinessInterfaceSelectionExtension;
import org.eclipse.jst.j2ee.ejb.internal.operations.BusinessInterface;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddButtonListener
implements SelectionListener {
    private static final String SEARCH_FILTER = "**";
    private static final String EMPTY = "";
    private AddSessionBeanWizardPage page;
    private IDataModel model;

    public AddButtonListener(AddSessionBeanWizardPage page, IDataModel model) {
        this.page = page;
        this.model = model;
    }

    public void widgetSelected(SelectionEvent e) {
        List biList;
        String text;
        IType type;
        BusinessInterface iface = this.chooseEnclosingType(this.getRoots(), new String[]{"All_APIs"}, this.page.getShell(), (IRunnableContext)this.page.getWizard().getContainer(), 6, EMPTY);
        if (iface != null && (type = iface.getJavaType()) != null && !this.hasInterface(text = type.getFullyQualifiedName(), biList = (List)this.model.getProperty("NewJavaClassDataModel.INTERFACES"))) {
            biList.add(iface);
            this.model.setProperty("NewJavaClassDataModel.INTERFACES", (Object)biList);
            this.model.notifyPropertyChange("NewJavaClassDataModel.INTERFACES", 1);
            this.page.updateBusinessInterfacesList();
        }
    }

    private IPackageFragmentRoot[] getRoots() {
        return null;
    }

    public BusinessInterface chooseEnclosingType(IPackageFragmentRoot[] root, String[] jdkTypes, Shell shell, IRunnableContext container, int type, String currentSelection) {
        BusinessInterface ret = null;
        String currSelection = SEARCH_FILTER;
        IJavaSearchScope scope = AddButtonListener.buildJavaSearchScope(root, jdkTypes);
        if (currentSelection != null && !currentSelection.equals(EMPTY)) {
            currSelection = currentSelection;
        }
        TypeSelectionExtension selectionExtension = this.createTypeSelectionExtension();
        BusinessInterfaceSelectionDialog dialog = new BusinessInterfaceSelectionDialog(shell, false, null, scope, type, selectionExtension);
        dialog.setTitle(EJBUIMessages.chooseInterface);
        dialog.setMessage(EJBUIMessages.chooseInterface);
        dialog.setInitialPattern(currSelection);
        if (dialog.open() == 0) {
            ret = dialog.getResult()[0];
        }
        return ret;
    }

    public boolean hasInterface(String text, List<BusinessInterface> biList) {
        for (BusinessInterface element : biList) {
            if (!element.getFullyQualifiedName().equals(text)) continue;
            return true;
        }
        return false;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private static IJavaSearchScope buildJavaSearchScope(IPackageFragmentRoot[] root, String[] jdkTypes) {
        IJavaProject project = null;
        ArrayList<IPackageFragmentRoot> pkgRoots = new ArrayList<IPackageFragmentRoot>();
        if (root != null) {
            if (root.length == 1 && root[0] != null) {
                project = root[0].getJavaProject();
                pkgRoots.add(root[0]);
            } else {
                pkgRoots.addAll(Arrays.asList(root));
            }
        }
        if (jdkTypes != null) {
            IJavaProject[] prjs = new IJavaProject[]{project};
            if (project == null) {
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                ArrayList<IJavaProject> javaProjects = new ArrayList<IJavaProject>();
                IProject[] iProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject p = iProjectArray[n2];
                    javaProjects.add(JavaCore.create((IProject)p));
                    ++n2;
                }
                prjs = javaProjects.toArray(new IJavaProject[javaProjects.size()]);
            }
            int i = 0;
            while (prjs != null && i < prjs.length) {
                try {
                    pkgRoots.addAll(Arrays.asList(prjs[i].getAllPackageFragmentRoots()));
                }
                catch (JavaModelException javaModelException) {}
                ++i;
            }
        }
        IPackageFragmentRoot[] roots = new IPackageFragmentRoot[pkgRoots.size()];
        try {
            pkgRoots.toArray(roots);
        }
        catch (ArrayStoreException arrayStoreException) {
            return null;
        }
        return SearchEngine.createJavaSearchScope((IJavaElement[])roots);
    }

    private TypeSelectionExtension createTypeSelectionExtension() {
        return new BusinessInterfaceSelectionExtension();
    }
}

