/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.reconcile.validator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.extension.RegistryReader;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ValidatorMetaData;

public class ValidatorBuilder
extends RegistryReader {
    public static final String ATT_CLASS = "class";
    public static final String ATT_ID = "id";
    public static final String ATT_SCOPE = "scope";
    public static final ValidatorMetaData[] EMTPY_VMD_ARRAY = new ValidatorMetaData[0];
    public static final String PL_SOURCE_VALIDATION = "sourcevalidation";
    public static final String PLUGIN_ID = "org.eclipse.wst.sse.ui";
    public static final String TAG_CONTENT_TYPE_IDENTIFIER = "contentTypeIdentifier";
    public static final String TAG_PARTITION_TYPE = "partitionType";
    public static final String TAG_VALIDATOR = "validator";
    public static final String TRACE_FILTER = "reconcile_validator";
    public static final String TRUE = "true";
    private String fCurrentCTID;
    private ValidatorMetaData fCurrentVMD = null;
    private List fVmds = new ArrayList();
    protected String targetContributionTag;
    protected String targetID;
    private final String UNKNOWN = "???";

    protected String getID(IConfigurationElement element) {
        String value = element.getAttribute(ATT_ID);
        return value != null ? value : "???";
    }

    protected String getValidatorClass(IConfigurationElement element) {
        String value = element.getAttribute(ATT_CLASS);
        return value != null ? value : "???";
    }

    public ValidatorMetaData[] getValidatorMetaData(String editorId) {
        this.readContributions(editorId, TAG_VALIDATOR, PL_SOURCE_VALIDATION);
        return this.fVmds.toArray(new ValidatorMetaData[this.fVmds.size()]);
    }

    protected String getValidatorScope(IConfigurationElement element) {
        String value = element.getAttribute(ATT_SCOPE);
        return value != null ? value : "???";
    }

    protected void readContributions(String id, String tag, String extensionPoint) {
        this.targetID = id;
        this.targetContributionTag = tag;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        this.readRegistry(registry, PLUGIN_ID, extensionPoint);
    }

    protected boolean readElement(IConfigurationElement element) {
        String tag = element.getName();
        if (tag.equals(this.targetContributionTag)) {
            String vId = this.getID(element);
            String vClass = this.getValidatorClass(element);
            String vScope = this.getValidatorScope(element);
            if (vId == null) {
                return true;
            }
            this.fCurrentVMD = new ValidatorMetaData(element, vId, vClass, vScope);
            this.fVmds.add(this.fCurrentVMD);
            if (Logger.isTracing(TRACE_FILTER)) {
                System.out.println("added reconcile validator: " + vId + ":" + vClass + ":" + vScope);
            }
        } else if (tag.equals(TAG_CONTENT_TYPE_IDENTIFIER)) {
            this.fCurrentCTID = this.getID(element);
            this.fCurrentVMD.addContentTypeId(this.fCurrentCTID);
        } else {
            if (tag.equals(TAG_PARTITION_TYPE)) {
                String partitionType = this.getID(element);
                this.fCurrentVMD.addParitionType(this.fCurrentCTID, partitionType);
                return true;
            }
            return false;
        }
        this.readElementChildren(element);
        return true;
    }
}

