/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.core.jsdi.ObjectReference;
import org.eclipse.wst.jsdt.debug.core.jsdi.Value;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFMirror;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFStackFrame;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFVariable;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFVirtualMachine;

public class CFObjectReference
extends CFMirror
implements ObjectReference {
    public static final String OBJECT = "object";
    private CFStackFrame frame = null;
    private String classname = null;
    private Number handle = null;
    private Number constref = null;
    private Number protoref = null;
    private Value constructor = null;
    private Value prototype = null;
    private List properties = null;
    private String source = null;

    public CFObjectReference(CFVirtualMachine vm, CFStackFrame frame, Map body) {
        super(vm);
        this.frame = frame;
        this.handle = (Number)body.get("handle");
        this.source = (String)body.get("source");
        Map props = (Map)body.get("result");
        if (props == null) {
            Object o = body.get("value");
            if (o instanceof Map) {
                props = (Map)body.get("value");
            } else if (this.handle == null) {
                props = body;
            }
        }
        if (props != null) {
            if (this.properties == null) {
                this.properties = new ArrayList(props.size());
            }
            Map.Entry entry = null;
            String name = null;
            Map json = null;
            Number ref = null;
            Iterator i = props.entrySet().iterator();
            while (i.hasNext()) {
                entry = i.next();
                name = (String)entry.getKey();
                if (entry.getValue() instanceof Map) {
                    Object handle;
                    json = (Map)entry.getValue();
                    Object type = json.get("type");
                    if (!(type instanceof String) || (handle = json.get("handle")) != null && !(handle instanceof Number)) continue;
                    ref = (Number)handle;
                    if ("constructor".equals(name)) {
                        this.constref = ref;
                        continue;
                    }
                    if ("proto".equals(name)) {
                        this.protoref = ref;
                        continue;
                    }
                }
                this.properties.add(new CFVariable(this.crossfire(), frame, name, ref, json));
            }
        }
    }

    public String valueString() {
        if (this.source != null) {
            return this.source;
        }
        return OBJECT;
    }

    public String className() {
        return this.classname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value constructor() {
        CFStackFrame cFStackFrame = this.frame;
        synchronized (cFStackFrame) {
            if (this.constructor == null) {
                if (this.constref == null) {
                    this.constructor = this.crossfire().mirrorOfUndefined();
                }
                this.constructor = this.frame.lookup(this.constref);
            }
        }
        return this.constructor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value prototype() {
        CFStackFrame cFStackFrame = this.frame;
        synchronized (cFStackFrame) {
            if (this.prototype == null) {
                if (this.protoref == null) {
                    this.prototype = this.crossfire().mirrorOfUndefined();
                }
                this.prototype = this.frame.lookup(this.protoref);
            }
        }
        return this.prototype;
    }

    public List properties() {
        return this.properties;
    }

    public Number id() {
        return this.handle;
    }

    protected CFStackFrame frame() {
        return this.frame;
    }

    protected String source() {
        return this.source;
    }
}

