/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.launching;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptModel;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJsGlobalScopeContainer;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.UnimplementedException;
import org.eclipse.wst.jsdt.core.compiler.libraries.SystemLibraryLocation;
import org.eclipse.wst.jsdt.launching.IRuntimeClasspathEntry;
import org.eclipse.wst.jsdt.launching.IRuntimeClasspathEntryResolver;
import org.eclipse.wst.jsdt.launching.IRuntimeClasspathEntryResolver2;
import org.eclipse.wst.jsdt.launching.IVMInstall;
import org.eclipse.wst.jsdt.launching.IVMInstallChangedListener;
import org.eclipse.wst.jsdt.launching.IVMInstallType;
import org.eclipse.wst.jsdt.launching.JREContainerInitializer;
import org.eclipse.wst.jsdt.launching.LaunchingMessages;
import org.eclipse.wst.jsdt.launching.LibraryLocation;
import org.eclipse.wst.jsdt.launching.ListenerList;
import org.eclipse.wst.jsdt.launching.PropertyChangeEvent;
import org.eclipse.wst.jsdt.launching.StandardVM;
import org.eclipse.wst.jsdt.launching.StandardVMType;

public final class JavaRuntime {
    public static final String JRELIB_VARIABLE = "JRE_LIB";
    public static final String JRESRC_VARIABLE = "JRE_SRC";
    public static final String JRESRCROOT_VARIABLE = "JRE_SRCROOT";
    public static final String EXTENSION_POINT_RUNTIME_CLASSPATH_ENTRY_RESOLVERS = "runtimeClasspathEntryResolvers";
    public static final String EXTENSION_POINT_RUNTIME_CLASSPATH_PROVIDERS = "classpathProviders";
    public static final String EXTENSION_POINT_EXECUTION_ENVIRONMENTS = "executionEnvironments";
    public static final String EXTENSION_POINT_VM_INSTALLS = "vmInstalls";
    public static final String JRE_CONTAINER = "org.eclipse.wst.jsdt.launching.JRE_CONTAINER";
    public static final String BASE_BROWSER_LIB = "org.eclipse.wst.jsdt.launching.baseBrowserLibrary";
    public static final String DEFAULT_SUPER_TYPE = "Global";
    public static final String DEFAULT_SUPER_TYPE_LIBRARY = "org.eclipse.wst.jsdt.launching.JRE_CONTAINER";
    public static final int ERR_UNABLE_TO_RESOLVE_JRE = 160;
    public static final String PREF_CONNECT_TIMEOUT = "org.eclipse.wst.jsdt.core.PREF_CONNECT_TIMEOUT";
    public static final String PREF_VM_XML = "org.eclipse.wst.jsdt.core.PREF_VM_XML";
    public static final int DEF_CONNECT_TIMEOUT = 20000;
    public static final String ATTR_CMDLINE = "org.eclipse.wst.jsdt.core.launcher.cmdLine";
    public static final String CLASSPATH_ATTR_LIBRARY_PATH_ENTRY = "org.eclipse.wst.jsdt.core.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY";
    private static Object fgVMLock = new Object();
    private static boolean fgInitializingVMs = false;
    private static IVMInstallType[] fgVMTypes = null;
    private static String fgDefaultVMId = null;
    private static Map fgVariableResolvers = null;
    private static Map fgContainerResolvers = null;
    private static ListenerList fgVMListeners = new ListenerList(5);
    private static IVMInstall defaultVM;

    private JavaRuntime() {
    }

    public static IVMInstall getVMInstall(IJavaScriptProject project) throws CoreException {
        IVMInstall vm = null;
        IIncludePathEntry[] classpath = project.getRawIncludepath();
        IRuntimeClasspathEntryResolver2 resolver = null;
        int i = 0;
        while (i < classpath.length) {
            IIncludePathEntry entry = classpath[i];
            switch (entry.getEntryKind()) {
                case 4: {
                    resolver = JavaRuntime.getVariableResolver(entry.getPath().segment(0));
                    if (resolver == null) break;
                    vm = resolver.resolveVMInstall(entry);
                    break;
                }
                case 5: {
                    resolver = JavaRuntime.getContainerResolver(entry.getPath().segment(0));
                    if (resolver == null) break;
                    vm = resolver.resolveVMInstall(entry);
                }
            }
            if (vm != null) {
                return vm;
            }
            ++i;
        }
        return null;
    }

    public static IVMInstallType getVMInstallType(String id) {
        IVMInstallType[] vmTypes = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < vmTypes.length) {
            if (vmTypes[i].getId().equals(id)) {
                return vmTypes[i];
            }
            ++i;
        }
        return null;
    }

    public static void setDefaultVMInstall(IVMInstall vm, IProgressMonitor monitor) throws CoreException {
        JavaRuntime.setDefaultVMInstall(vm, monitor, true);
    }

    public static void setDefaultVMInstall(IVMInstall vm, IProgressMonitor monitor, boolean savePreference) throws CoreException {
        IVMInstall previous = null;
        if (fgDefaultVMId != null) {
            previous = JavaRuntime.getVMFromCompositeId(fgDefaultVMId);
        }
        fgDefaultVMId = JavaRuntime.getCompositeIdFromVM(vm);
        if (savePreference) {
            JavaRuntime.saveVMConfiguration();
        }
        IVMInstall current = null;
        if (fgDefaultVMId != null) {
            current = JavaRuntime.getVMFromCompositeId(fgDefaultVMId);
        }
        if (previous != current) {
            JavaRuntime.notifyDefaultVMChanged(previous, current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IVMInstall getDefaultVMInstall() {
        IVMInstall install = JavaRuntime.getVMFromCompositeId(JavaRuntime.getDefaultVMId());
        if (install != null) {
            return install;
        }
        if (install != null) {
            // empty if block
        }
        Object object = fgVMLock;
        synchronized (object) {
            fgDefaultVMId = null;
            fgVMTypes = null;
            JavaRuntime.initializeVMs();
        }
        return JavaRuntime.getVMFromCompositeId(JavaRuntime.getDefaultVMId());
    }

    public static IVMInstallType[] getVMInstallTypes() {
        JavaRuntime.initializeVMs();
        return fgVMTypes;
    }

    private static String getDefaultVMId() {
        JavaRuntime.initializeVMs();
        return fgDefaultVMId;
    }

    public static String getCompositeIdFromVM(IVMInstall vm) {
        if (vm == null) {
            return null;
        }
        throw new UnimplementedException();
    }

    public static IVMInstall getVMFromCompositeId(String idString) {
        if (idString == null || idString.length() == 0) {
            return null;
        }
        return defaultVM;
    }

    public static IRuntimeClasspathEntry newProjectRuntimeClasspathEntry(IJavaScriptProject project) {
        IIncludePathEntry cpe = JavaScriptCore.newProjectEntry(project.getProject().getFullPath());
        return JavaRuntime.newRuntimeClasspathEntry(cpe);
    }

    public static IRuntimeClasspathEntry newArchiveRuntimeClasspathEntry(IResource resource) {
        IIncludePathEntry cpe = JavaScriptCore.newLibraryEntry(resource.getFullPath(), null, null);
        return JavaRuntime.newRuntimeClasspathEntry(cpe);
    }

    public static IRuntimeClasspathEntry newArchiveRuntimeClasspathEntry(IPath path) {
        IIncludePathEntry cpe = JavaScriptCore.newLibraryEntry(path, null, null);
        return JavaRuntime.newRuntimeClasspathEntry(cpe);
    }

    public static IRuntimeClasspathEntry newVariableRuntimeClasspathEntry(IPath path) {
        IIncludePathEntry cpe = JavaScriptCore.newVariableEntry(path, null, null);
        return JavaRuntime.newRuntimeClasspathEntry(cpe);
    }

    public static IRuntimeClasspathEntry newRuntimeContainerClasspathEntry(IPath path, int classpathProperty) throws CoreException {
        return JavaRuntime.newRuntimeContainerClasspathEntry(path, classpathProperty, null);
    }

    public static IRuntimeClasspathEntry newRuntimeContainerClasspathEntry(IPath path, int classpathProperty, IJavaScriptProject project) throws CoreException {
        throw new UnimplementedException();
    }

    public static IRuntimeClasspathEntry newRuntimeClasspathEntry(String memento) throws CoreException {
        throw new UnimplementedException();
    }

    private static IRuntimeClasspathEntry newRuntimeClasspathEntry(IIncludePathEntry entry) {
        throw new UnimplementedException();
    }

    public static IRuntimeClasspathEntry[] computeUnresolvedRuntimeClasspath(IJavaScriptProject project) throws CoreException {
        throw new UnimplementedException();
    }

    public static IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry entry, ILaunchConfiguration configuration) throws CoreException {
        throw new UnimplementedException();
    }

    public static IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry entry, IJavaScriptProject project) throws CoreException {
        throw new UnimplementedException();
    }

    public static IRuntimeClasspathEntry[] computeUnresolvedRuntimeClasspath(ILaunchConfiguration configuration) throws CoreException {
        throw new UnimplementedException();
    }

    public static IRuntimeClasspathEntry[] resolveRuntimeClasspath(IRuntimeClasspathEntry[] entries, ILaunchConfiguration configuration) throws CoreException {
        throw new UnimplementedException();
    }

    public static IJavaScriptProject getJavaProject(ILaunchConfiguration configuration) throws CoreException {
        String projectName = configuration.getAttribute("org.eclipse.wst.jsdt.core.PROJECT_ATTR", null);
        if (projectName == null || projectName.trim().length() < 1) {
            return null;
        }
        IJavaScriptProject javaProject = JavaRuntime.getJavaModel().getJavaScriptProject(projectName);
        if (javaProject != null && javaProject.getProject().exists() && !javaProject.getProject().isOpen()) {
            JavaRuntime.abort(MessageFormat.format((String)LaunchingMessages.JavaRuntime_28, (Object[])new String[]{configuration.getName(), projectName}), 124, null);
        }
        if (javaProject == null || !javaProject.exists()) {
            JavaRuntime.abort(MessageFormat.format((String)LaunchingMessages.JavaRuntime_Launch_configuration__0__references_non_existing_project__1___1, (Object[])new String[]{configuration.getName(), projectName}), 107, null);
        }
        return javaProject;
    }

    private static IJavaScriptModel getJavaModel() {
        return JavaScriptCore.create(ResourcesPlugin.getWorkspace().getRoot());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IVMInstall computeVMInstall(ILaunchConfiguration configuration) throws CoreException {
        String jreAttr = configuration.getAttribute("org.eclipse.wst.jsdt.launching.JRE_CONTAINER", null);
        if (jreAttr == null) {
            String type = configuration.getAttribute("org.eclipse.wst.jsdt.core.VM_INSTALL_TYPE_ID", null);
            if (type == null) {
                IVMInstall vm;
                IJavaScriptProject proj = JavaRuntime.getJavaProject(configuration);
                if (proj == null || (vm = JavaRuntime.getVMInstall(proj)) == null) return JavaRuntime.getDefaultVMInstall();
                return vm;
            }
            String name = configuration.getAttribute("org.eclipse.wst.jsdt.core.VM_INSTALL_NAME", null);
            return JavaRuntime.resolveVM(type, name, configuration);
        }
        IPath jrePath = Path.fromPortableString((String)jreAttr);
        IIncludePathEntry entry = JavaScriptCore.newContainerEntry(jrePath);
        IRuntimeClasspathEntryResolver2 resolver = JavaRuntime.getVariableResolver(jrePath.segment(0));
        if (resolver != null) {
            return resolver.resolveVMInstall(entry);
        }
        resolver = JavaRuntime.getContainerResolver(jrePath.segment(0));
        if (resolver == null) return JavaRuntime.getDefaultVMInstall();
        return resolver.resolveVMInstall(entry);
    }

    private static IVMInstall resolveVM(String type, String name, ILaunchConfiguration configuration) throws CoreException {
        IVMInstallType vt = JavaRuntime.getVMInstallType(type);
        if (vt == null) {
            JavaRuntime.abort(MessageFormat.format((String)LaunchingMessages.JavaRuntime_Specified_VM_install_type_does_not_exist___0__2, (Object[])new String[]{type}), null);
        }
        IVMInstall vm = null;
        if (name == null) {
            Status status = new Status(2, "org.eclipse.wst.jsdt.core", 103, MessageFormat.format((String)LaunchingMessages.JavaRuntime_VM_not_fully_specified_in_launch_configuration__0____missing_VM_name__Reverting_to_default_VM__1, (Object[])new String[]{configuration.getName()}), null);
            JavaScriptCore.getPlugin().getLog().log((IStatus)status);
            return JavaRuntime.getDefaultVMInstall();
        }
        vm = vt.findVMInstallByName(name);
        if (vm != null) {
            return vm;
        }
        JavaRuntime.abort(MessageFormat.format((String)LaunchingMessages.JavaRuntime_Specified_VM_install_not_found__type__0___name__1__2, (Object[])new String[]{vt.getName(), name}), null);
        return null;
    }

    private static void abort(String message, Throwable exception) throws CoreException {
        JavaRuntime.abort(message, 150, exception);
    }

    private static void abort(String message, int code, Throwable exception) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.core", code, message, exception));
    }

    public static String[] computeDefaultRuntimeClassPath(IJavaScriptProject jproject) throws CoreException {
        IRuntimeClasspathEntry[] unresolved = JavaRuntime.computeUnresolvedRuntimeClasspath(jproject);
        ArrayList<String> resolved = new ArrayList<String>(unresolved.length);
        int i = 0;
        while (i < unresolved.length) {
            IRuntimeClasspathEntry entry = unresolved[i];
            if (entry.getClasspathProperty() == 3) {
                IRuntimeClasspathEntry[] entries = JavaRuntime.resolveRuntimeClasspathEntry(entry, jproject);
                int j = 0;
                while (j < entries.length) {
                    String location = entries[j].getLocation();
                    if (location != null) {
                        resolved.add(location);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return resolved.toArray(new String[resolved.size()]);
    }

    public static void saveVMConfiguration() throws CoreException {
        if (fgVMTypes == null) {
            return;
        }
        throw new UnimplementedException();
    }

    public static LibraryLocation[] getLibraryLocations(IVMInstall vm) {
        URL[] javadocLocations;
        IPath[] sourceRootPaths;
        IPath[] sourcePaths;
        IPath[] libraryPaths;
        LibraryLocation[] locations = vm.getLibraryLocations();
        if (locations == null) {
            URL defJavaDocLocation = vm.getJavadocLocation();
            LibraryLocation[] dflts = vm.getVMInstallType().getDefaultLibraryLocations(vm.getInstallLocation());
            libraryPaths = new IPath[dflts.length];
            sourcePaths = new IPath[dflts.length];
            sourceRootPaths = new IPath[dflts.length];
            javadocLocations = new URL[dflts.length];
            int i = 0;
            while (i < dflts.length) {
                libraryPaths[i] = dflts[i].getSystemLibraryPath();
                javadocLocations[i] = defJavaDocLocation == null ? dflts[i].getJavadocLocation() : defJavaDocLocation;
                if (!libraryPaths[i].toFile().isFile()) {
                    libraryPaths[i] = Path.EMPTY;
                }
                sourcePaths[i] = dflts[i].getSystemLibrarySourcePath();
                if (sourcePaths[i] != null && sourcePaths[i].toFile().isFile()) {
                    sourceRootPaths[i] = dflts[i].getPackageRootPath();
                } else {
                    sourcePaths[i] = Path.EMPTY;
                    sourceRootPaths[i] = Path.EMPTY;
                }
                ++i;
            }
        } else {
            libraryPaths = new IPath[locations.length];
            sourcePaths = new IPath[locations.length];
            sourceRootPaths = new IPath[locations.length];
            javadocLocations = new URL[locations.length];
            int i = 0;
            while (i < locations.length) {
                libraryPaths[i] = locations[i].getSystemLibraryPath();
                sourcePaths[i] = locations[i].getSystemLibrarySourcePath();
                sourceRootPaths[i] = locations[i].getPackageRootPath();
                javadocLocations[i] = locations[i].getJavadocLocation();
                ++i;
            }
        }
        locations = new LibraryLocation[sourcePaths.length];
        int i = 0;
        while (i < sourcePaths.length) {
            locations[i] = new LibraryLocation(libraryPaths[i], sourcePaths[i], sourceRootPaths[i], javadocLocations[i]);
            ++i;
        }
        return locations;
    }

    public static IIncludePathEntry getDefaultJREContainerEntry() {
        return JavaScriptCore.newContainerEntry(JavaRuntime.newDefaultJREContainerPath());
    }

    public static IPath newDefaultJREContainerPath() {
        return new Path("org.eclipse.wst.jsdt.launching.JRE_CONTAINER");
    }

    public static IPath newJREContainerPath(IVMInstall vm) {
        return JavaRuntime.newJREContainerPath(vm.getVMInstallType().getId(), vm.getName());
    }

    public static IPath newJREContainerPath(String typeId, String name) {
        IPath path = JavaRuntime.newDefaultJREContainerPath();
        path = path.append(typeId);
        path = path.append(name);
        return path;
    }

    public static IVMInstall getVMInstall(IPath jreContainerPath) {
        return JREContainerInitializer.resolveVM(jreContainerPath);
    }

    public static String getExecutionEnvironmentId(IPath jreContainerPath) {
        return JREContainerInitializer.getExecutionEnvironmentId(jreContainerPath);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IRuntimeClasspathEntry computeJREEntry(ILaunchConfiguration configuration) throws CoreException {
        String jreAttr = configuration.getAttribute("org.eclipse.wst.jsdt.launching.JRE_CONTAINER", null);
        IPath containerPath = null;
        if (jreAttr == null) {
            String type = configuration.getAttribute("org.eclipse.wst.jsdt.core.VM_INSTALL_TYPE_ID", null);
            if (type == null) {
                IJavaScriptProject proj = JavaRuntime.getJavaProject(configuration);
                if (proj != null) return JavaRuntime.computeJREEntry(proj);
                containerPath = JavaRuntime.newDefaultJREContainerPath();
            } else {
                String name = configuration.getAttribute("org.eclipse.wst.jsdt.core.VM_INSTALL_NAME", null);
                if (name != null) {
                    containerPath = JavaRuntime.newDefaultJREContainerPath().append(type).append(name);
                }
            }
        } else {
            containerPath = Path.fromPortableString((String)jreAttr);
        }
        if (containerPath == null) return null;
        return JavaRuntime.newRuntimeContainerClasspathEntry(containerPath, 1);
    }

    public static IRuntimeClasspathEntry computeJREEntry(IJavaScriptProject project) throws CoreException {
        IIncludePathEntry[] rawClasspath = project.getRawIncludepath();
        IRuntimeClasspathEntryResolver2 resolver = null;
        int i = 0;
        while (i < rawClasspath.length) {
            IIncludePathEntry entry = rawClasspath[i];
            block0 : switch (entry.getEntryKind()) {
                case 4: {
                    resolver = JavaRuntime.getVariableResolver(entry.getPath().segment(0));
                    if (resolver == null || !resolver.isVMInstallReference(entry)) break;
                    return JavaRuntime.newRuntimeClasspathEntry(entry);
                }
                case 5: {
                    IJsGlobalScopeContainer container;
                    resolver = JavaRuntime.getContainerResolver(entry.getPath().segment(0));
                    if (resolver == null || !resolver.isVMInstallReference(entry) || (container = JavaScriptCore.getJsGlobalScopeContainer(entry.getPath(), project)) == null) break;
                    switch (container.getKind()) {
                        case 1: {
                            break block0;
                        }
                        case 3: {
                            return JavaRuntime.newRuntimeContainerClasspathEntry(entry.getPath(), 1);
                        }
                        case 2: {
                            return JavaRuntime.newRuntimeContainerClasspathEntry(entry.getPath(), 2);
                        }
                    }
                }
            }
            ++i;
        }
        return null;
    }

    public static Preferences getPreferences() {
        return JavaScriptCore.getPlugin().getPluginPreferences();
    }

    public static void savePreferences() {
        JavaScriptCore.getPlugin().savePluginPreferences();
    }

    public static void addContainerResolver(IRuntimeClasspathEntryResolver resolver, String containerIdentifier) {
        Map map = JavaRuntime.getContainerResolvers();
        map.put(containerIdentifier, resolver);
    }

    private static Map getVariableResolvers() {
        if (fgVariableResolvers == null) {
            JavaRuntime.initializeResolvers();
        }
        return fgVariableResolvers;
    }

    private static Map getContainerResolvers() {
        if (fgContainerResolvers == null) {
            JavaRuntime.initializeResolvers();
        }
        return fgContainerResolvers;
    }

    private static void initializeResolvers() {
        fgContainerResolvers = new HashMap();
    }

    private static IRuntimeClasspathEntryResolver2 getVariableResolver(String variableName) {
        return (IRuntimeClasspathEntryResolver2)JavaRuntime.getVariableResolvers().get(variableName);
    }

    private static IRuntimeClasspathEntryResolver2 getContainerResolver(String containerId) {
        return (IRuntimeClasspathEntryResolver2)JavaRuntime.getContainerResolvers().get(containerId);
    }

    private static void notifyDefaultVMChanged(IVMInstall previous, IVMInstall current) {
        Object[] listeners = fgVMListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IVMInstallChangedListener listener = (IVMInstallChangedListener)listeners[i];
            listener.defaultVMInstallChanged(previous, current);
            ++i;
        }
    }

    public static void fireVMChanged(PropertyChangeEvent event) {
        Object[] listeners = fgVMListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IVMInstallChangedListener listener = (IVMInstallChangedListener)listeners[i];
            listener.vmChanged(event);
            ++i;
        }
    }

    public static void fireVMAdded(IVMInstall vm) {
        if (!fgInitializingVMs) {
            Object[] listeners = fgVMListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                IVMInstallChangedListener listener = (IVMInstallChangedListener)listeners[i];
                listener.vmAdded(vm);
                ++i;
            }
        }
    }

    public static void fireVMRemoved(IVMInstall vm) {
        Object[] listeners = fgVMListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IVMInstallChangedListener listener = (IVMInstallChangedListener)listeners[i];
            listener.vmRemoved(vm);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void initializeVMs() {
        Object object = fgVMLock;
        synchronized (object) {
            if (fgVMTypes != null) return;
            try {
                fgInitializingVMs = true;
                fgVMTypes = new IVMInstallType[]{new StandardVMType()};
                defaultVM = new StandardVM(fgVMTypes[0], "defaultVM");
                fgDefaultVMId = defaultVM.getId();
                File location = SystemLibraryLocation.getInstance().getWorkingLibPath().toFile();
                defaultVM.setInstallLocation(location);
                Object var2_4 = null;
                fgInitializingVMs = false;
                return;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                fgInitializingVMs = false;
                throw throwable;
            }
        }
    }
}

