/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IExpression;
import org.eclipse.wst.jsdt.core.ast.IJsDoc;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Javadoc;
import org.eclipse.wst.jsdt.internal.compiler.ast.ObjectLiteralField;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class ObjectGetterSetterField
extends ObjectLiteralField
implements IExpression {
    public Statement[] statements;
    public Javadoc javaDoc;
    public boolean isSetter;
    public Expression varName;

    public ObjectGetterSetterField(Expression field, Statement[] statements, Expression varName, int start, int end) {
        super(field, null, start, end);
        this.statements = statements;
        this.isSetter = varName != null;
        this.varName = varName;
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        if (this.javaDoc != null) {
            this.javaDoc.print(indent, output);
        }
        ObjectGetterSetterField.printIndent(indent, output);
        if (this.isSetter) {
            output.append("set ");
        } else {
            output.append("get ");
        }
        this.fieldName.printExpression(indent, output);
        output.append("(");
        if (this.isSetter) {
            this.varName.printExpression(indent, output);
        }
        output.append(") {\n");
        int i = 0;
        int max = this.statements.length;
        while (i < max) {
            ObjectGetterSetterField.printIndent(indent + 1, output);
            this.statements[i].printStatement(indent + 1, output);
            output.append("\n");
            ++i;
        }
        ObjectGetterSetterField.printIndent(indent + 1, output);
        output.append("}");
        return output;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            if (this.javaDoc != null) {
                this.javaDoc.traverse(visitor, scope);
            }
            if (this.fieldName != null) {
                this.fieldName.traverse(visitor, scope);
            }
            if (this.varName != null) {
                this.varName.traverse(visitor, scope);
            }
            int i = 0;
            int max = this.statements.length;
            while (i < max) {
                this.statements[i].traverse(visitor, scope);
                ++i;
            }
        }
        visitor.endVisit(this, scope);
    }

    public TypeBinding resolveType(BlockScope scope) {
        return null;
    }

    public FlowInfo analyseCode(BlockScope classScope, FlowContext initializationContext, FlowInfo flowInfo) {
        return flowInfo;
    }

    public int getASTType() {
        return 117;
    }

    public IJsDoc getJsDoc() {
        return this.javaDoc;
    }
}

