/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.validation;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsp.core.internal.Assert;
import org.eclipse.jst.jsp.core.internal.JSPCoreMessages;
import org.eclipse.jst.jsp.core.internal.JSPCorePlugin;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.ValidatorMessage;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TLDValidator
extends AbstractValidator {
    private static final String MARKER_TYPE = "org.eclipse.jst.jsp.core.validationMarker";
    private static final String PREFERENCE_NODE_QUALIFIER = JSPCorePlugin.getDefault().getBundle().getSymbolicName();
    private IPreferencesService fPreferencesService = Platform.getPreferencesService();
    private static final String[] classElementNames = new String[]{"tagclass", "tag-class", "teiclass", "tei-class", "validator-class", "variable-class", "listener-class"};
    private static final String[] missingClassMessages = new String[]{JSPCoreMessages.TaglibHelper_3, JSPCoreMessages.TaglibHelper_3, JSPCoreMessages.TaglibHelper_0, JSPCoreMessages.TaglibHelper_0, JSPCoreMessages.TLDValidator_MissingValidator, JSPCoreMessages.TLDValidator_MissingVariable, JSPCoreMessages.TLDValidator_MissingListener};
    private static final String[] missingClassSeverityPreferenceKeys = new String[]{"validation.translation-tag-class-not-found", "validation.translation-tag-class-not-found", "validation.translation-tei-class-not-found", "validation.translation-tei-class-not-found", "validation.translation-tag-class-not-found", "validation.translation-tag-class-not-found", "validation.translation-tag-class-not-found"};

    public TLDValidator() {
        Assert.isTrue(classElementNames.length == missingClassMessages.length, "mismanaged arrays");
        Assert.isTrue(classElementNames.length == missingClassSeverityPreferenceKeys.length, "mismanaged arrays");
        Assert.isTrue(missingClassMessages.length == missingClassSeverityPreferenceKeys.length, "mismanaged arrays");
    }

    private Map checkClass(IJavaProject javaProject, Node classSpecifier, IScopeContext[] preferenceScopes, String preferenceKey, String errorMessage) {
        String className = this.getTextContents(classSpecifier);
        if (className != null && className.length() > 2) {
            IType type = null;
            try {
                type = javaProject.findType(className);
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
            if (type == null || !type.exists()) {
                Object[] objectArray;
                Integer severity = this.getMessageSeverity(preferenceScopes, preferenceKey);
                if (severity == null) {
                    return null;
                }
                IDOMNode classElement = (IDOMNode)classSpecifier;
                HashMap<String, Object> markerValues = new HashMap<String, Object>();
                markerValues.put("severity", severity);
                int start = classElement.getStartOffset();
                if (classElement.getStartStructuredDocumentRegion() != null && classElement.getEndStructuredDocumentRegion() != null) {
                    start = classElement.getStartStructuredDocumentRegion().getEndOffset();
                }
                markerValues.put("charStart", new Integer(start));
                int end = classElement.getEndOffset();
                if (classElement.getStartStructuredDocumentRegion() != null && classElement.getEndStructuredDocumentRegion() != null) {
                    end = classElement.getEndStructuredDocumentRegion().getStartOffset();
                }
                markerValues.put("charEnd", new Integer(end));
                int line = classElement.getStructuredDocument().getLineOfOffset(start);
                markerValues.put("lineNumber", new Integer(line + 1));
                if (errorMessage.indexOf("{1}") >= 0) {
                    String[] stringArray = new String[2];
                    stringArray[0] = this.getTagName(classSpecifier);
                    objectArray = stringArray;
                    stringArray[1] = className;
                } else {
                    Object[] objectArray2 = new String[1];
                    objectArray = objectArray2;
                    objectArray2[0] = className;
                }
                markerValues.put("message", NLS.bind((String)errorMessage, (Object[])objectArray));
                return markerValues;
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private Map[] detectProblems(IJavaProject javaProject, IFile tld, IScopeContext[] preferenceScopes) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 183->186)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    Integer getMessageSeverity(IScopeContext[] preferenceScopes, String key) {
        int sev = this.fPreferencesService.getInt(PREFERENCE_NODE_QUALIFIER, key, 2, preferenceScopes);
        switch (sev) {
            case 1: {
                return new Integer(2);
            }
            case 2: {
                return new Integer(1);
            }
            case 3: {
                return new Integer(0);
            }
            case -1: {
                return null;
            }
        }
        return new Integer(1);
    }

    private String getTagName(Node classSpecifier) {
        Node tagElement = classSpecifier.getParentNode();
        Node child = tagElement.getFirstChild();
        while (child != null) {
            String name;
            if (child.getNodeType() == 1 && "name".equals(name = child.getNodeName())) {
                return this.getTextContents(child);
            }
            child = child.getNextSibling();
        }
        return "";
    }

    private String getTextContents(Node parent) {
        NodeList children = parent.getChildNodes();
        if (children.getLength() == 1) {
            return children.item(0).getNodeValue().trim();
        }
        StringBuffer s = new StringBuffer();
        Node child = parent.getFirstChild();
        while (child != null) {
            s.append(child.getNodeValue().trim());
            child = child.getNextSibling();
        }
        return s.toString().trim();
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        if (resource.getType() != 1) {
            return null;
        }
        ValidationResult result = new ValidationResult();
        IFile tld = (IFile)resource;
        if (tld.isAccessible()) {
            try {
                IJavaProject javaProject = JavaCore.create((IProject)tld.getProject());
                if (javaProject.exists()) {
                    IScopeContext[] scopes = new IScopeContext[]{new InstanceScope(), new DefaultScope()};
                    ProjectScope projectScope = new ProjectScope(tld.getProject());
                    if (projectScope.getNode(PREFERENCE_NODE_QUALIFIER).getBoolean("validation.use-project-settings", false)) {
                        scopes = new IScopeContext[]{projectScope, new InstanceScope(), new DefaultScope()};
                    }
                    Map[] problems = this.detectProblems(javaProject, tld, scopes);
                    int i = 0;
                    while (i < problems.length) {
                        ValidatorMessage message = ValidatorMessage.create((String)problems[i].get("message").toString(), (IResource)resource);
                        message.setType(MARKER_TYPE);
                        message.setAttributes(problems[i]);
                        result.add(message);
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
        return result;
    }
}

