/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.UserLibrary;
import org.osgi.service.prefs.BackingStoreException;

public class UserLibraryManager {
    public static final String CP_USERLIBRARY_PREFERENCES_PREFIX = "org.eclipse.wst.jsdt.core.userLibrary.";
    public static final String CP_ENTRY_IGNORE = "##<cp entry ignore>##";
    private static Map UserLibraries;
    private static ThreadLocal InitializingLibraries;
    private static final boolean logProblems = false;
    private static IEclipsePreferences.IPreferenceChangeListener listener;

    static {
        InitializingLibraries = new ThreadLocal();
        listener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                String key = event.getKey();
                if (key.startsWith(UserLibraryManager.CP_USERLIBRARY_PREFERENCES_PREFIX)) {
                    try {
                        UserLibraryManager.recreatePersistedUserLibraryEntry(key, (String)event.getNewValue(), false, true);
                    }
                    catch (JavaScriptModelException javaScriptModelException) {
                        // empty catch block
                    }
                }
            }
        };
    }

    private UserLibraryManager() {
    }

    public static String[] getUserLibraryNames() {
        Set set = UserLibraryManager.getLibraryMap().keySet();
        return set.toArray(new String[set.size()]);
    }

    public static UserLibrary getUserLibrary(String name) {
        return (UserLibrary)UserLibraryManager.getLibraryMap().get(name);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setUserLibraries(String[] newNames, UserLibrary[] newLibs, IProgressMonitor monitor) throws JavaScriptModelException {
        Assert.isTrue((newNames.length == newLibs.length ? 1 : 0) != 0, (String)"names and libraries should have the same length");
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("", newNames.length);
            int last = newNames.length - 1;
            int i = 0;
            while (i < newLibs.length) {
                UserLibraryManager.internalSetUserLibrary(newNames[i], newLibs[i], i == last, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        monitor.done();
    }

    public static void setUserLibrary(String name, UserLibrary library, IProgressMonitor monitor) throws JavaScriptModelException {
        UserLibraryManager.internalSetUserLibrary(name, library, true, true, monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Map getLibraryMap() {
        if (UserLibraries != null) return UserLibraries;
        HashMap libraries = (HashMap)InitializingLibraries.get();
        if (libraries != null) {
            return libraries;
        }
        try {
            libraries = new HashMap();
            InitializingLibraries.set(libraries);
            IEclipsePreferences instancePreferences = JavaModelManager.getJavaModelManager().getInstancePreferences();
            instancePreferences.addPreferenceChangeListener(listener);
            try {
                String[] propertyNames = instancePreferences.keys();
                int i = 0;
                while (i < propertyNames.length) {
                    String propertyName = propertyNames[i];
                    if (propertyName.startsWith(CP_USERLIBRARY_PREFERENCES_PREFIX)) {
                        try {
                            String propertyValue = instancePreferences.get(propertyName, null);
                            if (propertyValue != null) {
                                UserLibraryManager.recreatePersistedUserLibraryEntry(propertyName, propertyValue, false, false);
                            }
                        }
                        catch (JavaScriptModelException javaScriptModelException) {}
                    }
                    ++i;
                }
            }
            catch (BackingStoreException backingStoreException) {}
            UserLibraries = libraries;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            InitializingLibraries.set(null);
            throw throwable;
        }
        {
            Object var6_8 = null;
            InitializingLibraries.set(null);
            return UserLibraries;
        }
    }

    static void recreatePersistedUserLibraryEntry(String propertyName, String savedString, boolean save, boolean rebind) throws JavaScriptModelException {
        String libName = propertyName.substring(CP_USERLIBRARY_PREFERENCES_PREFIX.length());
        if (savedString == null || savedString.equals(CP_ENTRY_IGNORE)) {
            UserLibraryManager.internalSetUserLibrary(libName, null, save, rebind, null);
        } else {
            try {
                StringReader reader = new StringReader(savedString);
                UserLibrary library = UserLibrary.createFromString(reader);
                UserLibraryManager.internalSetUserLibrary(libName, library, save, rebind, null);
            }
            catch (IOException e) {
                UserLibraryManager.internalSetUserLibrary(libName, null, save, rebind, null);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void internalSetUserLibrary(String name, UserLibrary library, boolean save, boolean rebind, IProgressMonitor monitor) throws JavaScriptModelException {
        Object previous;
        if (library == null ? (previous = UserLibraryManager.getLibraryMap().remove(name)) == null : library.equals(previous = UserLibraryManager.getLibraryMap().put(name, library))) {
            return;
        }
        IEclipsePreferences instancePreferences = JavaModelManager.getJavaModelManager().getInstancePreferences();
        String containerKey = CP_USERLIBRARY_PREFERENCES_PREFIX + name;
        String containerString = CP_ENTRY_IGNORE;
        if (library != null) {
            try {
                containerString = library.serialize();
            }
            catch (IOException iOException) {}
        }
        instancePreferences.removePreferenceChangeListener(listener);
        try {
            instancePreferences.put(containerKey, containerString);
            if (save) {
                try {
                    instancePreferences.flush();
                }
                catch (BackingStoreException backingStoreException) {}
            }
            if (rebind) {
                UserLibraryManager.rebindClasspathEntries(name, library == null, monitor);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            instancePreferences.addPreferenceChangeListener(listener);
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        instancePreferences.addPreferenceChangeListener(listener);
    }

    /*
     * Exception decompiling
     */
    private static void rebindClasspathEntries(String name, boolean remove, IProgressMonitor monitor) throws JavaScriptModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 259->263)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

