/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.contentmodel.tld;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.contentmodel.TaglibController;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.CMDocumentFactoryTLD;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TaglibTracker;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDDocument;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDElementDeclaration;
import org.eclipse.jst.jsp.core.internal.contenttype.DeploymentDescriptorPropertyCache;
import org.eclipse.jst.jsp.core.internal.util.FacetModuleCoreSupport;
import org.eclipse.jst.jsp.core.internal.util.FileContentCache;
import org.eclipse.jst.jsp.core.internal.util.ZeroStructuredDocumentRegion;
import org.eclipse.jst.jsp.core.taglib.IJarRecord;
import org.eclipse.jst.jsp.core.taglib.ITLDRecord;
import org.eclipse.jst.jsp.core.taglib.ITagDirRecord;
import org.eclipse.jst.jsp.core.taglib.ITaglibIndexDelta;
import org.eclipse.jst.jsp.core.taglib.ITaglibIndexListener;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.IURLRecord;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.eclipse.wst.sse.core.internal.ltk.parser.BlockMarker;
import org.eclipse.wst.sse.core.internal.ltk.parser.JSPCapableParser;
import org.eclipse.wst.sse.core.internal.ltk.parser.StructuredDocumentRegionHandler;
import org.eclipse.wst.sse.core.internal.ltk.parser.StructuredDocumentRegionHandlerExtension;
import org.eclipse.wst.sse.core.internal.ltk.parser.TagMarker;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.util.Assert;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.parser.XMLSourceParser;

public class TLDCMDocumentManager
implements ITaglibIndexListener {
    static final boolean _debug = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/tldcmdocument/manager"));
    static final boolean _debugCache = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/tldcmdocument/cache"));
    protected static List bannedPrefixes = null;
    private static Hashtable fCache = null;
    final String XMLNS = "xmlns:";
    final String URN_TAGDIR = "urn:jsptagdir:";
    final String URN_TLD = "urn:jsptld:";
    final int XMLNS_LENGTH = "xmlns:".length();
    final int URN_TAGDIR_LENGTH = "urn:jsptagdir:".length();
    final int URN_TLD_LENGTH = "urn:jsptld:".length();
    private CMDocumentFactoryTLD fCMDocumentBuilder = null;
    private DirectiveStructuredDocumentRegionHandler fDirectiveHandler = null;
    private Hashtable fDocuments = null;
    HashMap fInclude2TimestampMap = new HashMap();
    private Stack fIncludes = null;
    private XMLSourceParser fParser = null;
    private List fTaglibTrackers = null;
    Map fTLDCMReferencesMap = new HashMap();
    boolean fProcessIncludes = true;
    boolean preludesHandled = false;

    static {
        bannedPrefixes = new ArrayList(7);
        bannedPrefixes.add("jsp");
        bannedPrefixes.add("jspx");
        bannedPrefixes.add("java");
        bannedPrefixes.add("javax");
        bannedPrefixes.add("servlet");
        bannedPrefixes.add("sun");
        bannedPrefixes.add("sunw");
    }

    public static Hashtable getSharedDocumentCache() {
        if (fCache == null) {
            fCache = new Hashtable();
        }
        return fCache;
    }

    public static Object getUniqueIdentifier(ITaglibRecord reference) {
        if (reference == null) {
            return null;
        }
        Object identifier = null;
        switch (reference.getRecordType()) {
            case 1: {
                ITLDRecord record = (ITLDRecord)reference;
                identifier = record.getPath();
                break;
            }
            case 2: {
                IJarRecord record = (IJarRecord)reference;
                identifier = record.getLocation();
                break;
            }
            case 8: {
                ITagDirRecord record = (ITagDirRecord)reference;
                identifier = record.getPath();
                break;
            }
            case 4: {
                IURLRecord record = (IURLRecord)reference;
                identifier = record.getURL();
                break;
            }
            default: {
                identifier = reference;
            }
        }
        return identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        if (_debugCache) {
            System.out.println("TLDCMDocumentManager cleared its private CMDocument cache");
        }
        Iterator iter = this.getDocuments().keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Hashtable hashtable = TLDCMDocumentManager.getSharedDocumentCache();
            synchronized (hashtable) {
                Object o = TLDCMDocumentManager.getSharedDocumentCache().get(key);
                if (o instanceof TLDCacheEntry) {
                    TLDCacheEntry entry = (TLDCacheEntry)o;
                    --entry.referenceCount;
                    if (entry.referenceCount <= 0) {
                        TLDCMDocumentManager.getSharedDocumentCache().put(key, new SoftReference<TLDCacheEntry>(entry));
                    }
                }
            }
        }
    }

    protected Object getCacheKey(String uri) {
        IPath currentParserPath = this.getCurrentParserPath();
        if (currentParserPath == null) {
            return null;
        }
        ITaglibRecord record = TaglibIndex.resolve(currentParserPath.toString(), uri, false);
        if (record != null) {
            return TLDCMDocumentManager.getUniqueIdentifier(record);
        }
        String location = URIResolverPlugin.createResolver().resolve(this.getCurrentBaseLocation().toString(), null, uri);
        return location;
    }

    protected CMDocument getCMDocument(String uri) {
        if (uri == null || uri.length() == 0) {
            return null;
        }
        String reference = uri;
        Object cacheKey = this.getCacheKey(reference);
        if (cacheKey == null) {
            return null;
        }
        long lastModified = this.getModificationStamp(reference);
        CMDocument doc = (CMDocument)this.getDocuments().get(cacheKey);
        if (doc == null) {
            Object o = TLDCMDocumentManager.getSharedDocumentCache().get(cacheKey);
            if (o != null) {
                TLDCacheEntry entry;
                if (o instanceof TLDCacheEntry) {
                    entry = (TLDCacheEntry)o;
                    if (_debugCache) {
                        System.out.println("TLDCMDocument cache hit on " + cacheKey);
                    }
                    if (entry != null && entry.modificationStamp != -1L && entry.modificationStamp >= lastModified) {
                        doc = entry.document;
                        ++entry.referenceCount;
                    } else {
                        TLDCMDocumentManager.getSharedDocumentCache().remove(cacheKey);
                    }
                } else if (o instanceof Reference) {
                    entry = (TLDCacheEntry)((Reference)o).get();
                    if (entry != null) {
                        if (entry.modificationStamp != -1L && entry.modificationStamp >= lastModified) {
                            doc = entry.document;
                            entry.referenceCount = 1;
                            TLDCMDocumentManager.getSharedDocumentCache().put(cacheKey, entry);
                        }
                    } else {
                        TLDCMDocumentManager.getSharedDocumentCache().remove(cacheKey);
                    }
                }
            }
            if (doc == null) {
                CMDocument document;
                if (_debugCache) {
                    System.out.println("TLDCMDocument cache miss on " + cacheKey);
                }
                if ((document = this.loadTaglib(reference)) != null) {
                    TLDCacheEntry entry = new TLDCacheEntry();
                    doc = entry.document = document;
                    entry.referenceCount = 1;
                    entry.modificationStamp = this.getModificationStamp(reference);
                    TLDCMDocumentManager.getSharedDocumentCache().put(cacheKey, entry);
                }
            }
            if (doc != null) {
                this.getDocuments().put(cacheKey, doc);
            }
        }
        return doc;
    }

    private long getModificationStamp(String reference) {
        ITaglibRecord record = TaglibIndex.resolve(this.getCurrentParserPath().toString(), reference, false);
        long modificationStamp = -1L;
        if (record != null) {
            switch (record.getRecordType()) {
                case 1: {
                    IFile tldfile = ResourcesPlugin.getWorkspace().getRoot().getFile(((ITLDRecord)record).getPath());
                    if (!tldfile.isAccessible()) break;
                    modificationStamp = tldfile.getModificationStamp();
                    break;
                }
                case 2: {
                    File jarfile = new File(((IJarRecord)record).getLocation().toOSString());
                    if (!jarfile.exists()) break;
                    try {
                        modificationStamp = jarfile.lastModified();
                    }
                    catch (SecurityException securityException) {
                        modificationStamp = -1L;
                    }
                    break;
                }
                case 8: {
                    IFolder tagFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(((ITagDirRecord)record).getPath());
                    if (!tagFolder.isAccessible()) break;
                    try {
                        IResource[] members = tagFolder.members();
                        int i = 0;
                        while (i < members.length) {
                            modificationStamp = Math.max(modificationStamp, members[i].getModificationStamp());
                            ++i;
                        }
                    }
                    catch (CoreException coreException) {
                        modificationStamp = -1L;
                    }
                    break;
                }
                case 4: {
                    File jarfile;
                    String loc = ((IURLRecord)record).getBaseLocation();
                    if (loc == null || !loc.endsWith(".jar") || !(jarfile = new File(loc)).exists()) break;
                    try {
                        modificationStamp = jarfile.lastModified();
                    }
                    catch (SecurityException securityException) {
                        modificationStamp = -1L;
                    }
                    break;
                }
            }
        }
        return modificationStamp;
    }

    protected CMDocumentFactoryTLD getCMDocumentBuilder() {
        if (this.fCMDocumentBuilder == null) {
            this.fCMDocumentBuilder = new CMDocumentFactoryTLD();
        }
        return this.fCMDocumentBuilder;
    }

    public List getCMDocumentTrackers(int offset) {
        ArrayList<TaglibTracker> validDocs = new ArrayList<TaglibTracker>();
        Object[] alldocs = this.getTaglibTrackers().toArray();
        int i = 0;
        while (i < alldocs.length) {
            TaglibTracker aTracker = (TaglibTracker)alldocs[i];
            if (aTracker.getStructuredDocumentRegion().getStartOffset() <= offset || offset < 0) {
                validDocs.add(aTracker);
            }
            ++i;
        }
        return validDocs;
    }

    public List getCMDocumentTrackers(String prefix, int offset) {
        ArrayList<TaglibTracker> validDocs = new ArrayList<TaglibTracker>();
        Object[] alldocs = this.getTaglibTrackers().toArray();
        int i = 0;
        while (i < alldocs.length) {
            TaglibTracker aTracker = (TaglibTracker)alldocs[i];
            if ((aTracker.getStructuredDocumentRegion().getStartOffset() <= offset || offset < 0) && aTracker.getPrefix().equals(prefix)) {
                validDocs.add(aTracker);
            }
            ++i;
        }
        return validDocs;
    }

    IPath getCurrentBaseLocation() {
        IPath baseLocation = null;
        IPath path = this.getCurrentParserPath();
        if (path == null || path.segmentCount() < 2) {
            return path;
        }
        baseLocation = ResourcesPlugin.getWorkspace().getRoot().getFile(path).getLocation();
        if (baseLocation == null) {
            baseLocation = path;
        }
        return baseLocation;
    }

    IPath getCurrentParserPath() {
        IPath path = null;
        path = !this.getIncludes().isEmpty() ? (IPath)this.getIncludes().peek() : TaglibController.getLocation(this);
        return path;
    }

    protected DirectiveStructuredDocumentRegionHandler getDirectiveStructuredDocumentRegionHandler() {
        if (this.fDirectiveHandler == null) {
            this.fDirectiveHandler = new DirectiveStructuredDocumentRegionHandler();
        }
        return this.fDirectiveHandler;
    }

    public Hashtable getDocuments() {
        if (this.fDocuments == null) {
            this.fDocuments = new Hashtable();
        }
        return this.fDocuments;
    }

    protected Stack getIncludes() {
        if (this.fIncludes == null) {
            this.fIncludes = new Stack();
        }
        return this.fIncludes;
    }

    XMLSourceParser getParser() {
        return this.fParser;
    }

    public XMLSourceParser getSourceParser() {
        return this.fParser;
    }

    public StructuredDocumentRegionHandler getStructuredDocumentRegionHandler() {
        return this.getDirectiveStructuredDocumentRegionHandler();
    }

    public List getTaglibTrackers() {
        if (this.fTaglibTrackers == null) {
            this.fTaglibTrackers = new ArrayList();
        }
        return this.fTaglibTrackers;
    }

    void handlePreludes() {
        ZeroStructuredDocumentRegion anchor = new ZeroStructuredDocumentRegion(null, -1);
        this.fProcessIncludes = false;
        IPath currentPath = this.getCurrentParserPath();
        if (currentPath != null) {
            DeploymentDescriptorPropertyCache.PropertyGroup[] propertyGroups = DeploymentDescriptorPropertyCache.getInstance().getPropertyGroups(currentPath);
            int k = 0;
            while (k < propertyGroups.length) {
                IPath[] preludes = propertyGroups[k].getIncludePrelude();
                int i = 0;
                while (i < preludes.length) {
                    if (!this.getIncludes().contains(preludes[i]) && !preludes[i].equals((Object)currentPath)) {
                        this.getIncludes().push(preludes[i]);
                        if (this.getParser() != null) {
                            IncludeHelper includeHelper = new IncludeHelper(anchor, this.getParser());
                            includeHelper.parse(preludes[i]);
                            List references = includeHelper.taglibReferences;
                            this.fTLDCMReferencesMap.put(preludes[i], references);
                            if (this.getParser() instanceof JSPCapableParser) {
                                int j = 0;
                                while (j < references.size()) {
                                    TLDCMDocumentReference reference = (TLDCMDocumentReference)references.get(j);
                                    ((JSPCapableParser)this.getParser()).addNestablePrefix(new TagMarker(String.valueOf(reference.prefix) + ":"));
                                    ++j;
                                }
                            }
                        } else {
                            Logger.log(2, "Warning: parser text was requested by " + this.getClass().getName() + " but none was available; taglib support disabled");
                        }
                        this.getIncludes().pop();
                    }
                    ++i;
                }
                ++k;
            }
        }
        this.fProcessIncludes = true;
    }

    boolean hasAnyIncludeBeenModified(IPath filePath) {
        boolean result = false;
        if (this.hasBeenModified(filePath)) {
            result = true;
        } else {
            Iterator iter = this.fInclude2TimestampMap.keySet().iterator();
            while (iter.hasNext()) {
                if (!this.hasBeenModified((IPath)iter.next())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    boolean hasBeenModified(IPath filePath) {
        boolean result = false;
        IFile f = null;
        if (f == null && filePath.segmentCount() > 1) {
            f = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
        }
        if (f != null && f.exists()) {
            Long currentStamp = new Long(f.getModificationStamp());
            Object o = this.fInclude2TimestampMap.get(filePath);
            if (o != null) {
                Long previousStamp = (Long)o;
                if (currentStamp.longValue() != previousStamp.longValue()) {
                    result = true;
                    this.fInclude2TimestampMap.put(filePath, currentStamp);
                }
            } else {
                result = true;
                this.fInclude2TimestampMap.put(filePath, currentStamp);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexChanged(ITaglibIndexDelta event) {
        Hashtable hashtable = TLDCMDocumentManager.getSharedDocumentCache();
        synchronized (hashtable) {
            Iterator values = TLDCMDocumentManager.getSharedDocumentCache().values().iterator();
            while (values.hasNext()) {
                Object o = values.next();
                if (!(o instanceof Reference)) continue;
                values.remove();
            }
        }
    }

    protected CMDocument loadTaglib(String uri) {
        CMDocument document = null;
        IPath currentPath = this.getCurrentParserPath();
        if (currentPath != null) {
            ITaglibRecord record = TaglibIndex.resolve(currentPath.toString(), uri, false);
            if (record != null) {
                document = this.getCMDocumentBuilder().createCMDocument(record);
            } else {
                String location;
                IPath currentBaseLocation = this.getCurrentBaseLocation();
                if (currentBaseLocation != null && (location = URIResolverPlugin.createResolver().resolve(currentBaseLocation.toString(), null, uri)) != null) {
                    if (_debug) {
                        System.out.println("Loading tags from " + uri + " at " + location);
                    }
                    document = this.getCMDocumentBuilder().createCMDocument(location);
                }
            }
        }
        return document;
    }

    protected void resetTaglibTrackers() {
        if (_debug) {
            System.out.println("TLDCMDocumentManager cleared its taglib trackers\n");
        }
        this.preludesHandled = false;
        this.getTaglibTrackers().clear();
    }

    public void setSourceParser(XMLSourceParser parser) {
        if (this.fParser != null) {
            this.fParser.removeStructuredDocumentRegionHandler(this.getStructuredDocumentRegionHandler());
        }
        this.fParser = parser;
        if (this.fParser != null) {
            this.fParser.addStructuredDocumentRegionHandler(this.getStructuredDocumentRegionHandler());
        }
    }

    protected class DirectiveStructuredDocumentRegionHandler
    implements StructuredDocumentRegionHandler,
    StructuredDocumentRegionHandlerExtension {
        protected DirectiveStructuredDocumentRegionHandler() {
        }

        protected void addBlockTag(String tagnameNS, ITextRegionCollection marker) {
            if (TLDCMDocumentManager.this.getParser() == null) {
                return;
            }
            if (TLDCMDocumentManager.this.getParser().getBlockMarker(tagnameNS) == null) {
                TLDCMDocumentManager.this.getParser().addBlockMarker(new BlockMarker(tagnameNS, (ITextRegion)marker, "BLOCK_TEXT", true, false));
                if (_debug) {
                    System.out.println("TLDCMDocumentManager added block marker: " + tagnameNS + "@" + marker.getStartOffset());
                }
            }
        }

        protected void addTaglibTracker(String prefix, String uri, IStructuredDocumentRegion anchorStructuredDocumentRegion, CMDocument tldCMDocument) {
            TLDCMDocumentManager.this.getTaglibTrackers().add(new TaglibTracker(uri, prefix, tldCMDocument, anchorStructuredDocumentRegion));
        }

        protected void enableTaglibFromURI(String prefix, String uri, IStructuredDocumentRegion anchorStructuredDocumentRegion) {
            this.enableTags(prefix, uri, anchorStructuredDocumentRegion);
            if (_debug) {
                System.out.println("TLDCMDocumentManager registered a tracker for " + uri + " with prefix " + prefix);
            }
        }

        private void enableTags(String prefix, String uri, IStructuredDocumentRegion anchorStructuredDocumentRegion) {
            if (prefix == null || uri == null || bannedPrefixes.contains(prefix)) {
                return;
            }
            CMDocument tld = TLDCMDocumentManager.this.getCMDocument(uri);
            if (tld == null || !(tld instanceof TLDDocument)) {
                if (_debug) {
                    System.out.println("TLDCMDocumentManager failed to create a CMDocument for " + uri);
                }
                return;
            }
            this.registerTaglib(prefix, uri, anchorStructuredDocumentRegion, tld);
        }

        protected void enableTagsInDir(String prefix, String tagdir, IStructuredDocumentRegion anchorStructuredDocumentRegion) {
            this.enableTags(prefix, tagdir, anchorStructuredDocumentRegion);
            if (_debug) {
                System.out.println("TLDCMDocumentManager registered a tracker for directory" + tagdir + " with prefix " + prefix);
            }
        }

        protected void processRegionCollection(ITextRegionCollection regionCollection, IStructuredDocumentRegion anchorStructuredDocumentRegion, XMLSourceParser textSource) {
            if (regionCollection.getNumberOfRegions() > 4 && regionCollection.getRegions().get(1).getType() == "JSP_DIRECTIVE_NAME") {
                int textLength;
                ITextRegion name = regionCollection.getRegions().get(1);
                boolean taglibDetected = false;
                boolean taglibDirectiveDetected = false;
                boolean includeDetected = false;
                boolean includeDirectiveDetected = false;
                int startOffset = regionCollection.getStartOffset(name);
                taglibDetected = textSource.regionMatches(startOffset, textLength = name.getTextLength(), "taglib");
                if (!taglibDetected) {
                    taglibDirectiveDetected = textSource.regionMatches(startOffset, textLength, "jsp:directive.taglib");
                }
                if (!taglibDirectiveDetected) {
                    includeDetected = textSource.regionMatches(startOffset, textLength, "include");
                }
                if (!includeDetected) {
                    includeDirectiveDetected = textSource.regionMatches(startOffset, textLength, "jsp:directive.include");
                }
                if (taglibDetected || taglibDirectiveDetected) {
                    this.processTaglib(regionCollection, anchorStructuredDocumentRegion, textSource);
                } else if (includeDetected || includeDirectiveDetected) {
                    this.processInclude(regionCollection, anchorStructuredDocumentRegion, textSource);
                }
            } else if (regionCollection.getNumberOfRegions() > 1 && "XML_TAG_OPEN".equals(regionCollection.getFirstRegion().getType())) {
                this.processXMLStartTag(regionCollection, anchorStructuredDocumentRegion, textSource);
            }
        }

        public void nodeParsed(IStructuredDocumentRegion structuredDocumentRegion) {
            if (!TLDCMDocumentManager.this.preludesHandled) {
                TLDCMDocumentManager.this.handlePreludes();
                TLDCMDocumentManager.this.preludesHandled = true;
            }
            this.processRegionCollection((ITextRegionCollection)structuredDocumentRegion, structuredDocumentRegion, TLDCMDocumentManager.this.getParser());
        }

        protected void processInclude(ITextRegionCollection includeDirectiveCollection, IStructuredDocumentRegion anchorStructuredDocumentRegion, XMLSourceParser textSource) {
            ITextRegionList regions = includeDirectiveCollection.getRegions();
            String includedFile = null;
            boolean isFilename = false;
            try {
                int i = 2;
                while (includedFile == null && i < regions.size()) {
                    ITextRegion region = regions.get(i);
                    if (region.getType() == "XML_TAG_ATTRIBUTE_NAME") {
                        isFilename = textSource.regionMatches(includeDirectiveCollection.getStartOffset(region), region.getTextLength(), "file");
                    } else if (isFilename && region.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                        includedFile = textSource.getText(includeDirectiveCollection.getStartOffset(region), region.getTextLength());
                        isFilename = false;
                    }
                    ++i;
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                includedFile = null;
            }
            if (TLDCMDocumentManager.this.fProcessIncludes && includedFile != null) {
                includedFile = StringUtils.strip(includedFile).trim();
                IPath filePath = null;
                IPath modelBaseLocation = TaglibController.getLocation(TLDCMDocumentManager.this);
                if (modelBaseLocation != null) {
                    filePath = TLDCMDocumentManager.this.getIncludes().isEmpty() ? FacetModuleCoreSupport.resolve(modelBaseLocation, includedFile) : FacetModuleCoreSupport.resolve((IPath)TLDCMDocumentManager.this.getIncludes().peek(), includedFile);
                }
                if (filePath != null && !TLDCMDocumentManager.this.getIncludes().contains(filePath) && !filePath.equals((Object)modelBaseLocation)) {
                    if (TLDCMDocumentManager.this.hasAnyIncludeBeenModified(filePath)) {
                        TLDCMDocumentManager.this.getIncludes().push(filePath);
                        IncludeHelper includeHelper = new IncludeHelper(anchorStructuredDocumentRegion, TLDCMDocumentManager.this.getParser());
                        includeHelper.parse(filePath);
                        List references = includeHelper.taglibReferences;
                        TLDCMDocumentManager.this.fTLDCMReferencesMap.put(filePath, references);
                        if (TLDCMDocumentManager.this.getParser() instanceof JSPCapableParser) {
                            int i = 0;
                            while (references != null && i < references.size()) {
                                TLDCMDocumentReference reference = (TLDCMDocumentReference)references.get(i);
                                ((JSPCapableParser)TLDCMDocumentManager.this.getParser()).addNestablePrefix(new TagMarker(String.valueOf(reference.prefix) + ":"));
                                ++i;
                            }
                        }
                        TLDCMDocumentManager.this.getIncludes().pop();
                    } else {
                        List references = (List)TLDCMDocumentManager.this.fTLDCMReferencesMap.get(filePath);
                        int i = 0;
                        while (references != null && i < references.size()) {
                            TLDCMDocumentReference reference = (TLDCMDocumentReference)references.get(i);
                            this.enableTaglibFromURI(reference.prefix, reference.uri, anchorStructuredDocumentRegion);
                            if (TLDCMDocumentManager.this.getParser() instanceof JSPCapableParser) {
                                ((JSPCapableParser)TLDCMDocumentManager.this.getParser()).addNestablePrefix(new TagMarker(String.valueOf(reference.prefix) + ":"));
                            }
                            ++i;
                        }
                    }
                } else if (TLDCMDocumentManager.this.getIncludes().contains(filePath)) {
                    // empty if block
                }
            }
        }

        protected void processXMLStartTag(ITextRegionCollection startTagRegionCollection, IStructuredDocumentRegion anchorStructuredDocumentRegion, XMLSourceParser textSource) {
            ITextRegionList regions = startTagRegionCollection.getRegions();
            String uri = null;
            String prefix = null;
            boolean isTaglibValue = false;
            int i = 2;
            while (i < regions.size()) {
                ITextRegion region = regions.get(i);
                if (region instanceof ITextRegionCollection) {
                    this.processRegionCollection((ITextRegionCollection)region, anchorStructuredDocumentRegion, textSource);
                } else {
                    int regionStartOffset = startTagRegionCollection.getStartOffset(region);
                    int regionTextLength = region.getTextLength();
                    if (region.getType() == "XML_TAG_ATTRIBUTE_NAME") {
                        if (regionTextLength > TLDCMDocumentManager.this.XMLNS_LENGTH && textSource.regionMatches(regionStartOffset, TLDCMDocumentManager.this.XMLNS_LENGTH, "xmlns:")) {
                            prefix = textSource.getText(regionStartOffset + TLDCMDocumentManager.this.XMLNS_LENGTH, regionTextLength - TLDCMDocumentManager.this.XMLNS_LENGTH);
                            if (!bannedPrefixes.contains(prefix)) {
                                isTaglibValue = true;
                            }
                        } else {
                            prefix = null;
                            isTaglibValue = false;
                        }
                    } else if (isTaglibValue && region.getType() == "XML_TAG_ATTRIBUTE_VALUE" && prefix != null && prefix.length() > 0) {
                        uri = textSource.getText(regionStartOffset, regionTextLength);
                        uri = StringUtils.strip((String)uri);
                        int uriLength = uri.length();
                        if (uri != null && uriLength > 0) {
                            if (uriLength > TLDCMDocumentManager.this.URN_TLD_LENGTH && uri.startsWith("urn:jsptld:")) {
                                uri = uri.substring(TLDCMDocumentManager.this.URN_TLD_LENGTH);
                            } else if (uriLength > TLDCMDocumentManager.this.URN_TAGDIR_LENGTH && uri.startsWith("urn:jsptagdir:")) {
                                uri = uri.substring(TLDCMDocumentManager.this.URN_TAGDIR_LENGTH);
                            }
                            this.enableTags(prefix, uri, anchorStructuredDocumentRegion);
                            uri = null;
                            prefix = null;
                        }
                    }
                }
                ++i;
            }
        }

        protected void processTaglib(ITextRegionCollection taglibDirectiveCollection, IStructuredDocumentRegion anchorStructuredDocumentRegion, XMLSourceParser textSource) {
            ITextRegionList regions = taglibDirectiveCollection.getRegions();
            String uri = null;
            String prefix = null;
            String tagdir = null;
            String attrName = null;
            try {
                int i = 2;
                while (i < regions.size()) {
                    ITextRegion region = regions.get(i);
                    int startOffset = taglibDirectiveCollection.getStartOffset(region);
                    int textLength = region.getTextLength();
                    if (region.getType() == "XML_TAG_ATTRIBUTE_NAME") {
                        attrName = textSource.regionMatches(startOffset, textLength, "prefix") ? "prefix" : (textSource.regionMatches(startOffset, textLength, "uri") ? "uri" : (textSource.regionMatches(startOffset, textLength, "tagdir") ? "tagdir" : null));
                    } else if (region.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                        if ("prefix".equals(attrName)) {
                            prefix = StringUtils.strip((String)textSource.getText(startOffset, textLength));
                        } else if ("uri".equals(attrName)) {
                            uri = StringUtils.strip((String)textSource.getText(startOffset, textLength));
                        } else if ("tagdir".equals(attrName)) {
                            tagdir = StringUtils.strip((String)textSource.getText(startOffset, textLength));
                        }
                    }
                    ++i;
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                uri = null;
                prefix = null;
            }
            if (uri != null && prefix != null && uri.length() > 0 && prefix.length() > 0) {
                this.enableTaglibFromURI(prefix, StringUtils.strip((String)uri), anchorStructuredDocumentRegion);
            } else if (tagdir != null && prefix != null && tagdir.length() > 0 && prefix.length() > 0) {
                this.enableTagsInDir(StringUtils.strip((String)prefix), StringUtils.strip((String)tagdir), anchorStructuredDocumentRegion);
            }
        }

        private void registerTaglib(String prefix, String uri, IStructuredDocumentRegion anchorStructuredDocumentRegion, CMDocument tld) {
            CMNamedNodeMap elements = tld.getElements();
            int i = 0;
            while (i < elements.getLength()) {
                TLDElementDeclaration ed = (TLDElementDeclaration)elements.item(i);
                if (ed.getBodycontent() == "tagdependent") {
                    this.addBlockTag(String.valueOf(prefix) + ":" + ed.getNodeName(), (ITextRegionCollection)anchorStructuredDocumentRegion);
                }
                ++i;
            }
            boolean doTrack = true;
            List trackers = TLDCMDocumentManager.this.getTaglibTrackers();
            int i2 = 0;
            while (i2 < trackers.size()) {
                TaglibTracker tracker = (TaglibTracker)trackers.get(i2);
                if (tracker.getPrefix().equals(prefix) && tracker.getURI().equals(uri)) {
                    doTrack = false;
                }
                ++i2;
            }
            if (doTrack) {
                this.addTaglibTracker(prefix, uri, anchorStructuredDocumentRegion, tld);
            }
        }

        private void resetBlockTags() {
            if (TLDCMDocumentManager.this.getParser() == null) {
                return;
            }
            Iterator names = TLDCMDocumentManager.this.getParser().getBlockMarkers().iterator();
            while (names.hasNext()) {
                BlockMarker marker = (BlockMarker)names.next();
                if (marker.isGlobal() || marker.getContext() != "BLOCK_TEXT") continue;
                if (_debug) {
                    System.out.println("TLDCMDocumentManager removing block tag named: " + marker.getTagName());
                }
                names.remove();
            }
        }

        public void resetNodes() {
            TLDCMDocumentManager.this.getIncludes().clear();
            this.resetBlockTags();
            TLDCMDocumentManager.this.resetTaglibTrackers();
        }

        public void setStructuredDocument(IStructuredDocument newDocument) {
            Assert.isTrue((newDocument != null ? 1 : 0) != 0, (String)"null document");
            Assert.isTrue((newDocument.getParser() != null ? 1 : 0) != 0, (String)"null document parser");
            Assert.isTrue((boolean)(newDocument.getParser() instanceof XMLSourceParser), (String)"can only listen to document with a XMLSourceParser");
            TLDCMDocumentManager.this.getSourceParser().removeStructuredDocumentRegionHandler((StructuredDocumentRegionHandler)this);
            TLDCMDocumentManager.this.setSourceParser((XMLSourceParser)newDocument.getParser());
            TLDCMDocumentManager.this.getSourceParser().addStructuredDocumentRegionHandler((StructuredDocumentRegionHandler)this);
        }
    }

    protected class IncludeHelper
    extends DirectiveStructuredDocumentRegionHandler {
        protected IStructuredDocumentRegion fAnchor = null;
        protected XMLSourceParser fLocalParser = null;
        protected XMLSourceParser fParentParser = null;
        List taglibReferences = null;

        public IncludeHelper(IStructuredDocumentRegion anchor, XMLSourceParser rootParser) {
            this.fAnchor = anchor;
            this.fParentParser = rootParser;
            this.taglibReferences = new ArrayList(0);
        }

        protected void addTaglibTracker(String prefix, String uri, IStructuredDocumentRegion anchorStructuredDocumentRegion, CMDocument tldCMDocument) {
            super.addTaglibTracker(prefix, uri, anchorStructuredDocumentRegion, tldCMDocument);
            TLDCMDocumentReference reference = new TLDCMDocumentReference();
            reference.prefix = prefix;
            reference.uri = uri;
            this.taglibReferences.add(reference);
        }

        protected String getContents(IPath filePath) {
            return FileContentCache.getInstance().getContents(filePath);
        }

        public void nodeParsed(IStructuredDocumentRegion structuredDocumentRegion) {
            this.processRegionCollection((ITextRegionCollection)structuredDocumentRegion, this.fAnchor, this.fLocalParser);
        }

        void parse(IPath path) {
            XMLSourceParser p;
            this.fLocalParser = p = (XMLSourceParser)TLDCMDocumentManager.this.getParser().newInstance();
            String s = this.getContents(path);
            this.fLocalParser.addStructuredDocumentRegionHandler((StructuredDocumentRegionHandler)this);
            this.fLocalParser.reset(s);
            List blockTags = this.fParentParser.getBlockMarkers();
            int i = 0;
            while (i < blockTags.size()) {
                BlockMarker marker = (BlockMarker)blockTags.get(i);
                this.fLocalParser.addBlockMarker(new BlockMarker(marker.getTagName(), null, marker.getContext(), marker.isCaseSensitive()));
                ++i;
            }
            if (this.fParentParser instanceof JSPCapableParser && this.fLocalParser instanceof JSPCapableParser) {
                TagMarker[] knownPrefixes = ((JSPCapableParser)this.fParentParser).getNestablePrefixes().toArray(new TagMarker[0]);
                int i2 = 0;
                while (i2 < knownPrefixes.length) {
                    ((JSPCapableParser)this.fLocalParser).addNestablePrefix(new TagMarker(knownPrefixes[i2].getTagName(), null));
                    ++i2;
                }
            }
            this.fLocalParser.getDocumentRegions();
            this.fLocalParser = null;
        }

        public void resetNodes() {
        }
    }

    private class TLDCMDocumentReference {
        String prefix;
        String uri;

        private TLDCMDocumentReference() {
        }
    }

    static class TLDCacheEntry {
        CMDocument document;
        long modificationStamp;
        int referenceCount;

        TLDCacheEntry() {
        }
    }
}

