/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.context.symbol.internal.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.util.JDTBeanIntrospector;
import org.eclipse.jst.jsf.common.util.TypeUtil;
import org.eclipse.jst.jsf.context.symbol.IBoundedListTypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.IJavaTypeDescriptor2;
import org.eclipse.jst.jsf.context.symbol.IPropertySymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.ITypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.context.symbol.SymbolPackage;
import org.eclipse.jst.jsf.context.symbol.internal.impl.IListTypeDescriptorImpl;

public class IBoundedListTypeDescriptorImpl
extends IListTypeDescriptorImpl
implements IBoundedListTypeDescriptor {
    public static final String copyright = "Copyright 2006 Oracle";

    protected IBoundedListTypeDescriptorImpl() {
    }

    protected EClass eStaticClass() {
        return SymbolPackage.Literals.IBOUNDED_LIST_TYPE_DESCRIPTOR;
    }

    public boolean isUnboundedForType(String typeSignature) {
        return typeSignature != null && "Ljava.lang.Integer;".equals(typeSignature);
    }

    public ISymbol getUnboundedProperty(Object name, String typeSignature) {
        IPropertySymbol retValue = null;
        if (this.isUnboundedForType(typeSignature) && name instanceof Number) {
            int offset = ((Number)name).intValue();
            IPropertySymbol propSymbol = SymbolFactory.eINSTANCE.createIPropertySymbol();
            propSymbol.setName(name.toString());
            propSymbol.setReadable(true);
            propSymbol.setTypeDescriptor(this.getBoundsTypeDescriptor(offset));
            retValue = propSymbol;
        }
        return retValue;
    }

    public ISymbol call(String methodName, EList methodArguments, String symbolName) {
        JDTBeanIntrospector introspector;
        IMethod callMethod;
        IPropertySymbol result = null;
        IType type = this.resolveType(this.getTypeSignature());
        if (type != null && (callMethod = this.matchMethod(methodName, (List)methodArguments, (introspector = new JDTBeanIntrospector(type)).getAllMethods())) != null) {
            try {
                String retTypeSignature = TypeUtil.resolveTypeSignature(type, callMethod.getReturnType(), false);
                IPropertySymbol propSymbol = SymbolFactory.eINSTANCE.createIPropertySymbol();
                propSymbol.setName(symbolName);
                propSymbol.setReadable(true);
                IJavaTypeDescriptor2 typeDesc = SymbolFactory.eINSTANCE.createIJavaTypeDescriptor2();
                typeDesc.setArrayCount(Signature.getArrayCount((String)retTypeSignature));
                typeDesc.setType(this.resolveType(retTypeSignature));
                typeDesc.setTypeSignatureDelegate(retTypeSignature);
                propSymbol.setTypeDescriptor(typeDesc);
                result = propSymbol;
            }
            catch (JavaModelException e) {
                JSFCommonPlugin.log(e);
            }
        }
        return result;
    }

    private IMethod matchMethod(String name, List methodArguments, IMethod[] allMethods) {
        List argSigs = this.convertArgsToSignatures(methodArguments);
        IMethod matchedMethod = null;
        int i = 0;
        while (i < allMethods.length) {
            IMethod method = allMethods[i];
            if (method.getParameterTypes().length == argSigs.size() && method.getElementName().equals(name)) {
                String[] methods = method.getParameterTypes();
                boolean isMatched = true;
                int j = 0;
                while (j < methods.length) {
                    if (!methods[j].equals(argSigs.get(j))) {
                        isMatched = false;
                        break;
                    }
                    ++j;
                }
                if (isMatched) {
                    return method;
                }
            }
            ++i;
        }
        return matchedMethod;
    }

    private List convertArgsToSignatures(List methodArgs) {
        ArrayList<String> args = new ArrayList<String>();
        for (Object arg : methodArgs) {
            String className = arg.getClass().getName();
            String resolvedName = Signature.createTypeSignature((String)className, (boolean)true);
            args.add(resolvedName);
        }
        return args;
    }

    private ITypeDescriptor getBoundsTypeDescriptor(int offset) {
        IJavaTypeDescriptor2 typeDesc = null;
        EList typeParameters = this.getTypeParameterSignatures();
        if (typeParameters.size() == 0) {
            typeDesc = SymbolFactory.eINSTANCE.createIBoundedJavaTypeDescriptor();
            typeDesc.setTypeSignatureDelegate("Ljava.lang.Object;");
        } else {
            String elementType = (String)typeParameters.get(0);
            typeDesc = SymbolFactory.eINSTANCE.createIJavaTypeDescriptor2();
            typeDesc.setArrayCount(Signature.getArrayCount((String)elementType));
            typeDesc.setType(this.resolveType(elementType));
            typeDesc.setTypeSignatureDelegate(elementType);
        }
        return typeDesc;
    }
}

