/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.internal.DomainLoadingStrategyRegistry;
import org.eclipse.jst.jsf.common.metadata.internal.IDomainLoadingStrategy;
import org.eclipse.jst.jsf.common.metadata.internal.MetaDataModel;
import org.eclipse.jst.jsf.common.metadata.internal.ModelKeyDescriptor;
import org.eclipse.jst.jsf.common.metadata.internal.ModelNotSetException;
import org.eclipse.jst.jsf.common.metadata.internal.StandardModelFactory;
import org.eclipse.jst.jsf.common.metadata.query.ITaglibDomainMetaDataModelContext;

public class MetaDataModelManager
implements IResourceChangeListener {
    public static final QualifiedName KEY_SESSIONPROPERTY = new QualifiedName(null, "MetaDataModelManager");
    private static MetaDataModelManager SHARED_INSTANCE;
    private static final Object GLOBAL_INSTANCE_LOCK;
    private final ModelMap models;
    private final IProject project;

    static {
        GLOBAL_INSTANCE_LOCK = new Object();
    }

    public static synchronized MetaDataModelManager getSharedInstance() {
        if (SHARED_INSTANCE == null) {
            SHARED_INSTANCE = new MetaDataModelManager(null);
        }
        return SHARED_INSTANCE;
    }

    public static synchronized MetaDataModelManager getInstance(IProject project) {
        MetaDataModelManager repo = null;
        if (project != null && project.isAccessible() && (repo = MetaDataModelManager.getFromSessionProperty(project)) == null) {
            repo = new MetaDataModelManager(project);
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)repo, 6);
        }
        return repo;
    }

    private MetaDataModelManager(IProject project) {
        this.project = project;
        this.models = new ModelMap();
        this.setAsSessionProperty();
    }

    private static MetaDataModelManager getFromSessionProperty(IProject project) {
        MetaDataModelManager repo = null;
        try {
            Object obj = project.getSessionProperty(KEY_SESSIONPROPERTY);
            if (obj instanceof MetaDataModelManager) {
                repo = (MetaDataModelManager)obj;
            }
        }
        catch (CoreException ce) {
            JSFCommonPlugin.log(4, "Internal Error: Unable to recover MetaDataModelManager for: " + project.getName(), ce);
        }
        return repo;
    }

    private void setAsSessionProperty() {
        if (this.project != null && this.project.isAccessible()) {
            try {
                this.project.setSessionProperty(KEY_SESSIONPROPERTY, (Object)this);
            }
            catch (CoreException ce) {
                JSFCommonPlugin.log(4, "Internal Error: Unable to store MetaDataModelManager for: " + this.project.getName(), ce);
            }
        }
    }

    private void removeAsSessionProperty(IProject aProject) {
        try {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            aProject.setSessionProperty(KEY_SESSIONPROPERTY, null);
        }
        catch (CoreException e) {
            JSFCommonPlugin.log((Exception)((Object)e), "Error removing session property");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaDataModel getModel(ITaglibDomainMetaDataModelContext modelContext) {
        Object object = GLOBAL_INSTANCE_LOCK;
        synchronized (object) {
            ModelKeyDescriptor modelKeyDescriptor = StandardModelFactory.getInstance().createModelKeyDescriptor(modelContext);
            StandardModelFactory.debug(">START getModel: " + modelKeyDescriptor, StandardModelFactory.DEBUG_MD_GET);
            MetaDataModel model = this.models.get(modelKeyDescriptor);
            if (model == null || this.project == null) {
                model = this.loadMetadata(modelKeyDescriptor);
            } else if (model.needsRefresh()) {
                try {
                    model.reload();
                }
                catch (ModelNotSetException modelNotSetException) {
                    model = this.loadMetadata(modelKeyDescriptor);
                }
            }
            if (model != null && model.getRoot() != null) {
                ((Model)model.getRoot()).setCurrentModelContext(modelKeyDescriptor);
            }
            StandardModelFactory.debug(">END getModel: " + modelKeyDescriptor, StandardModelFactory.DEBUG_MD_GET);
            return model;
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IProject aProject;
        if ((event.getType() == 2 || event.getType() == 4) && (aProject = (IProject)event.getResource()) != null && aProject.equals((Object)this.project)) {
            SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    JSFCommonPlugin.log(exception);
                }

                public void run() throws Exception {
                    MetaDataModelManager.this.models.dispose();
                    MetaDataModelManager.this.removeAsSessionProperty(MetaDataModelManager.this.project);
                }
            });
        }
    }

    private MetaDataModel loadMetadata(ModelKeyDescriptor modelKeyDescriptor) {
        if (!Thread.holdsLock(GLOBAL_INSTANCE_LOCK)) {
            JSFCommonPlugin.log(4, "Internal Error: loadMetadata must not be called if class lock not held");
            return null;
        }
        IDomainLoadingStrategy strategy = DomainLoadingStrategyRegistry.getInstance().getLoadingStrategy(modelKeyDescriptor.getDomain());
        if (strategy == null) {
            JSFCommonPlugin.log(4, "Internal Error: Unable to locate metadata loading strategy for: " + modelKeyDescriptor.toString());
            return null;
        }
        MetaDataModel model = StandardModelFactory.getInstance().createModel(modelKeyDescriptor, strategy);
        model.load();
        this.addModel(model);
        return model;
    }

    private void addModel(MetaDataModel model) {
        if (model != null) {
            this.models.put(model);
        }
    }

    private static class ModelMap {
        private final Map<String, MetaDataModel> map;
        private final AtomicBoolean _isDisposed = new AtomicBoolean(false);

        ModelMap() {
            this.map = new HashMap<String, MetaDataModel>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(MetaDataModel model) {
            assert (!this._isDisposed.get());
            String key = this.calculateKey(model);
            ModelMap modelMap = this;
            synchronized (modelMap) {
                this.map.put(key, model);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MetaDataModel get(ModelKeyDescriptor modelKeyDescriptor) {
            assert (!this._isDisposed.get());
            String key = this.calculateKey(modelKeyDescriptor);
            ModelMap modelMap = this;
            synchronized (modelMap) {
                return this.map.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            if (this._isDisposed.compareAndSet(false, true)) {
                ModelMap modelMap = this;
                synchronized (modelMap) {
                    Iterator<Map.Entry<String, MetaDataModel>> it = this.map.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<String, MetaDataModel> entry = it.next();
                        MetaDataModel model = entry.getValue();
                        if (model != null) {
                            model.cleanup();
                        }
                        it.remove();
                    }
                }
            }
        }

        private String calculateKey(MetaDataModel model) {
            return this.calculateKey(model.getModelKey());
        }

        private String calculateKey(ModelKeyDescriptor modelKeyDescriptor) {
            return modelKeyDescriptor.toString();
        }
    }
}

