/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.nosql.eclipselink.ui.internal.persistence.connection;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.widgets.ClassChooserPane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.connection.MongoDBConnection;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.connection.NoSqlConnection;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.persistence.connection.NoSqlConnectionPropertiesComposite;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoDBConnectionPropopertiesComposite<T extends MongoDBConnection>
extends NoSqlConnectionPropertiesComposite<T> {
    private static String DEFAULT_KEY = "?!#!?#?#?default?#?!#?!#?";

    public MongoDBConnectionPropopertiesComposite(Pane<T> parent, Composite parentComposite) {
        super(parent, parentComposite);
    }

    private void addMongoDBOptions(Composite container) {
        Section section = this.getWidgetFactory().createSection(container, 18);
        section.setText(EclipseLinkUiMessages.PersistenceXmlConnectionTab_optionsLabel);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        section.setLayoutData((Object)gridData);
        container = this.getWidgetFactory().createComposite((Composite)section);
        section.setClient((Control)container);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        container.setLayout((Layout)gridLayout);
        container.setLayoutData((Object)new GridData(1808));
        this.addLabel(container, EclipseLinkUiMessages.PersistenceXmlConnectionTab_userLabel);
        this.addText(container, this.buildUserHolder());
        this.addLabel(container, EclipseLinkUiMessages.PersistenceXmlConnectionTab_passwordLabel);
        this.addText(container, this.buildPasswordHolder());
        this.addLabel(container, EclipseLinkUiMessages.PersistenceXmlConnectionTab_readPreferenceLabel);
        this.addCombo(container, this.buildExtendedReadPreferenceListHolder(), this.buildReadPreferenceHolder(), this.buildReadPreferenceConverter(), this.buildReadPreferenceEnabledHolder());
        this.addLabel(container, EclipseLinkUiMessages.PersistenceXmlConnectionTab_writeConcernLabel);
        this.addCombo(container, this.buildExtendedWriteConcernListHolder(), this.buildWriteConcernHolder(), this.buildWriteConcernConverter(), this.buildWriteConcernEnabledHolder());
    }

    private ModifiablePropertyValueModel<String> buildDatabaseNameHolder() {
        return new PropertyAspectAdapter<MongoDBConnection, String>(this.getSubjectHolder(), new String[]{"databaseName"}){

            protected String buildValue_() {
                return ((MongoDBConnection)this.subject).getDatabaseName();
            }

            protected void setValue_(String value) {
                ((MongoDBConnection)this.subject).setDatabaseName(value);
            }
        };
    }

    private PropertyValueModel<String> buildDefaultReadPreferenceHolder() {
        return new TransformationPropertyValueModel<MongoDBConnection, String>(this.getSubjectHolder()){

            protected String transform_(MongoDBConnection connection) {
                String value = connection.getDefaultReadPreference();
                return StringTools.isBlank((String)value) ? DEFAULT_KEY : String.valueOf(DEFAULT_KEY) + value;
            }
        };
    }

    private ListValueModel<String> buildDefaultReadPreferenceListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultReadPreferenceHolder());
    }

    private PropertyValueModel<String> buildDefaultWriteConcernHolder() {
        return new TransformationPropertyValueModel<MongoDBConnection, String>(this.getSubjectHolder()){

            protected String transform_(MongoDBConnection connection) {
                String value = connection.getDefaultWriteConcern();
                return StringTools.isBlank((String)value) ? DEFAULT_KEY : String.valueOf(DEFAULT_KEY) + value;
            }
        };
    }

    private ListValueModel<String> buildDefaultWriteConcernListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultWriteConcernHolder());
    }

    private ListValueModel<String> buildExtendedReadPreferenceListHolder() {
        ArrayList<ListValueModel<String>> holders = new ArrayList<ListValueModel<String>>(2);
        holders.add(this.buildDefaultReadPreferenceListHolder());
        holders.add(this.buildReadPreferenceListHolder());
        return CompositeListValueModel.forModels(holders);
    }

    private ListValueModel<String> buildExtendedWriteConcernListHolder() {
        ArrayList<ListValueModel<String>> holders = new ArrayList<ListValueModel<String>>(2);
        holders.add(this.buildDefaultWriteConcernListHolder());
        holders.add(this.buildWriteConcernListHolder());
        return CompositeListValueModel.forModels(holders);
    }

    private ModifiablePropertyValueModel<String> buildHostHolder() {
        return new PropertyAspectAdapter<MongoDBConnection, String>(this.getSubjectHolder(), new String[]{"host"}){

            protected String buildValue_() {
                return ((MongoDBConnection)this.subject).getHost();
            }

            protected void setValue_(String value) {
                ((MongoDBConnection)this.subject).setHost(value);
            }
        };
    }

    private ModifiablePropertyValueModel<String> buildOptionsHolder() {
        return new PropertyAspectAdapter<MongoDBConnection, String>(this.getSubjectHolder(), new String[]{"options"}){

            protected String buildValue_() {
                return ((MongoDBConnection)this.subject).getOptions();
            }

            protected void setValue_(String value) {
                ((MongoDBConnection)this.subject).setOptions(value.length() == 0 ? null : value);
            }
        };
    }

    private ModifiablePropertyValueModel<String> buildPasswordHolder() {
        return new PropertyAspectAdapter<MongoDBConnection, String>(this.getSubjectHolder(), new String[]{"password"}){

            protected String buildValue_() {
                return ((MongoDBConnection)this.subject).getPassword();
            }

            protected void setValue_(String value) {
                ((MongoDBConnection)this.subject).setPassword(value.length() == 0 ? null : value);
            }
        };
    }

    private ModifiablePropertyValueModel<String> buildPortdHolder() {
        return new PropertyAspectAdapter<MongoDBConnection, String>(this.getSubjectHolder(), new String[]{"port"}){

            protected String buildValue_() {
                return ((MongoDBConnection)this.subject).getPort();
            }

            protected void setValue_(String value) {
                ((MongoDBConnection)this.subject).setPort(value);
            }
        };
    }

    private Comparator<String> buildReadPreferenceComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String value1, String value2) {
                String displayString1 = MongoDBConnectionPropopertiesComposite.this.readPreferenceDisplayString(value1);
                String displayString2 = MongoDBConnectionPropopertiesComposite.this.readPreferenceDisplayString(value2);
                return Collator.getInstance().compare(displayString1, displayString2);
            }
        };
    }

    private Transformer<String, String> buildReadPreferenceConverter() {
        return new Transformer<String, String>(){

            public String transform(String value) {
                if (MongoDBConnectionPropopertiesComposite.this.getSubject() == null) {
                    return null;
                }
                if (value == null || value.startsWith(DEFAULT_KEY)) {
                    return NLS.bind((String)JptCommonUiMessages.DEFAULT_WITH_ONE_PARAM, (Object)MongoDBConnectionPropopertiesComposite.this.readPreferenceDisplayString(((MongoDBConnection)MongoDBConnectionPropopertiesComposite.this.getSubject()).getDefaultReadPreference()));
                }
                return MongoDBConnectionPropopertiesComposite.this.readPreferenceDisplayString(value);
            }
        };
    }

    private PropertyValueModel<Boolean> buildReadPreferenceEnabledHolder() {
        return this.buildNotNullSubjectModel();
    }

    private ModifiablePropertyValueModel<String> buildReadPreferenceHolder() {
        return new PropertyAspectAdapter<MongoDBConnection, String>(this.getSubjectHolder(), new String[]{"read-preference"}){

            protected String buildValue_() {
                return ((MongoDBConnection)this.subject).getReadPreference();
            }

            protected void setValue_(String value) {
                if (value.startsWith(DEFAULT_KEY)) {
                    value = null;
                }
                ((MongoDBConnection)this.subject).setReadPreference(value);
            }
        };
    }

    private ListValueModel<String> buildReadPreferenceListHolder() {
        return new SimpleListValueModel(this.buildSortedReadPreferenceList());
    }

    private List<String> buildSortedReadPreferenceList() {
        return ListTools.sort((List)ListTools.list((Object[])new String[]{"PRIMARY", "SECONDARY"}), this.buildReadPreferenceComparator());
    }

    private List<String> buildSortedWriteConcernList() {
        return ListTools.sort((List)ListTools.list(this.writeConcerns()), (Comparator)Collator.getInstance());
    }

    private ModifiablePropertyValueModel<String> buildUserHolder() {
        return new PropertyAspectAdapter<MongoDBConnection, String>(this.getSubjectHolder(), new String[]{"user"}){

            protected String buildValue_() {
                return ((MongoDBConnection)this.subject).getUser();
            }

            protected void setValue_(String value) {
                ((MongoDBConnection)this.subject).setUser(value.length() == 0 ? null : value);
            }
        };
    }

    private Transformer<String, String> buildWriteConcernConverter() {
        return new Transformer<String, String>(){

            public String transform(String value) {
                if (MongoDBConnectionPropopertiesComposite.this.getSubject() == null) {
                    return null;
                }
                if (value == null || value.startsWith(DEFAULT_KEY)) {
                    return NLS.bind((String)JptCommonUiMessages.DEFAULT_WITH_ONE_PARAM, (Object)((MongoDBConnection)MongoDBConnectionPropopertiesComposite.this.getSubject()).getDefaultWriteConcern());
                }
                return value;
            }
        };
    }

    private PropertyValueModel<Boolean> buildWriteConcernEnabledHolder() {
        return this.buildNotNullSubjectModel();
    }

    private ModifiablePropertyValueModel<String> buildWriteConcernHolder() {
        return new PropertyAspectAdapter<MongoDBConnection, String>(this.getSubjectHolder(), new String[]{"write-preference"}){

            protected String buildValue_() {
                return ((MongoDBConnection)this.subject).getWriteConcern();
            }

            protected void setValue_(String value) {
                if (value.startsWith(DEFAULT_KEY)) {
                    value = null;
                }
                ((MongoDBConnection)this.subject).setWriteConcern(value == null ? null : value);
            }
        };
    }

    private ListValueModel<String> buildWriteConcernListHolder() {
        return new SimpleListValueModel(this.buildSortedWriteConcernList());
    }

    private ClassChooserPane<NoSqlConnection> initializeConnectionSpecClassChooser(Composite container) {
        return new ClassChooserPane<NoSqlConnection>((Pane)this, container){

            protected ModifiablePropertyValueModel<String> buildTextHolder() {
                return new PropertyAspectAdapter<NoSqlConnection, String>(this.getSubjectHolder(), new String[]{"connection-spec"}){

                    protected String buildValue_() {
                        return ((NoSqlConnection)this.subject).getConnectionSpec();
                    }

                    protected void setValue_(String value) {
                        ((NoSqlConnection)this.subject).setConnectionSpec(value.length() == 0 ? null : value);
                    }
                };
            }

            protected String getClassName() {
                return ((NoSqlConnection)this.getSubject()).getConnectionSpec();
            }

            protected IJavaProject getJavaProject() {
                return ((NoSqlConnection)this.getSubject()).getJpaProject().getJavaProject();
            }

            protected void setClassName(String className) {
                ((NoSqlConnection)this.getSubject()).setConnectionSpec(className);
            }
        };
    }

    @Override
    protected void initializeNoSqlConnection(Composite container) {
        this.addLabel(container, EclipseLinkUiMessages.PersistenceXmlConnectionTab_connectionSpecLabel);
        this.initializeConnectionSpecClassChooser(container);
        this.addLabel(container, EclipseLinkUiMessages.PersistenceXmlConnectionTab_nameLabel);
        this.addText(container, this.buildDatabaseNameHolder());
        this.addLabel(container, EclipseLinkUiMessages.PersistenceXmlConnectionTab_hostLabel);
        this.addText(container, this.buildHostHolder());
        this.addLabel(container, EclipseLinkUiMessages.PersistenceXmlConnectionTab_portLabel);
        this.addText(container, this.buildPortdHolder());
        this.addMongoDBOptions(container);
    }

    private String readPreferenceDisplayString(String value) {
        if ("PRIMARY".equals(value)) {
            return EclipseLinkUiMessages.PersistenceXmlConnectionTab_readPreference_primary;
        }
        if ("SECONDARY".equals(value)) {
            return EclipseLinkUiMessages.PersistenceXmlConnectionTab_readPreference_secondary;
        }
        return EclipseLinkUiMessages.PersistenceXmlConnectionTab_readPreference_unknown;
    }

    private Iterable<String> writeConcerns() {
        ArrayList<String> names = new ArrayList<String>();
        MongoDBConnection.WriteConcern[] writeConcernArray = MongoDBConnection.WriteConcern.values();
        int n = writeConcernArray.length;
        int n2 = 0;
        while (n2 < n) {
            MongoDBConnection.WriteConcern value = writeConcernArray[n2];
            names.add(value.name());
            ++n2;
        }
        return names;
    }
}

