/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.prosystfi;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.vorto.codegen.api.ChainedCodeGeneratorTask;
import org.eclipse.vorto.codegen.api.GenerationResultZip;
import org.eclipse.vorto.codegen.api.GeneratorTaskFromFileTemplate;
import org.eclipse.vorto.codegen.api.ICodeGeneratorTask;
import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.IGeneratedWriter;
import org.eclipse.vorto.codegen.api.IGenerationResult;
import org.eclipse.vorto.codegen.api.IVortoCodeGenerator;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.prosystfi.tasks.FunctionalItemGeneratorTask;
import org.eclipse.vorto.codegen.prosystfi.tasks.FunctionalItemImplGeneratorTask;
import org.eclipse.vorto.codegen.prosystfi.tasks.JavaClassGeneratorTask;
import org.eclipse.vorto.codegen.prosystfi.tasks.JavaEnumGeneratorTask;
import org.eclipse.vorto.codegen.prosystfi.templates.EclipseClasspathTemplate;
import org.eclipse.vorto.codegen.prosystfi.templates.EclipseProjectFileTemplate;
import org.eclipse.vorto.codegen.prosystfi.templates.FIBuildFileTemplate;
import org.eclipse.vorto.codegen.prosystfi.templates.FIManifestFileTemplate;
import org.eclipse.vorto.codegen.utils.Utils;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;

public class ProSystGenerator
implements IVortoCodeGenerator {
    public static final String JAVA_FILE_EXTENSION = ".java";
    public static final String PLUGIN_NATURE_STRING = "org.eclipse.pde.PluginNature";
    public static final String SOURCE = "src";
    public static final String GETTER_PREFIX = "get";
    public static final String SETTER_PREFIX = "set";

    public IGenerationResult generate(InformationModel infomodel, InvocationContext ctx) {
        GenerationResultZip zipOutputter = new GenerationResultZip(infomodel, this.getServiceKey());
        HashSet<Object> visited = new HashSet<Object>();
        HashSet<String> exports = new HashSet<String>();
        for (FunctionblockProperty fbp : infomodel.getProperties()) {
            HashSet<String> imports = new HashSet<String>();
            FunctionBlock fb = fbp.getType().getFunctionblock();
            for (Entity entity : Utils.getReferencedEntities((FunctionBlock)fb)) {
                if (!visited.contains(entity)) {
                    this.generateForEntity(infomodel, ctx, entity, (IGeneratedWriter)zipOutputter);
                    visited.add(entity);
                }
                imports.add(entity.getNamespace());
                exports.add(entity.getNamespace());
            }
            for (Enum en : Utils.getReferencedEnums((FunctionBlock)fb)) {
                if (!visited.contains(en)) {
                    this.generateForEnum(infomodel, ctx, en, (IGeneratedWriter)zipOutputter);
                    visited.add(en);
                }
                imports.add(en.getNamespace());
                exports.add(en.getNamespace());
            }
            exports.add(infomodel.getNamespace());
            this.generateForFunctionBlock(infomodel, ctx, fbp.getType(), (IGeneratedWriter)zipOutputter, imports.toArray(new String[imports.size()]));
        }
        this.generateEclipseProject(infomodel, ctx, (IGeneratedWriter)zipOutputter, exports);
        return zipOutputter;
    }

    private void generateEclipseProject(InformationModel infomodel, InvocationContext ctx, IGeneratedWriter outputter, Set<String> exports) {
        ChainedCodeGeneratorTask generator = new ChainedCodeGeneratorTask();
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new FIManifestFileTemplate(exports)));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new FIBuildFileTemplate()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new EclipseProjectFileTemplate()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new EclipseClasspathTemplate()));
        generator.generate((Object)infomodel, ctx, outputter);
    }

    private void generateForFunctionBlock(InformationModel infomodel, InvocationContext ctx, FunctionblockModel fbm, IGeneratedWriter outputter, String[] imports) {
        ChainedCodeGeneratorTask generator = new ChainedCodeGeneratorTask();
        generator.addTask((ICodeGeneratorTask)new FunctionalItemGeneratorTask(JAVA_FILE_EXTENSION, SOURCE, fbm.getNamespace(), new String[0]));
        generator.addTask((ICodeGeneratorTask)new FunctionalItemImplGeneratorTask(JAVA_FILE_EXTENSION, SOURCE, fbm.getNamespace(), imports));
        generator.generate((Object)fbm, ctx, outputter);
    }

    private void generateForEntity(InformationModel infomodel, InvocationContext ctx, Entity entity, IGeneratedWriter outputter) {
        ChainedCodeGeneratorTask generator = new ChainedCodeGeneratorTask();
        generator.addTask((ICodeGeneratorTask)new JavaClassGeneratorTask(JAVA_FILE_EXTENSION, SOURCE, entity.getNamespace(), GETTER_PREFIX, SETTER_PREFIX));
        generator.generate((Object)entity, ctx, outputter);
    }

    private void generateForEnum(InformationModel infomodel, InvocationContext ctx, Enum en, IGeneratedWriter outputter) {
        ChainedCodeGeneratorTask generator = new ChainedCodeGeneratorTask();
        generator.addTask((ICodeGeneratorTask)new JavaEnumGeneratorTask(JAVA_FILE_EXTENSION, SOURCE, en.getNamespace()));
        generator.generate((Object)en, ctx, outputter);
    }

    public String getServiceKey() {
        return "prosyst";
    }
}

