/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregion.internal;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.virgo.kernel.userregion.internal.KernelStartedAwaiter;
import org.eclipse.virgo.kernel.userregion.internal.UserRegionLogEvents;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.nano.core.Shutdown;
import org.eclipse.virgo.nano.deployer.api.core.ApplicationDeployer;
import org.eclipse.virgo.nano.deployer.api.core.DeployUriNormaliser;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentOptions;
import org.eclipse.virgo.util.common.StringUtils;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

final class InitialArtifactDeployer
implements EventHandler {
    private static final String THREAD_NAME_SYSTEM_ARTIFACTS = "system-artifacts";
    private static final String THREAD_NAME_USER_ARTIFACTS = "user-artifacts";
    private static final DeploymentOptions ARTIFACT_DEPLOYMENT_OPTIONS = new DeploymentOptions(false, false, true);
    private static final String TOPIC_SYSTEM_ARTIFACTS_DEPLOYED = "org/eclipse/virgo/kernel/userregion/systemartifacts/DEPLOYED";
    private static final String TOPIC_USER_ARTIFACTS_DEPLOYED = "org/eclipse/virgo/kernel/userregion/userartifacts/DEPLOYED";
    private final ApplicationDeployer deployer;
    private final DeployUriNormaliser uriNormaliser;
    private final EventAdmin eventAdmin;
    private final String systemArtifactsProperty;
    private final String userArtifactsProperty;
    private final EventLogger eventLogger;
    private final Shutdown shutdown;
    private final KernelStartedAwaiter startAwaiter;

    InitialArtifactDeployer(KernelStartedAwaiter startAwaiter, ApplicationDeployer deployer, Object systemArtifactsProperty, Object userArtifactsProperty, DeployUriNormaliser uriNormaliser, EventAdmin eventAdmin, EventLogger eventLogger, Shutdown shutdown) {
        this.deployer = deployer;
        this.uriNormaliser = uriNormaliser;
        this.eventAdmin = eventAdmin;
        this.systemArtifactsProperty = systemArtifactsProperty != null ? systemArtifactsProperty.toString() : null;
        this.userArtifactsProperty = userArtifactsProperty != null ? userArtifactsProperty.toString() : null;
        this.eventLogger = eventLogger;
        this.shutdown = shutdown;
        this.startAwaiter = startAwaiter;
    }

    public void handleEvent(Event event) {
        if (TOPIC_SYSTEM_ARTIFACTS_DEPLOYED.equals(event.getTopic())) {
            this.eventLogger.log((LogEvent)UserRegionLogEvents.SYSTEM_ARTIFACTS_DEPLOYED, new Object[0]);
            this.deployUserArtifacts();
        }
    }

    void deployArtifacts() throws InterruptedException {
        this.startAwaiter.awaitKernelStarted();
        List<URI> systemArtifacts = this.getSystemArtifacts();
        this.deployArtifacts(systemArtifacts, THREAD_NAME_SYSTEM_ARTIFACTS, TOPIC_SYSTEM_ARTIFACTS_DEPLOYED);
    }

    private void deployUserArtifacts() {
        List<URI> userArtifacts = this.getUserArtifacts();
        this.deployArtifacts(userArtifacts, THREAD_NAME_USER_ARTIFACTS, TOPIC_USER_ARTIFACTS_DEPLOYED);
    }

    private List<URI> getUserArtifacts() {
        return this.getRepositoryUrisForArtifacts(this.userArtifactsProperty);
    }

    private List<URI> getSystemArtifacts() {
        return this.getRepositoryUrisForArtifacts(this.systemArtifactsProperty);
    }

    private List<URI> getRepositoryUrisForArtifacts(String artifactsProperty) {
        String[] artifacts = StringUtils.commaDelimitedListToStringArray((String)artifactsProperty);
        ArrayList<URI> repositoryUris = new ArrayList<URI>();
        String[] stringArray = artifacts;
        int n = artifacts.length;
        int n2 = 0;
        while (n2 < n) {
            String artifact = stringArray[n2];
            repositoryUris.add(URI.create(artifact.trim()));
            ++n2;
        }
        return repositoryUris;
    }

    private void deployArtifacts(List<URI> artifacts, String threadName, String completionEventTopic) {
        ArtifactDeployingRunnable artifactDeployingRunnable = new ArtifactDeployingRunnable(artifacts, completionEventTopic);
        Thread deployThread = new Thread((Runnable)artifactDeployingRunnable, threadName);
        deployThread.start();
    }

    private final class ArtifactDeployingRunnable
    implements Runnable {
        private final List<URI> artifacts;
        private final String completionEventTopic;

        private ArtifactDeployingRunnable(List<URI> artifacts, String completionEventTopic) {
            this.artifacts = artifacts;
            this.completionEventTopic = completionEventTopic;
        }

        @Override
        public void run() {
            try {
                this.validateArtifacts();
                this.deployArtifacts();
                InitialArtifactDeployer.this.eventAdmin.postEvent(new Event(this.completionEventTopic, null));
            }
            catch (DeploymentException deploymentException) {
                InitialArtifactDeployer.this.eventLogger.log((LogEvent)UserRegionLogEvents.INITIAL_ARTIFACT_DEPLOYMENT_FAILED, new Object[0]);
                InitialArtifactDeployer.this.shutdown.shutdown();
            }
        }

        private void deployArtifacts() throws DeploymentException {
            for (URI artifact : this.artifacts) {
                InitialArtifactDeployer.this.deployer.deploy(artifact, ARTIFACT_DEPLOYMENT_OPTIONS);
            }
        }

        private void validateArtifacts() throws DeploymentException {
            boolean normaliseFailed = false;
            for (URI uri : this.artifacts) {
                try {
                    InitialArtifactDeployer.this.uriNormaliser.normalise(uri);
                }
                catch (DeploymentException deploymentException) {
                    normaliseFailed = true;
                }
            }
            if (normaliseFailed) {
                throw new DeploymentException("Validation of artifacts failed");
            }
        }
    }
}

