/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.enterprise.openejb.deployer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.openejb.ClassLoaderUtil;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.DeploymentLoader;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.Module;
import org.apache.openejb.config.PersistenceModule;
import org.apache.openejb.config.ReadDescriptors;
import org.apache.openejb.config.ResourcesModule;
import org.apache.openejb.config.TldScanner;
import org.apache.openejb.config.UnknownModuleTypeException;
import org.apache.openejb.config.UnsupportedModuleTypeException;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.config.event.BeforeDeploymentEvent;
import org.apache.openejb.core.EmptyResourcesClassLoader;
import org.apache.openejb.jee.Application;
import org.apache.openejb.jee.Beans;
import org.apache.openejb.jee.FacesConfig;
import org.apache.openejb.jee.JspConfig;
import org.apache.openejb.jee.Taglib;
import org.apache.openejb.jee.TldTaglib;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.URLs;
import org.apache.xbean.finder.ResourceFinder;

public class VirgoDeploymentLoader
extends DeploymentLoader {
    private static final String VIRGO_ROOT_APPLICATION_RESERVED_MODULE_ID = "virgoRootApplicationReservedModuleID";
    private ServletContext servletContext;
    private static final String ddDir = "META-INF/";

    public VirgoDeploymentLoader(ServletContext context) {
        this.servletContext = context;
    }

    public AppModule load(File jarFile) throws OpenEJBException {
        Class moduleClass;
        block24: {
            AppModule appModule;
            block25: {
                URLClassLoader doNotUseClassLoader;
                URL baseUrl;
                block22: {
                    AppModule appModule2;
                    block23: {
                        block20: {
                            AppModule appModule3;
                            block21: {
                                String jarPath;
                                block18: {
                                    AppModule appModule4;
                                    block19: {
                                        block16: {
                                            AppModule appModule5;
                                            block17: {
                                                try {
                                                    jarPath = jarFile.getCanonicalPath();
                                                }
                                                catch (IOException e) {
                                                    throw new OpenEJBException("Invalid application file path " + jarFile, (Throwable)e);
                                                }
                                                baseUrl = VirgoDeploymentLoader.getFileUrl((File)jarFile);
                                                doNotUseClassLoader = null;
                                                try {
                                                    try {
                                                        doNotUseClassLoader = ClassLoaderUtil.createClassLoader((String)jarPath, (URL[])new URL[]{baseUrl}, (ClassLoader)this.getOpenEJBClassLoader());
                                                        moduleClass = this.discoverModuleType(baseUrl, ClassLoaderUtil.createTempClassLoader((ClassLoader)doNotUseClassLoader), true);
                                                    }
                                                    catch (Exception e) {
                                                        throw new UnknownModuleTypeException("Unable to determine module type for jar: " + baseUrl.toExternalForm(), (Throwable)e);
                                                    }
                                                    if (!ResourcesModule.class.equals((Object)moduleClass)) break block16;
                                                    AppModule appModule6 = new AppModule(null, jarPath);
                                                    ResourcesModule module = new ResourcesModule();
                                                    module.getAltDDs().put("resources.xml", baseUrl);
                                                    ReadDescriptors.readResourcesXml((Module)module);
                                                    module.initAppModule(appModule6);
                                                    appModule6.setModuleId(this.createModuleIDFromWebContextPath());
                                                    appModule5 = appModule6;
                                                    if (doNotUseClassLoader == null) break block17;
                                                }
                                                catch (Throwable throwable) {
                                                    if (doNotUseClassLoader != null) {
                                                        ClassLoaderUtil.destroyClassLoader(doNotUseClassLoader);
                                                    }
                                                    throw throwable;
                                                }
                                                ClassLoaderUtil.destroyClassLoader((ClassLoader)doNotUseClassLoader);
                                            }
                                            return appModule5;
                                        }
                                        if (!AppModule.class.equals((Object)moduleClass)) break block18;
                                        AppModule appModule7 = this.createAppModule(jarFile, jarPath);
                                        appModule7.setModuleId(this.createModuleIDFromWebContextPath());
                                        appModule4 = appModule7;
                                        if (doNotUseClassLoader == null) break block19;
                                        ClassLoaderUtil.destroyClassLoader((ClassLoader)doNotUseClassLoader);
                                    }
                                    return appModule4;
                                }
                                if (!EjbModule.class.equals((Object)moduleClass)) break block20;
                                URL[] urls = new URL[]{baseUrl};
                                SystemInstance.get().fireEvent((Object)new BeforeDeploymentEvent(urls));
                                EjbModule ejbModule = this.createEjbModule(baseUrl, jarPath, this.getWebAppClassLoader());
                                AppModule appModule8 = new AppModule((DeploymentModule)ejbModule);
                                VirgoDeploymentLoader.addPersistenceUnits((AppModule)appModule8, (URL[])new URL[]{baseUrl});
                                appModule8.setModuleId(this.createModuleIDFromWebContextPath());
                                appModule3 = appModule8;
                                if (doNotUseClassLoader == null) break block21;
                                ClassLoaderUtil.destroyClassLoader((ClassLoader)doNotUseClassLoader);
                            }
                            return appModule3;
                        }
                        if (!WebModule.class.equals((Object)moduleClass)) break block22;
                        File file = URLs.toFile((URL)baseUrl);
                        WebModule webModule = this.createWebModule(file.getAbsolutePath(), file.getAbsolutePath(), this.getOpenEJBClassLoader(), this.getContextRoot(), this.getModuleName());
                        AppModule appModule9 = new AppModule(webModule.getClassLoader(), file.getAbsolutePath(), new Application(), true);
                        VirgoDeploymentLoader.addWebModule((WebModule)webModule, (AppModule)appModule9);
                        HashMap<String, Object> otherDD = new HashMap<String, Object>();
                        List urls = webModule.getScannableUrls();
                        ResourceFinder finder = new ResourceFinder("", urls.toArray(new URL[urls.size()]));
                        otherDD.putAll(VirgoDeploymentLoader.getDescriptors(finder, false));
                        try {
                            List persistenceXmls = finder.findAll("META-INF/persistence.xml");
                            if (persistenceXmls.size() >= 1) {
                                URL old = (URL)otherDD.get("persistence.xml");
                                if (old != null && !persistenceXmls.contains(old)) {
                                    persistenceXmls.add(old);
                                }
                                otherDD.put("persistence.xml", persistenceXmls);
                            }
                        }
                        catch (IOException iOException) {}
                        this.addWebPersistenceDD("persistence.xml", otherDD, appModule9);
                        this.addWebPersistenceDD("persistence-fragment.xml", otherDD, appModule9);
                        VirgoDeploymentLoader.addPersistenceUnits((AppModule)appModule9, (URL[])new URL[]{baseUrl});
                        appModule9.setStandloneWebModule();
                        appModule9.setDelegateFirst(false);
                        appModule9.setModuleId(this.createModuleIDFromWebContextPath());
                        appModule2 = appModule9;
                        if (doNotUseClassLoader == null) break block23;
                        ClassLoaderUtil.destroyClassLoader((ClassLoader)doNotUseClassLoader);
                    }
                    return appModule2;
                }
                if (!PersistenceModule.class.equals((Object)moduleClass)) break block24;
                String jarLocation = URLs.toFilePath((URL)baseUrl);
                AppModule appModule10 = new AppModule(this.getWebAppClassLoader(), jarLocation);
                VirgoDeploymentLoader.addPersistenceUnits((AppModule)appModule10, (URL[])new URL[]{baseUrl});
                appModule10.setModuleId(this.createModuleIDFromWebContextPath());
                appModule = appModule10;
                if (doNotUseClassLoader == null) break block25;
                ClassLoaderUtil.destroyClassLoader((ClassLoader)doNotUseClassLoader);
            }
            return appModule;
        }
        throw new UnsupportedModuleTypeException("Unsupported module type: " + moduleClass.getSimpleName());
    }

    private ClassLoader getWebAppClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public WebModule createWebModule(String appId, String warPath, ClassLoader parentClassLoader, String contextRoot, String moduleName) throws OpenEJBException {
        Map descriptors;
        File warFile = new File(warPath);
        ArrayList<URL> webUrls = new ArrayList<URL>();
        try {
            descriptors = this.getWebDescriptors(warFile);
        }
        catch (IOException e) {
            throw new OpenEJBException("Unable to collect descriptors in web module: " + contextRoot, (Throwable)e);
        }
        URL webXmlUrl = (URL)descriptors.get("web.xml");
        WebApp webApp = webXmlUrl != null ? ReadDescriptors.readWebApp((URL)webXmlUrl) : new WebApp();
        webUrls.addAll(Arrays.asList(VirgoDeploymentLoader.getWebappUrls((File)warFile)));
        URL[] webUrlsAsArray = webUrls.toArray(new URL[0]);
        SystemInstance.get().fireEvent((Object)new BeforeDeploymentEvent(webUrlsAsArray, parentClassLoader));
        webApp.setVersion("3.0");
        WebModule webModule = new WebModule(webApp, contextRoot, this.getWebAppClassLoader(), warFile.getAbsolutePath(), moduleName);
        webModule.setUrls(webUrls);
        webModule.getAltDDs().putAll(descriptors);
        List<URL> filteredURLs = webUrls;
        File exclusionList = SystemInstance.get().getConf("exclusions.list");
        try {
            filteredURLs = VirgoDeploymentLoader.filterWebappUrls((URL[])webUrlsAsArray, (URL)exclusionList.toURL());
        }
        catch (MalformedURLException e) {
            logger.warning("Unable to apply exclusion list " + exclusionList + " to web app urls. Scannable URLs may contain redundant entries", (Throwable)e);
        }
        webModule.setScannableUrls(filteredURLs);
        this.addTagLibraries(webModule);
        this.addFacesConfigs(webModule);
        this.addBeansXmls(webModule);
        return webModule;
    }

    protected String getContextRoot() {
        return this.servletContext.getContextPath();
    }

    private String createModuleIDFromWebContextPath() {
        String webContextPath = this.servletContext.getContextPath();
        if (webContextPath.equals("")) {
            return VIRGO_ROOT_APPLICATION_RESERVED_MODULE_ID;
        }
        return webContextPath.substring(1);
    }

    private void addBeansXmls(WebModule webModule) {
        ArrayList<URL> xmls;
        List urls = webModule.getScannableUrls();
        URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), (ClassLoader)new EmptyResourcesClassLoader());
        try {
            xmls = Collections.list(loader.getResources("META-INF/beans.xml"));
            xmls.add((URL)webModule.getAltDDs().get("beans.xml"));
        }
        catch (IOException iOException) {
            return;
        }
        Beans complete = null;
        for (URL url : xmls) {
            if (url == null) continue;
            complete = this.mergeBeansXml(complete, url);
        }
        webModule.getAltDDs().put("beans.xml", complete);
    }

    private Beans mergeBeansXml(Beans current, URL url) {
        Beans returnValue = current;
        try {
            Beans beans;
            try {
                beans = ReadDescriptors.readBeans((InputStream)url.openStream());
            }
            catch (IOException iOException) {
                return returnValue;
            }
            if (current == null) {
                returnValue = beans;
            } else {
                current.getAlternativeClasses().addAll(beans.getAlternativeClasses());
                current.getAlternativeStereotypes().addAll(beans.getAlternativeStereotypes());
                current.getDecorators().addAll(beans.getDecorators());
                current.getInterceptors().addAll(beans.getInterceptors());
            }
            ReadDescriptors.checkDuplicatedByBeansXml((Beans)beans, (Beans)returnValue);
        }
        catch (OpenEJBException openEJBException) {
            logger.error("Unable to read beans.xml from :" + url.toExternalForm());
        }
        return returnValue;
    }

    private void addWebPersistenceDD(String name, Map<String, Object> otherDD, AppModule appModule) {
        if (otherDD.containsKey(name)) {
            ArrayList<URL> persistenceUrls = (ArrayList<URL>)appModule.getAltDDs().get(name);
            if (persistenceUrls == null) {
                persistenceUrls = new ArrayList<URL>();
                appModule.getAltDDs().put(name, persistenceUrls);
            }
            if (otherDD.containsKey(name)) {
                Object otherUrl = otherDD.get(name);
                if (otherUrl instanceof URL && !persistenceUrls.contains(otherUrl)) {
                    persistenceUrls.add((URL)otherUrl);
                } else if (otherUrl instanceof List) {
                    List otherList = (List)otherDD.get(name);
                    for (URL url : otherList) {
                        if (persistenceUrls.contains(url)) continue;
                        persistenceUrls.add(url);
                    }
                }
            }
        }
    }

    public static Map<String, URL> getDescriptors(URL moduleUrl) throws OpenEJBException {
        ResourceFinder finder = new ResourceFinder(new URL[]{moduleUrl});
        return VirgoDeploymentLoader.getDescriptors(finder);
    }

    private static Map<String, URL> getDescriptors(ResourceFinder finder) throws OpenEJBException {
        return VirgoDeploymentLoader.getDescriptors(finder, true);
    }

    private static Map<String, URL> getDescriptors(ResourceFinder finder, boolean log) throws OpenEJBException {
        try {
            return VirgoDeploymentLoader.altDDSources((Map)VirgoDeploymentLoader.mapDescriptors((ResourceFinder)finder), (boolean)log);
        }
        catch (IOException e) {
            throw new OpenEJBException("Unable to determine descriptors in jar.", (Throwable)e);
        }
    }

    private void addFacesConfigs(WebModule webModule) throws OpenEJBException {
        File facesConfigFile;
        File webInf;
        HashSet<URL> facesConfigLocations = new HashSet<URL>();
        File warFile = new File(webModule.getJarLocation());
        WebApp webApp = webModule.getWebApp();
        if (webApp != null) {
            String foundContextParam = (String)webApp.contextParamsAsMap().get("javax.faces.CONFIG_FILES");
            if (foundContextParam != null) {
                String commaDelimitedListOfFiles = foundContextParam.trim();
                String[] configFiles = commaDelimitedListOfFiles.split(",");
                String[] trimmedConfigFiles = new String[configFiles.length];
                int i = 0;
                while (i < configFiles.length) {
                    trimmedConfigFiles[i] = configFiles[i].trim();
                    ++i;
                }
                String[] stringArray = trimmedConfigFiles;
                int n = trimmedConfigFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    String location = stringArray[n2];
                    if (!location.startsWith("/")) {
                        logger.error("A faces configuration file should be context relative when specified in web.xml. Please fix the value of context parameter javax.faces.CONFIG_FILES for the file " + location);
                    }
                    try {
                        File file = new File(warFile, location).getCanonicalFile().getAbsoluteFile();
                        URL url = file.toURI().toURL();
                        facesConfigLocations.add(url);
                    }
                    catch (IOException e) {
                        logger.error("Faces configuration file location bad: " + location, (Throwable)e);
                    }
                    ++n2;
                }
            } else {
                logger.debug("faces config file is null");
            }
        }
        if ((webInf = new File(warFile, "WEB-INF")).isDirectory() && (facesConfigFile = new File(webInf, "faces-config.xml")).exists()) {
            try {
                facesConfigFile = facesConfigFile.getCanonicalFile().getAbsoluteFile();
                URL url = facesConfigFile.toURI().toURL();
                facesConfigLocations.add(url);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (URL location : facesConfigLocations) {
            FacesConfig facesConfig = ReadDescriptors.readFacesConfig((URL)location);
            webModule.getFacesConfigs().add(facesConfig);
            if (!"file".equals(location.getProtocol())) continue;
            webModule.getWatchedResources().add(URLs.toFilePath((URL)location));
        }
    }

    private void addTagLibraries(WebModule webModule) throws OpenEJBException {
        HashSet tldLocations = new HashSet();
        File warFile = new File(webModule.getJarLocation());
        WebApp webApp = webModule.getWebApp();
        if (webApp != null) {
            for (JspConfig jspConfig : webApp.getJspConfig()) {
                for (Taglib taglib : jspConfig.getTaglib()) {
                    String location = taglib.getTaglibLocation();
                    if (!location.startsWith("/")) {
                        location = "/WEB-INF/" + location;
                    }
                    try {
                        File file = new File(warFile, location).getCanonicalFile().getAbsoluteFile();
                        tldLocations.addAll(TldScanner.scanForTagLibs((File)file));
                    }
                    catch (IOException e) {
                        logger.warning("JSP tag library location bad: " + location, (Throwable)e);
                    }
                }
            }
        }
        Set urls = TldScanner.scanWarForTagLibs((File)warFile);
        tldLocations.addAll(urls);
        ClassLoader parentClassLoader = webModule.getClassLoader().getParent();
        urls = TldScanner.scan((ClassLoader)parentClassLoader);
        tldLocations.addAll(urls);
        for (URL location : tldLocations) {
            TldTaglib taglib = ReadDescriptors.readTldTaglib((URL)location);
            webModule.getTaglibs().add(taglib);
            if (!"file".equals(location.getProtocol())) continue;
            webModule.getWatchedResources().add(URLs.toFilePath((URL)location));
        }
    }
}

