/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetTimingsDescriptor;
import org.apache.derby.impl.sql.execute.rts.ResultSetStatistics;
import org.apache.derby.impl.sql.execute.xplain.XPLAINUtil;

abstract class RealBasicNoPutResultSetStatistics
implements ResultSetStatistics {
    public int numOpens;
    public int rowsSeen;
    public int rowsFiltered;
    public long constructorTime;
    public long openTime;
    public long nextTime;
    public long closeTime;
    public long inspectOverall;
    public long inspectNum;
    public String inspectDesc;
    public double optimizerEstimatedRowCount;
    public double optimizerEstimatedCost;

    public RealBasicNoPutResultSetStatistics(int n, int n2, int n3, long l, long l2, long l3, long l4, double d, double d2) {
        this.numOpens = n;
        this.rowsSeen = n2;
        this.rowsFiltered = n3;
        this.constructorTime = l;
        this.openTime = l2;
        this.nextTime = l3;
        this.closeTime = l4;
        this.optimizerEstimatedRowCount = d;
        this.optimizerEstimatedCost = d2;
    }

    protected final String dumpTimeStats(String string, String string2) {
        return string2 + MessageService.getTextMessage("42Z33.U") + " " + this.constructorTime + "\n" + string2 + MessageService.getTextMessage("42Z34.U") + " " + this.openTime + "\n" + string2 + MessageService.getTextMessage("42Z35.U") + " " + this.nextTime + "\n" + string2 + MessageService.getTextMessage("42Z36.U") + " " + this.closeTime;
    }

    protected final String dumpEstimatedCosts(String string) {
        return string + MessageService.getTextMessage("43X07.U", new Double(this.optimizerEstimatedRowCount)) + "\n" + string + MessageService.getTextMessage("43X08.U", new Double(this.optimizerEstimatedCost));
    }

    public Vector getChildren() {
        return new Vector();
    }

    public long getTotalTime() {
        return this.openTime + this.nextTime + this.closeTime;
    }

    public long getChildrenTime() {
        long l = 0L;
        Enumeration enumeration = this.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            l += ((RealBasicNoPutResultSetStatistics)enumeration.nextElement()).getTotalTime();
        }
        return l;
    }

    public long getNodeTime() {
        return this.getTotalTime() - this.getChildrenTime();
    }

    public abstract String getNodeName();

    public String getNodeOn() {
        return "";
    }

    public double getEstimatedRowCount() {
        return this.optimizerEstimatedRowCount;
    }

    public String getRSXplainDetails() {
        return null;
    }

    public Object getResultSetDescriptor(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        return new XPLAINResultSetDescriptor((UUID)object, this.getRSXplainType(), this.getRSXplainDetails(), new Integer(this.numOpens), null, null, null, (UUID)object2, new Double(this.optimizerEstimatedRowCount), new Double(this.optimizerEstimatedCost), null, null, null, new Integer(this.rowsSeen), null, new Integer(this.rowsFiltered), new Integer(this.rowsSeen - this.rowsFiltered), null, null, (UUID)object3, (UUID)object4, (UUID)object5, (UUID)object6);
    }

    public Object getResultSetTimingsDescriptor(Object object) {
        return new XPLAINResultSetTimingsDescriptor((UUID)object, new Long(this.constructorTime), new Long(this.openTime), new Long(this.nextTime), new Long(this.closeTime), new Long(this.getNodeTime()), XPLAINUtil.getAVGNextTime(this.nextTime, this.rowsSeen), null, null, null, null);
    }

    public Object getSortPropsDescriptor(Object object) {
        return null;
    }

    public Object getScanPropsDescriptor(Object object) {
        return null;
    }
}

