/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregion.internal;

import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.virgo.kernel.osgi.framework.OsgiFrameworkUtils;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleConfigurationConvertor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BundleContext context;
    private final ConfigurationAdmin configAdmin;
    private ServiceRegistration<ManagedService> configuratorRegistration;
    private static final String CONSOLE_PID = "osgi.console";
    private static final String TELNET_PID = "osgi.console.telnet";
    private static final String SSH_PID = "osgi.console.ssh";
    private static final String TELNET_PORT = "telnet.port";
    private static final String TELNET_HOST = "telnet.host";
    private static final String TELNET_ENABLED = "telnet.enabled";
    private static final String SSH_PORT = "ssh.port";
    private static final String SSH_HOST = "ssh.host";
    private static final String SSH_ENABLED = "ssh.enabled";
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String ENABLED = "enabled";
    private static final String TELNET_SERVICE = "telnet";
    private static final String SSH_SERVICE = "ssh";
    private static final Object monitor;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.userregion.internal.ConsoleConfigurationConvertor");
        monitor = new Object();
    }

    ConsoleConfigurationConvertor(BundleContext context) {
        this.context = context;
        this.configAdmin = (ConfigurationAdmin)OsgiFrameworkUtils.getService((BundleContext)context, ConfigurationAdmin.class).getService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Hashtable<String, String> consoleProperties = new Hashtable<String, String>();
        ((Dictionary)consoleProperties).put("service.pid", CONSOLE_PID);
        Object object = monitor;
        synchronized (object) {
            this.configuratorRegistration = this.context.registerService(ManagedService.class, (Object)new ConsoleConfigurator(), consoleProperties);
        }
    }

    private void updateConfiguration(String pid, String host, String port, String enabled) {
        boolean isPortAvailable = pid.contains(TELNET_SERVICE) ? this.checkPortAvailability(port, enabled, TELNET_SERVICE) : this.checkPortAvailability(port, enabled, SSH_SERVICE);
        if (!isPortAvailable) {
            return;
        }
        try {
            Configuration configuration = this.configAdmin.getConfiguration(pid, null);
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put(HOST, host);
            ((Dictionary)properties).put(PORT, port);
            ((Dictionary)properties).put(ENABLED, enabled);
            configuration.update(properties);
        }
        catch (IOException e) {
            String message = String.format("Unable to update configuration with pid '%s'", pid);
            this.logger.error(message, (Throwable)e);
        }
    }

    public void stop() {
        this.deleteConfiguration(TELNET_PID);
        this.deleteConfiguration(SSH_PID);
        this.deleteConfiguration(CONSOLE_PID);
    }

    private void deleteConfiguration(String pid) {
        try {
            Configuration configuration = this.configAdmin.getConfiguration(pid, null);
            configuration.delete();
        }
        catch (IOException e) {
            String message = String.format("Unable to delete configuration with pid: " + pid, new Object[0]);
            this.logger.error(message, (Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkPortAvailability(String portStr, String enabled, String service) {
        if ("false".equalsIgnoreCase(enabled)) {
            return true;
        }
        int port = Integer.parseInt(portStr);
        ServerSocket socket = null;
        socket = new ServerSocket(port);
        if (socket == null) return true;
        try {
            socket.close();
            return true;
        }
        catch (IOException iOException) {}
        return true;
        catch (BindException e) {
            String message = "Port " + port + " already in use; " + service + " access to console will not be available";
            this.logger.error(message, (Throwable)e);
            if (socket == null) return false;
            try {
                socket.close();
                return false;
            }
            catch (IOException iOException) {}
            return false;
        }
        catch (IOException iOException) {
            if (socket == null) return false;
            {
                catch (Throwable throwable) {
                    if (socket == null) throw throwable;
                    try {
                        socket.close();
                        throw throwable;
                    }
                    catch (IOException iOException2) {}
                    throw throwable;
                }
            }
            try {
                socket.close();
                return false;
            }
            catch (IOException iOException3) {}
            return false;
        }
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    class ConsoleConfigurator
    implements ManagedService {
        private Dictionary properties;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

        ConsoleConfigurator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updated(Dictionary props) throws ConfigurationException {
            if (props == null) {
                return;
            }
            this.properties = props;
            this.properties.put("service.pid", ConsoleConfigurationConvertor.CONSOLE_PID);
            Object object = monitor;
            synchronized (object) {
                ConsoleConfigurationConvertor.this.configuratorRegistration.setProperties(this.properties);
            }
            String telnetHost = (String)this.properties.get(ConsoleConfigurationConvertor.TELNET_HOST);
            String telnetPort = (String)this.properties.get(ConsoleConfigurationConvertor.TELNET_PORT);
            String telnetEnabled = (String)this.properties.get(ConsoleConfigurationConvertor.TELNET_ENABLED);
            ConsoleConfigurationConvertor.this.updateConfiguration(ConsoleConfigurationConvertor.TELNET_PID, telnetHost, telnetPort, telnetEnabled);
            String sshHost = (String)this.properties.get(ConsoleConfigurationConvertor.SSH_HOST);
            String sshPort = (String)this.properties.get(ConsoleConfigurationConvertor.SSH_PORT);
            String sshEnabled = (String)this.properties.get(ConsoleConfigurationConvertor.SSH_ENABLED);
            ConsoleConfigurationConvertor.this.updateConfiguration(ConsoleConfigurationConvertor.SSH_PID, sshHost, sshPort, sshEnabled);
        }

        public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
            return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        }

        static {
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.userregion.internal.ConsoleConfigurationConvertor$ConsoleConfigurator");
        }
    }
}

