/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.MethodVisitor;
import org.springframework.asm.Type;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.classreading.AnnotationAttributesReadingVisitor;
import org.springframework.core.type.classreading.ClassMetadataReadingVisitor;
import org.springframework.core.type.classreading.MethodMetadataReadingVisitor;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AnnotationMetadataReadingVisitor
extends ClassMetadataReadingVisitor
implements AnnotationMetadata {
    private final ClassLoader classLoader;
    private final Set<String> annotationSet = new LinkedHashSet<String>();
    private final Map<String, Set<String>> metaAnnotationMap = new LinkedHashMap<String, Set<String>>(4);
    private final Map<String, Map<String, Object>> attributeMap = new LinkedHashMap<String, Map<String, Object>>(4);
    private final MultiValueMap<String, MethodMetadata> methodMetadataMap = new LinkedMultiValueMap<String, MethodMetadata>();

    public AnnotationMetadataReadingVisitor(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return new MethodMetadataReadingVisitor(name, access, this.getClassName(), this.classLoader, this.methodMetadataMap);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        String className = Type.getType((String)desc).getClassName();
        this.annotationSet.add(className);
        return new AnnotationAttributesReadingVisitor(className, this.attributeMap, this.metaAnnotationMap, this.classLoader);
    }

    @Override
    public Set<String> getAnnotationTypes() {
        return this.annotationSet;
    }

    @Override
    public Set<String> getMetaAnnotationTypes(String annotationType) {
        return this.metaAnnotationMap.get(annotationType);
    }

    @Override
    public boolean hasAnnotation(String annotationType) {
        return this.annotationSet.contains(annotationType);
    }

    @Override
    public boolean hasMetaAnnotation(String metaAnnotationType) {
        Collection<Set<String>> allMetaTypes = this.metaAnnotationMap.values();
        for (Set<String> metaTypes : allMetaTypes) {
            if (!metaTypes.contains(metaAnnotationType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAnnotated(String annotationType) {
        return this.attributeMap.containsKey(annotationType);
    }

    @Override
    public Map<String, Object> getAnnotationAttributes(String annotationType) {
        return this.getAnnotationAttributes(annotationType, false);
    }

    @Override
    public Map<String, Object> getAnnotationAttributes(String annotationType, boolean classValuesAsString) {
        Map<String, Object> raw = this.attributeMap.get(annotationType);
        if (raw == null) {
            return null;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(raw.size());
        for (Map.Entry<String, Object> entry : raw.entrySet()) {
            try {
                Object[] value = entry.getValue();
                if (value instanceof Type) {
                    value = classValuesAsString ? ((Type)value).getClassName() : this.classLoader.loadClass(((Type)value).getClassName());
                } else if (value instanceof Type[]) {
                    Type[] array = (Type[])value;
                    Object[] convArray = classValuesAsString ? new String[array.length] : new Class[array.length];
                    int i = 0;
                    while (i < array.length) {
                        convArray[i] = classValuesAsString ? array[i].getClassName() : this.classLoader.loadClass(array[i].getClassName());
                        ++i;
                    }
                    value = convArray;
                }
                result.put(entry.getKey(), value);
            }
            catch (Exception exception) {}
        }
        return result;
    }

    @Override
    public boolean hasAnnotatedMethods(String annotationType) {
        return this.methodMetadataMap.containsKey(annotationType);
    }

    @Override
    public Set<MethodMetadata> getAnnotatedMethods(String annotationType) {
        List list = (List)this.methodMetadataMap.get(annotationType);
        if (CollectionUtils.isEmpty(list)) {
            return new LinkedHashSet<MethodMetadata>(0);
        }
        LinkedHashSet<MethodMetadata> annotatedMethods = new LinkedHashSet<MethodMetadata>(list.size());
        annotatedMethods.addAll(list);
        return annotatedMethods;
    }
}

