/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.bundlor.ui;

import java.util.Collections;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.IProgressConstants;
import org.osgi.framework.BundleContext;

public class BundlorUiPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.virgo.ide.bundlor.ui";
    public static final String JOB_FAMILY = "org.eclipse.virgo.ide.bundlor.ui.job.family";
    private static BundlorUiPlugin plugin;

    public static BundlorUiPlugin getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Image getImage(String path) {
        ImageRegistry imageRegistry = BundlorUiPlugin.getDefault().getImageRegistry();
        Image image = imageRegistry.get(path);
        if (image == null) {
            ImageDescriptor imageDescriptor = BundlorUiPlugin.getImageDescriptor(path);
            if (imageDescriptor == null) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            image = imageDescriptor.createImage(true);
            imageRegistry.put(path, image);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return BundlorUiPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)("icons/" + path));
    }

    public static void runBundlorOnProject(IJavaProject javaProject) {
        RunBundlorJob job = new RunBundlorJob(javaProject);
        job.schedule();
    }

    public static ICommand getBundlorBuilderCommand(IResource resource) {
        if (resource != null) {
            try {
                ICommand[] commands;
                ICommand[] iCommandArray = commands = resource.getProject().getDescription().getBuildSpec();
                int n = commands.length;
                int n2 = 0;
                while (n2 < n) {
                    ICommand command = iCommandArray[n2];
                    if (command.getBuilderName().equals("org.eclipse.virgo.ide.bundlor.core.builder")) {
                        return command;
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isBundlorBuilding(IResource resource) {
        if (resource != null) {
            ICommand command = BundlorUiPlugin.getBundlorBuilderCommand(resource);
            return command != null && command.isBuilding(6);
        }
        return false;
    }

    static class RunBundlorJob
    extends Job {
        private final IJavaProject javaProject;

        public RunBundlorJob(IJavaProject javaProject) {
            super("Generating MANIFEST.MF file for project '" + javaProject.getElementName() + "'");
            this.javaProject = javaProject;
            this.setPriority(40);
            this.setProperty(IProgressConstants.ICON_PROPERTY, BundlorUiPlugin.getImageDescriptor("full/obj16/osgi_obj.gif"));
            this.setProperty(IProgressConstants.KEEPONE_PROPERTY, true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.javaProject.getProject().build(6, "org.eclipse.virgo.ide.bundlor.core.builder", Collections.emptyMap(), monitor);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return family instanceof RunBundlorJob;
        }
    }
}

