/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.editors;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.elements.DefaultTableProvider;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.virgo.ide.bundlerepository.domain.OsgiVersion;
import org.eclipse.virgo.ide.manifest.core.editor.model.ImportLibraryHeader;
import org.eclipse.virgo.ide.manifest.core.editor.model.ImportLibraryObject;
import org.eclipse.virgo.ide.runtime.core.artefacts.Artefact;
import org.eclipse.virgo.ide.runtime.core.artefacts.ArtefactRepository;
import org.eclipse.virgo.ide.runtime.core.artefacts.IArtefact;
import org.eclipse.virgo.ide.runtime.core.artefacts.LibraryArtefact;
import org.eclipse.virgo.ide.runtime.core.provisioning.RepositoryUtils;
import org.eclipse.virgo.ide.ui.editors.AbstractImportSection;
import org.eclipse.virgo.ide.ui.editors.BundleDependencyPropertiesDialog;
import org.eclipse.virgo.ide.ui.editors.BundleManifestEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleImportLibrarySection
extends AbstractImportSection {
    private static final String DESCRIPTION = "Specify the list of libraries required for the operation of this bundle.";
    private static final int ADD_INDEX = 0;
    private static final int ADD_REMOTE_BUNDLE_INDEX = 1;
    private static final int REMOVE_INDEX = 2;
    private static final int PROPERTIES_INDEX = 3;

    public BundleImportLibrarySection(PDEFormPage page, Composite parent) {
        super(page, parent, 128, new String[]{PDEUIMessages.ImportPackageSection_add, "Download...", PDEUIMessages.ImportPackageSection_remove, PDEUIMessages.ImportPackageSection_properties});
        this.getSection().setText("Import Library");
        this.getSection().setDescription(DESCRIPTION);
        this.getTablePart().setEditable(false);
    }

    @Override
    protected IContentProvider getContentProvider() {
        return new ImportLibraryContentProvider();
    }

    @Override
    protected ITableLabelProvider getLabelProvider() {
        return new ImportLibraryLabelProvider();
    }

    private void setElements(AbstractImportSection.ImportListSelectionDialog dialog, boolean addRemote) {
        IProject project = ((BundleManifestEditor)this.getPage().getEditor()).getCommonProject();
        Object[] libraries = null;
        if (addRemote) {
            ArtefactRepository bundleRepository = RepositoryUtils.searchForArtifacts((String)"", (boolean)false, (boolean)true);
            libraries = bundleRepository.getLibrarySet().toArray();
        } else {
            Set libraryList = RepositoryUtils.getImportLibraryProposals((IProject)project, (String)"");
            this.removeExistingLibraries(libraryList);
            libraries = libraryList.toArray(new IArtefact[0]);
        }
        dialog.setElements(libraries);
    }

    private void removeExistingLibraries(Collection<Artefact> bundles) {
        ImportLibraryHeader header = (ImportLibraryHeader)this.getBundle().getManifestHeader("Import-Library");
        HashSet<Artefact> filteredElements = new HashSet<Artefact>();
        if (header != null) {
            ImportLibraryObject[] filter = header.getImportedLibraries();
            for (Artefact proposal : bundles) {
                ImportLibraryObject[] importLibraryObjectArray = filter;
                int n = filter.length;
                int n2 = 0;
                while (n2 < n) {
                    ImportLibraryObject imported = importLibraryObjectArray[n2];
                    if (proposal.getSymbolicName().equalsIgnoreCase(imported.getId())) {
                        filteredElements.add(proposal);
                    }
                    ++n2;
                }
            }
            bundles.removeAll(filteredElements);
        }
    }

    @Override
    protected void handleAdd() {
        this.internalHandleAdd(false);
    }

    private void internalHandleAdd(final boolean addRemote) {
        final AbstractImportSection.ImportListSelectionDialog dialog = new AbstractImportSection.ImportListSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), (ILabelProvider)new BundleImportDialogLabelProvider());
        Runnable runnable = new Runnable(){

            public void run() {
                BundleImportLibrarySection.this.setElements(dialog, addRemote);
                dialog.setMultipleSelection(true);
                dialog.setTitle("Library Selection");
                dialog.setMessage("Select a Library:");
                dialog.create();
                SWTUtil.setDialogSize((Dialog)dialog, (int)400, (int)500);
            }
        };
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)runnable);
        if (dialog.open() == 0) {
            Object[] selected = dialog.getResult();
            if (addRemote) {
                this.addRemoteLibraries(selected);
            } else {
                this.addLocalLibraries(selected);
            }
        }
    }

    private void addLocalLibraries(Object[] selected) {
        ImportLibraryHeader importLibraryHeader = (ImportLibraryHeader)this.getBundle().getManifestHeader("Import-Library");
        Object[] objectArray = selected;
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            Object currSelectedElement = objectArray[n2];
            LibraryArtefact currBundle = (LibraryArtefact)currSelectedElement;
            if (importLibraryHeader == null) {
                this.getBundle().setHeader("Import-Library", "");
                importLibraryHeader = (ImportLibraryHeader)this.getBundle().getManifestHeader("Import-Library");
            }
            String versionString = null;
            OsgiVersion osgiVers = currBundle.getVersion();
            if (osgiVers.getMajor() != 0 || osgiVers.getMinor() != 0 || osgiVers.getService() != 0 || osgiVers.getQualifier() != null && !osgiVers.getQualifier().trim().equals("")) {
                versionString = "[" + currBundle.getVersion().toString() + "," + currBundle.getVersion().toString() + "]";
            }
            importLibraryHeader.addLibrary(currBundle.getSymbolicName(), versionString);
            ++n2;
        }
    }

    private void addRemoteLibraries(Object[] selected) {
        ImportLibraryHeader importLibraryHeader = (ImportLibraryHeader)this.getBundle().getManifestHeader("Import-Library");
        HashSet<Artefact> remoteArtifactDefinitions = new HashSet<Artefact>(selected.length);
        Object[] objectArray = selected;
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            Object currSelectedElement = objectArray[n2];
            remoteArtifactDefinitions.add((Artefact)currSelectedElement);
            ++n2;
        }
        IProject project = ((BundleManifestEditor)this.getPage().getEditor()).getCommonProject();
        RepositoryUtils.downloadArifacts(remoteArtifactDefinitions, (IProject)project, (Shell)Display.getDefault().getActiveShell(), (boolean)false);
        Object[] objectArray2 = selected;
        int n3 = selected.length;
        n = 0;
        while (n < n3) {
            Object currSelectedElement = objectArray2[n];
            LibraryArtefact currLibrary = (LibraryArtefact)currSelectedElement;
            if (importLibraryHeader == null) {
                this.getBundle().setHeader("Import-Library", "");
                importLibraryHeader = (ImportLibraryHeader)this.getBundle().getManifestHeader("Import-Library");
            }
            String versionString = null;
            OsgiVersion osgiVers = currLibrary.getVersion();
            if (osgiVers.getMajor() != 0 || osgiVers.getMinor() != 0 || osgiVers.getService() != 0 || osgiVers.getQualifier() != null && !osgiVers.getQualifier().trim().equals("")) {
                versionString = "[" + currLibrary.getVersion().toString() + "," + currLibrary.getVersion().toString() + "]";
            }
            if (importLibraryHeader.hasElement(currLibrary.getSymbolicName())) {
                importLibraryHeader.removeLibrary(currLibrary.getSymbolicName());
            }
            importLibraryHeader.addLibrary(currLibrary.getSymbolicName(), versionString);
            ++n;
        }
    }

    @Override
    protected void handleRemove() {
        Object[] removed;
        Object[] objectArray = removed = ((IStructuredSelection)this.fViewer.getSelection()).toArray();
        int n = removed.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            ImportLibraryHeader header = (ImportLibraryHeader)this.getBundle().getManifestHeader("Import-Library");
            header.removeLibrary((ImportLibraryObject)element);
            ++n2;
        }
    }

    @Override
    protected int getAddIndex() {
        return 0;
    }

    @Override
    protected int getRemoveIndex() {
        return 2;
    }

    @Override
    protected int getPropertiesIndex() {
        return 3;
    }

    @Override
    protected String getHeaderConstant() {
        return "Import-Library";
    }

    @Override
    protected boolean shouldEnableProperties(Object[] selected) {
        if (selected.length == 0) {
            return false;
        }
        if (selected.length == 1) {
            return true;
        }
        String version = ((ImportLibraryObject)selected[0]).getVersion();
        boolean optional = ((ImportLibraryObject)selected[0]).isOptional();
        int i = 1;
        while (i < selected.length) {
            ImportLibraryObject object = (ImportLibraryObject)selected[i];
            if (version == null ? object.getVersion() != null || optional != object.isOptional() : !version.equals(object.getVersion()) || optional != object.isOptional()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    protected void handleOpenProperties() {
        Object[] selected = ((IStructuredSelection)this.fViewer.getSelection()).toArray();
        ImportLibraryObject first = (ImportLibraryObject)selected[0];
        BundleDependencyPropertiesDialog dialog = new BundleDependencyPropertiesDialog(this.isEditable(), false, false, first.isOptional(), first.getVersion(), true, true);
        dialog.create();
        SWTUtil.setDialogSize((Dialog)dialog, (int)400, (int)-1);
        if (selected.length == 1) {
            dialog.setTitle(((ImportLibraryObject)selected[0]).getValue());
        } else {
            dialog.setTitle("Properties");
        }
        if (dialog.open() == 0 && this.isEditable()) {
            String newVersion = dialog.getVersion();
            boolean newOptional = dialog.isOptional();
            Object[] objectArray = selected;
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                ImportLibraryObject object = (ImportLibraryObject)element;
                if (!newVersion.equals(object.getVersion())) {
                    object.setVersion(newVersion);
                }
                if (!newOptional == object.isOptional()) {
                    object.setOptional(newOptional);
                }
                ++n2;
            }
        }
    }

    @Override
    protected void buttonSelected(int index) {
        if (index == 1) {
            this.internalHandleAdd(true);
        } else {
            super.buttonSelected(index);
        }
    }

    class BundleImportDialogLabelProvider
    extends LabelProvider {
        BundleImportDialogLabelProvider() {
        }

        public Image getImage(Object element) {
            return PDEPluginImages.DESC_JAR_LIB_OBJ.createImage();
        }

        public String getText(Object element) {
            LibraryArtefact libraryArtifact = (LibraryArtefact)element;
            String label = libraryArtifact.getSymbolicName();
            if (libraryArtifact.getVersion() != null) {
                label = String.valueOf(label) + " " + libraryArtifact.getVersion();
            }
            return label;
        }
    }

    class ImportLibraryContentProvider
    extends DefaultTableProvider {
        ImportLibraryContentProvider() {
        }

        public Object[] getElements(Object parent) {
            ImportLibraryHeader header = (ImportLibraryHeader)BundleImportLibrarySection.this.getBundle().getManifestHeader("Import-Library");
            if (header == null) {
                return new Object[0];
            }
            return header.getImportedLibraries();
        }
    }

    class ImportLibraryLabelProvider
    extends AbstractImportSection.AbstractSectionViewerLabelProvider {
        ImportLibraryLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return PDEPluginImages.DESC_JAR_LIB_OBJ.createImage();
        }

        public String getColumnText(Object element, int columnIndex) {
            ImportLibraryObject importLibraryObject = (ImportLibraryObject)element;
            String label = importLibraryObject.getValue();
            if (importLibraryObject.getVersion() != null) {
                label = String.valueOf(label) + " " + importLibraryObject.getVersion();
            }
            return label;
        }
    }
}

