/*******************************************************************************
 * Copyright (c) 2010-2018, Zoltan Ujhelyi, Istvan Rath and Daniel Varro
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 * This file was generated from GeneratorModel.xtext
 *******************************************************************************/
package org.eclipse.viatra.query.tooling.generator.model.serializer;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.viatra.query.tooling.generator.model.generatorModel.Configuration;
import org.eclipse.viatra.query.tooling.generator.model.generatorModel.GeneratorModelPackage;
import org.eclipse.viatra.query.tooling.generator.model.generatorModel.GeneratorModelReference;
import org.eclipse.viatra.query.tooling.generator.model.generatorModel.Property;
import org.eclipse.viatra.query.tooling.generator.model.generatorModel.ViatraQueryGeneratorModel;
import org.eclipse.viatra.query.tooling.generator.model.services.GeneratorModelGrammarAccess;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public class GeneratorModelSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private GeneratorModelGrammarAccess grammarAccess;
	
	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == GeneratorModelPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case GeneratorModelPackage.CONFIGURATION:
				sequence_Configuration(context, (Configuration) semanticObject); 
				return; 
			case GeneratorModelPackage.GENERATOR_MODEL_REFERENCE:
				sequence_GeneratorModelReference(context, (GeneratorModelReference) semanticObject); 
				return; 
			case GeneratorModelPackage.PROPERTY:
				sequence_Property(context, (Property) semanticObject); 
				return; 
			case GeneratorModelPackage.VIATRA_QUERY_GENERATOR_MODEL:
				sequence_ViatraQueryGeneratorModel(context, (ViatraQueryGeneratorModel) semanticObject); 
				return; 
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Contexts:
	 *     Configuration returns Configuration
	 *
	 * Constraint:
	 *     (name=ID property+=Property*)
	 */
	protected void sequence_Configuration(ISerializationContext context, Configuration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     GeneratorModelReference returns GeneratorModelReference
	 *
	 * Constraint:
	 *     genmodel=[GenModel|STRING]
	 */
	protected void sequence_GeneratorModelReference(ISerializationContext context, GeneratorModelReference semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, GeneratorModelPackage.Literals.GENERATOR_MODEL_REFERENCE__GENMODEL) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, GeneratorModelPackage.Literals.GENERATOR_MODEL_REFERENCE__GENMODEL));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getGeneratorModelReferenceAccess().getGenmodelGenModelSTRINGTerminalRuleCall_1_0_1(), semanticObject.eGet(GeneratorModelPackage.Literals.GENERATOR_MODEL_REFERENCE__GENMODEL, false));
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Property returns Property
	 *
	 * Constraint:
	 *     (key=ID value=STRING)
	 */
	protected void sequence_Property(ISerializationContext context, Property semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, GeneratorModelPackage.Literals.PROPERTY__KEY) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, GeneratorModelPackage.Literals.PROPERTY__KEY));
			if (transientValues.isValueTransient(semanticObject, GeneratorModelPackage.Literals.PROPERTY__VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, GeneratorModelPackage.Literals.PROPERTY__VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getPropertyAccess().getKeyIDTerminalRuleCall_0_0(), semanticObject.getKey());
		feeder.accept(grammarAccess.getPropertyAccess().getValueSTRINGTerminalRuleCall_2_0(), semanticObject.getValue());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     ViatraQueryGeneratorModel returns ViatraQueryGeneratorModel
	 *
	 * Constraint:
	 *     ((genmodels+=GeneratorModelReference+ configuration+=Configuration+) | configuration+=Configuration+)?
	 */
	protected void sequence_ViatraQueryGeneratorModel(ISerializationContext context, ViatraQueryGeneratorModel semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
}
