/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.api.strategy.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.eclipse.viatra.dse.api.strategy.interfaces.IStrategy;
import org.eclipse.viatra.dse.base.GlobalContext;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.objectives.Fitness;
import org.eclipse.viatra.dse.solutionstore.SolutionStore;

public class BreadthFirstStrategy
implements IStrategy {
    private int maxDepth = 0;
    private BfsSharedObject shared;
    private boolean isInterrupted = false;
    private ThreadContext context;
    private Logger logger = Logger.getLogger(IStrategy.class);
    private SolutionStore solutionStore;
    private boolean isFirstThread = false;

    public BreadthFirstStrategy() {
        this.maxDepth = Integer.MAX_VALUE;
    }

    public BreadthFirstStrategy(int maxDepth) {
        this.maxDepth = maxDepth < 0 ? Integer.MAX_VALUE : maxDepth;
    }

    @Override
    public void initStrategy(ThreadContext context) {
        this.context = context;
        this.solutionStore = context.getGlobalContext().getSolutionStore();
        GlobalContext globalContext = context.getGlobalContext();
        if (globalContext.getSharedObject() == null) {
            this.isFirstThread = true;
            this.shared = new BfsSharedObject(globalContext.getThreadPool().getMaximumPoolSize());
            globalContext.setSharedObject(this.shared);
            this.logger.info((Object)"Breadth-first exploration strategy is inited.");
        } else {
            this.shared = (BfsSharedObject)globalContext.getSharedObject();
        }
    }

    @Override
    public void explore() {
        if (this.isFirstThread) {
            boolean globalConstraintsAreSatisfied = this.context.checkGlobalConstraints();
            if (!globalConstraintsAreSatisfied) {
                this.logger.info((Object)"Global contraint is not satisifed in the first state. Terminate.");
                return;
            }
            Fitness fitness = this.context.calculateFitness();
            if (fitness.isSatisifiesHardObjectives()) {
                this.context.newSolution();
                this.logger.info((Object)"First state is a solution. Terminate.");
                return;
            }
            Object[] currentTrajectory = this.context.getTrajectory().toArray(new Object[0]);
            this.shared.push(currentTrajectory);
            this.startThreads();
        } else {
            try {
                this.shared.barrier.await();
            }
            catch (InterruptedException | BrokenBarrierException globalConstraintsAreSatisfied) {}
        }
        block4: while (!this.isInterrupted && !this.shared.isDesignSpaceTraversed()) {
            Object[] next = this.shared.poll();
            while (next == null) {
                try {
                    this.logger.debug((Object)"Reached barrier.");
                    this.shared.barrier.await();
                }
                catch (InterruptedException | BrokenBarrierException fitness) {
                    // empty catch block
                }
                if (this.isInterrupted || this.shared.isDesignSpaceTraversed()) break block4;
                next = this.shared.poll();
            }
            this.context.backtrackUntilRoot();
            this.context.executeTrajectory(next);
            Collection<Object> activationIds = this.context.getCurrentActivationIds();
            int i = activationIds.size() - 1;
            while (!this.isInterrupted && i >= 0) {
                Iterator<Object> iterator = activationIds.iterator();
                int index = i--;
                while (iterator.hasNext() && index > 0) {
                    --index;
                    iterator.next();
                }
                Object activationIdToTry = iterator.next();
                this.context.executeAcitvationId(activationIdToTry);
                if (this.context.isCurrentStateAlreadyTraversed()) {
                    this.logger.info((Object)"The new state is already visited.");
                } else if (!this.context.checkGlobalConstraints()) {
                    this.logger.debug((Object)"Global contraint is not satisifed.");
                } else if (this.context.calculateFitness().isSatisifiesHardObjectives()) {
                    this.solutionStore.newSolution(this.context);
                    this.logger.debug((Object)"Found a solution.");
                } else if (this.context.getDepth() >= this.maxDepth) {
                    this.logger.debug((Object)"Reached max depth.");
                } else {
                    Object[] currentTrajectory = this.context.getTrajectory().toArray(new Object[0]);
                    this.shared.push(currentTrajectory);
                }
                this.context.backtrack();
            }
        }
    }

    private void startThreads() {
        this.context.startAllThreads(() -> new BreadthFirstStrategy(this.maxDepth));
    }

    @Override
    public void interruptStrategy() {
        this.isInterrupted = true;
        this.shared.barrier.reset();
    }

    private static final class BfsSharedObject {
        private final ConcurrentLinkedQueue<Object[]> trajectoryQueue1 = new ConcurrentLinkedQueue();
        private final ConcurrentLinkedQueue<Object[]> trajectoryQueue2 = new ConcurrentLinkedQueue();
        private final AtomicBoolean pushToQueue1 = new AtomicBoolean(false);
        private final AtomicBoolean designSpaceTraversed = new AtomicBoolean(false);
        public final CyclicBarrier barrier;

        public BfsSharedObject(int numberOfThreads) {
            this.barrier = new CyclicBarrier(numberOfThreads, () -> {
                boolean oldValue = this.pushToQueue1.get();
                this.pushToQueue1.set(!oldValue);
                if (this.trajectoryQueue1.isEmpty() && this.trajectoryQueue2.isEmpty()) {
                    this.designSpaceTraversed.set(true);
                }
            });
        }

        public Object[] poll() {
            if (this.pushToQueue1.get()) {
                return this.trajectoryQueue2.poll();
            }
            return this.trajectoryQueue1.poll();
        }

        public void push(Object[] trajectory) {
            if (this.pushToQueue1.get()) {
                this.trajectoryQueue1.add(trajectory);
            } else {
                this.trajectoryQueue2.add(trajectory);
            }
        }

        public boolean isDesignSpaceTraversed() {
            return this.designSpaceTraversed.get();
        }
    }
}

