/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.objectives;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.viatra.dse.objectives.IObjective;

public class LeveledObjectivesHelper {
    private List<IObjective> objectives = new ArrayList<IObjective>();
    private IObjective[][] leveledObjectives;

    public LeveledObjectivesHelper(List<IObjective> objectives) {
        this.objectives = objectives;
    }

    public IObjective[][] initLeveledObjectives() {
        if (this.objectives.isEmpty()) {
            this.leveledObjectives = new IObjective[0][0];
            return this.leveledObjectives;
        }
        int level = this.objectives.get(0).getLevel();
        boolean oneLevelOnly = true;
        for (IObjective objective : this.objectives) {
            if (objective.getLevel() == level) continue;
            oneLevelOnly = false;
            break;
        }
        if (oneLevelOnly) {
            this.leveledObjectives = new IObjective[1][this.objectives.size()];
            int i = 0;
            while (i < this.objectives.size()) {
                this.leveledObjectives[0][i] = this.objectives.get(i);
                ++i;
            }
            return this.leveledObjectives;
        }
        IObjective[] objectivesArray = this.getSortedByLevelObjectives(this.objectives);
        int numberOfLevels = this.getNumberOfObjectiveLevels(objectivesArray);
        this.leveledObjectives = new IObjective[numberOfLevels][];
        this.fillLeveledObjectives(objectivesArray);
        return this.leveledObjectives;
    }

    private void fillLeveledObjectives(IObjective[] objectivesArray) {
        int actLevel = objectivesArray[0].getLevel();
        int levelIndex = 0;
        int lastIndex = 0;
        int corrigationForLastLevel = 0;
        boolean oneObjectiveAtLastLevel = false;
        int i = 0;
        while (i < objectivesArray.length) {
            if (i == objectivesArray.length - 1) {
                corrigationForLastLevel = 1;
                if (objectivesArray[i - 1].getLevel() != objectivesArray[i].getLevel()) {
                    oneObjectiveAtLastLevel = true;
                    corrigationForLastLevel = 0;
                }
            }
            if (objectivesArray[i].getLevel() != actLevel || corrigationForLastLevel == 1 || oneObjectiveAtLastLevel) {
                this.leveledObjectives[levelIndex] = new IObjective[i - lastIndex + corrigationForLastLevel];
                int j = lastIndex;
                while (j < i + corrigationForLastLevel) {
                    this.leveledObjectives[levelIndex][j - lastIndex] = objectivesArray[j];
                    ++j;
                }
                if (oneObjectiveAtLastLevel) {
                    this.leveledObjectives[levelIndex + 1] = new IObjective[1];
                    this.leveledObjectives[levelIndex + 1][0] = objectivesArray[i];
                }
                actLevel = objectivesArray[i].getLevel();
                ++levelIndex;
                lastIndex = i;
            }
            ++i;
        }
    }

    private int getNumberOfObjectiveLevels(IObjective[] objectivesArray) {
        int actLevel = objectivesArray[0].getLevel();
        int numberOfLevels = 1;
        int i = 1;
        while (i < objectivesArray.length) {
            if (objectivesArray[i].getLevel() != actLevel) {
                ++numberOfLevels;
                actLevel = objectivesArray[i].getLevel();
            }
            ++i;
        }
        return numberOfLevels;
    }

    private IObjective[] getSortedByLevelObjectives(List<IObjective> objectives) {
        IObjective[] objectivesArray = objectives.toArray(new IObjective[objectives.size()]);
        Arrays.sort(objectivesArray, Comparator.comparingInt(IObjective::getLevel));
        return objectivesArray;
    }

    public IObjective[][] getLeveledObjectives() {
        return this.leveledObjectives;
    }
}

