/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.backend;

import org.eclipse.viatra.query.runtime.matchers.backend.ICallDelegationStrategy;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackend;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackendHintProvider;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryResultProvider;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryResultProviderAccess;
import org.eclipse.viatra.query.runtime.matchers.psystem.IQueryReference;

public class ResultProviderRequestor {
    IQueryBackend callerBackend;
    IQueryResultProviderAccess resultProviderAccess;
    IQueryBackendHintProvider hintProvider;
    ICallDelegationStrategy delegationStrategy;
    QueryEvaluationHint callerHint;
    QueryEvaluationHint universalOverride;

    public ResultProviderRequestor(IQueryBackend callerBackend, IQueryResultProviderAccess resultProviderAccess, IQueryBackendHintProvider hintProvider, ICallDelegationStrategy delegationStrategy, QueryEvaluationHint callerHint, QueryEvaluationHint universalOverride) {
        this.callerBackend = callerBackend;
        this.resultProviderAccess = resultProviderAccess;
        this.hintProvider = hintProvider;
        this.delegationStrategy = delegationStrategy;
        this.callerHint = callerHint;
        this.universalOverride = universalOverride;
    }

    public IQueryResultProvider requestResultProvider(IQueryReference call, QueryEvaluationHint spotOverride) {
        QueryEvaluationHint hints = this.delegationStrategy.transformHints(call, this.callerHint, this.callerBackend, this.hintProvider);
        if (this.universalOverride != null) {
            hints = hints.overrideBy(this.universalOverride);
        }
        if (spotOverride != null) {
            hints = hints.overrideBy(spotOverride);
        }
        return this.resultProviderAccess.getResultProvider(call.getReferredQuery(), hints);
    }
}

