/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.aggregation.timely;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.eclipse.viatra.query.runtime.matchers.psystem.aggregations.IMultisetAggregationOperator;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Timeline;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Timelines;
import org.eclipse.viatra.query.runtime.rete.aggregation.AbstractColumnAggregatorNode;
import org.eclipse.viatra.query.runtime.rete.aggregation.GroupedMap;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.Mailbox;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.timely.TimelyMailbox;

public abstract class FirstOnlyTimelyColumnAggregatorNode<Domain, Accumulator, AggregateResult>
extends AbstractColumnAggregatorNode<Domain, Accumulator, AggregateResult> {
    protected final Map<Tuple, TreeMap<Timestamp, CumulativeAggregate<Accumulator, AggregateResult>>> memory = CollectionsFactory.createMap();

    public FirstOnlyTimelyColumnAggregatorNode(ReteContainer reteContainer, IMultisetAggregationOperator<Domain, Accumulator, AggregateResult> operator, TupleMask groupMask, TupleMask columnMask) {
        super(reteContainer, operator, groupMask, columnMask);
        this.mailbox = this.instantiateMailbox();
    }

    public Collection<Tuple> getGroups() {
        return this.memory.keySet();
    }

    public AggregateResult getLastResult(Tuple group) {
        TreeMap<Timestamp, CumulativeAggregate<Accumulator, AggregateResult>> groupMap = this.memory.get(group);
        if (groupMap == null) {
            return null;
        }
        return groupMap.lastEntry().getValue().result;
    }

    public Timestamp getLastTimestamp(Tuple group) {
        TreeMap<Timestamp, CumulativeAggregate<Accumulator, AggregateResult>> groupMap = this.memory.get(group);
        if (groupMap == null) {
            return null;
        }
        return groupMap.lastEntry().getKey();
    }

    @Override
    protected Mailbox instantiateMailbox() {
        return new TimelyMailbox(this, this.reteContainer);
    }

    public void clear() {
        this.mailbox.clear();
        this.memory.clear();
        this.children.clear();
        this.childMailboxes.clear();
    }

    protected void propagateWithChecks(Tuple group, Timestamp timestamp, AggregateResult previousOldResult, AggregateResult previousNewResult, AggregateResult currentOldResult, AggregateResult currentNewResult) {
        boolean resultsDiffer;
        boolean jumpDown = Objects.equals(previousNewResult, currentOldResult);
        boolean jumpUp = Objects.equals(previousOldResult, currentNewResult);
        boolean bl = resultsDiffer = !Objects.equals(currentOldResult, currentNewResult);
        if ((resultsDiffer || jumpDown) && !Objects.equals(previousOldResult, currentOldResult)) {
            this.propagate(Direction.DELETE, group, currentOldResult, timestamp);
        }
        if ((resultsDiffer || jumpUp) && !Objects.equals(previousNewResult, currentNewResult)) {
            this.propagate(Direction.INSERT, group, currentNewResult, timestamp);
        }
    }

    protected abstract Accumulator getAccumulator(Tuple var1, Timestamp var2);

    protected AggregateResult getResultRaw(Tuple group, Timestamp timestamp, boolean lower) {
        TreeMap<Timestamp, CumulativeAggregate<Accumulator, AggregateResult>> entryMap = this.memory.get(group);
        if (entryMap == null) {
            return null;
        }
        CumulativeAggregate<Accumulator, AggregateResult> entry = null;
        if (lower) {
            Map.Entry<Timestamp, CumulativeAggregate<Accumulator, AggregateResult>> lowerEntry = entryMap.lowerEntry(timestamp);
            if (lowerEntry != null) {
                entry = lowerEntry.getValue();
            }
        } else {
            entry = entryMap.get(timestamp);
        }
        if (entry == null) {
            return null;
        }
        return entry.result;
    }

    protected AggregateResult getResult(Tuple group, Timestamp timestamp, boolean lower) {
        AggregateResult result = this.getResultRaw(group, timestamp, lower);
        if (result == null) {
            return (AggregateResult)this.NEUTRAL;
        }
        return result;
    }

    protected AggregateResult getResult(Tuple group, Timestamp timestamp) {
        return this.getResult(group, timestamp, false);
    }

    protected void storeIfNotNeutral(Tuple group, Accumulator accumulator, AggregateResult value, Timestamp timestamp) {
        TreeMap entryMap = this.memory.get(group);
        if (this.operator.isNeutral(accumulator)) {
            if (entryMap != null) {
                entryMap.remove(timestamp);
                if (entryMap.isEmpty()) {
                    this.memory.remove(group);
                }
            }
        } else {
            if (entryMap == null) {
                entryMap = CollectionsFactory.createTreeMap();
                this.memory.put(group, entryMap);
            }
            entryMap.put(timestamp, new CumulativeAggregate<Accumulator, AggregateResult>(accumulator, value));
        }
    }

    @Override
    public Tuple getAggregateTuple(Tuple group) {
        return this.tupleFromAggregateResult(group, this.getResult(group, Timestamp.ZERO));
    }

    @Override
    public AggregateResult getAggregateResult(Tuple group) {
        return this.getResult(group, Timestamp.ZERO);
    }

    @Override
    public Map<AggregateResult, Timeline<Timestamp>> getAggregateResultTimeline(Tuple group) {
        TreeMap<Timestamp, CumulativeAggregate<Accumulator, AggregateResult>> entryMap = this.memory.get(group);
        if (entryMap == null) {
            return Collections.emptyMap();
        }
        Map result = CollectionsFactory.createMap();
        for (Map.Entry entry : entryMap.descendingMap().entrySet()) {
            result.put(((CumulativeAggregate)entry.getValue()).result, Timelines.createFrom((Comparable)((Timestamp)entry.getKey())));
        }
        return result;
    }

    @Override
    public Map<Tuple, Timeline<Timestamp>> getAggregateTupleTimeline(Tuple group) {
        Map<AggregateResult, Timeline<Timestamp>> resultTimelines = this.getAggregateResultTimeline(group);
        return new GroupedMap<AggregateResult, Timeline<Timestamp>>(group, resultTimelines, this.runtimeContext);
    }

    protected static class CumulativeAggregate<Accumulator, AggregateResult> {
        protected Accumulator accumulator;
        protected AggregateResult result;

        private CumulativeAggregate(Accumulator accumulator, AggregateResult result) {
            this.accumulator = accumulator;
            this.result = result;
        }
    }
}

