/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.util;

import org.eclipse.viatra.query.runtime.matchers.util.EclipseCollectionsBagMemory;
import org.eclipse.viatra.query.runtime.matchers.util.IMultiset;

public class EclipseCollectionsMultiset<T>
extends EclipseCollectionsBagMemory<T>
implements IMultiset<T> {
    @Override
    public boolean addOne(T value) {
        int oldCount = super.getIfAbsent(value, 0);
        super.put(value, oldCount + 1);
        return oldCount == 0;
    }

    @Override
    public boolean addPositive(T value, int count2) {
        if (count2 < 0) {
            throw new IllegalArgumentException("The count value must be positive!");
        }
        int oldCount = super.getIfAbsent(value, 0);
        super.put(value, oldCount + count2);
        return oldCount == 0;
    }

    @Override
    public boolean addSigned(T value, int count2) {
        boolean becomesZero;
        int oldCount = super.getIfAbsent(value, 0);
        int newCount = oldCount + count2;
        boolean bl = becomesZero = newCount == 0;
        if (newCount < 0) {
            throw new IllegalStateException(String.format("Cannot remove %d occurrences of value '%s' as only %d would remain in %s", count2, value, newCount, this));
        }
        if (becomesZero) {
            super.removeKey(value);
        } else {
            super.put(value, newCount);
        }
        return becomesZero || oldCount == 0;
    }

    @Override
    public boolean removeOne(T value) {
        return this.removeOneInternal(value, true);
    }

    @Override
    public boolean removeOneOrNop(T value) {
        return this.removeOneInternal(value, false);
    }

    protected boolean removeOneInternal(T value, boolean throwIfImpossible) {
        boolean empty;
        int oldCount = super.getIfAbsent(value, 0);
        if (oldCount == 0) {
            if (throwIfImpossible) {
                throw new IllegalStateException(String.format("Cannot remove value '%s' that is not contained in %s", value, this));
            }
            return false;
        }
        int rest = oldCount - 1;
        boolean bl = empty = rest == 0;
        if (!empty) {
            super.put(value, rest);
        } else {
            super.remove(value);
        }
        return empty;
    }
}

