/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.memories.timely;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.memories.timely.AbstractTimelyMaskedMemory;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.TimelyMemory;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Diff;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Timeline;

public final class TimelyUnaryMaskedTupleMemory<Timestamp extends Comparable<Timestamp>>
extends AbstractTimelyMaskedMemory<Timestamp, Object> {
    protected final int keyPosition;

    public TimelyUnaryMaskedTupleMemory(TupleMask mask, Object owner, boolean isLazy) {
        super(mask, owner, isLazy);
        if (1 != mask.getSize()) {
            throw new IllegalArgumentException(mask.toString());
        }
        this.keyPosition = mask.indices[0];
    }

    @Override
    public Iterable<Tuple> getSignatures() {
        return () -> {
            final Iterator wrapped = this.memoryMap.keySet().iterator();
            return new Iterator<Tuple>(){

                @Override
                public boolean hasNext() {
                    return wrapped.hasNext();
                }

                @Override
                public Tuple next() {
                    Object key = wrapped.next();
                    return Tuples.staticArityFlatTupleOf(key);
                }
            };
        };
    }

    @Override
    public Diff<Timestamp> removeWithTimestamp(Tuple tuple, Tuple signature, Timestamp timestamp) {
        Object key = tuple.get(this.keyPosition);
        return this.removeInternal(key, tuple, timestamp);
    }

    @Override
    public Diff<Timestamp> addWithTimestamp(Tuple tuple, Tuple signature, Timestamp timestamp) {
        Object key = tuple.get(this.keyPosition);
        return this.addInternal(key, tuple, timestamp);
    }

    @Override
    public Collection<Tuple> get(ITuple signature) {
        return this.getInternal(signature.get(0));
    }

    @Override
    public Map<Tuple, Timeline<Timestamp>> getWithTimeline(ITuple signature) {
        return this.getWithTimestampInternal(signature.get(0));
    }

    @Override
    public boolean isPresentAtInfinity(ITuple signature) {
        return this.isPresentAtInfinityInteral(signature.get(0));
    }

    @Override
    public Iterable<Tuple> getResumableSignatures() {
        if (this.foldingStates == null || this.foldingStates.isEmpty()) {
            return Collections.emptySet();
        }
        return () -> {
            final Iterator wrapped = ((Set)this.foldingStates.firstEntry().getValue()).iterator();
            return new Iterator<Tuple>(){

                @Override
                public boolean hasNext() {
                    return wrapped.hasNext();
                }

                @Override
                public Tuple next() {
                    Object key = wrapped.next();
                    return Tuples.staticArityFlatTupleOf(key);
                }
            };
        };
    }

    @Override
    public Map<Tuple, Map<Tuple, Diff<Timestamp>>> resumeAt(Timestamp timestamp) {
        Map<Tuple, Map<Tuple, Diff<Timestamp>>> result = CollectionsFactory.createMap();
        Comparable resumableTimestamp = this.getResumableTimestamp();
        if (resumableTimestamp == null) {
            throw new IllegalStateException("There is nothing to fold!");
        }
        if (resumableTimestamp.compareTo(timestamp) != 0) {
            throw new IllegalStateException("Expected to continue folding at " + resumableTimestamp + "!");
        }
        Set signatures = (Set)this.foldingStates.remove(timestamp);
        for (Object signature : signatures) {
            TimelyMemory memory = (TimelyMemory)this.memoryMap.get(signature);
            Map<Tuple, Diff<Comparable>> diffMap = memory.resumeAt(resumableTimestamp);
            result.put(Tuples.staticArityFlatTupleOf(signature), diffMap);
            this.registerFoldingState(memory.getResumableTimestamp(), signature);
        }
        return result;
    }
}

