/*******************************************************************************
 * Copyright (c) 2010-2017, Gabor Bergmann, IncQueryLabs Ltd.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 * 
 * SPDX-License-Identifier: EPL-2.0
 *******************************************************************************/
package org.eclipse.viatra.query.runtime.matchers.tuple;

import java.util.Objects;

/**
 * Flat tuple with statically known arity of 2.
 * 
 * @author Gabor Bergmann
 * @since 1.7
 *
 */
public final class FlatTuple2 extends BaseFlatTuple {
    private final Object element0;
    private final Object element1;

    protected FlatTuple2(Object element0, Object element1) {
        this.element0 = element0;
        this.element1 = element1;
        calcHash();
   }

    @Override
    public int getSize() {
        return 2;
    }

    @Override
    public Object get(int index) {
        switch(index) {
        case 0 : return element0;
        case 1 : return element1;
        default: throw raiseIndexingError(index);
        }
    }
    
    @Override
    protected boolean internalEquals(ITuple other) {
        return 2 == other.getSize() &&
                Objects.equals(element0, other.get(0)) &&
                Objects.equals(element1, other.get(1));
    }

}
