/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.check;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.CheckOperationExecutor;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.MatchingFrameValueProvider;
import org.eclipse.viatra.query.runtime.matchers.psystem.IExpressionEvaluator;
import org.eclipse.viatra.query.runtime.matchers.psystem.IValueProvider;

public class ExpressionEvalCheck
implements ISearchOperation {
    private final int outputPosition;
    private final IExpressionEvaluator evaluator;
    private final Map<String, Integer> nameMap;
    private final boolean unwind;

    public ExpressionEvalCheck(IExpressionEvaluator evaluator, Map<String, Integer> nameMap, int position) {
        this(evaluator, nameMap, false, position);
    }

    public ExpressionEvalCheck(IExpressionEvaluator evaluator, Map<String, Integer> nameMap, boolean unwind, int position) {
        this.evaluator = evaluator;
        this.nameMap = nameMap;
        this.unwind = unwind;
        this.outputPosition = position;
    }

    @Override
    public ISearchOperation.ISearchOperationExecutor createExecutor() {
        return new Executor();
    }

    @Override
    public List<Integer> getVariablePositions() {
        return new ArrayList<Integer>(this.nameMap.values());
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    @Override
    public String toString(Function<Integer, String> variableMapping) {
        return "check     " + variableMapping.apply(this.outputPosition) + " = expression " + this.evaluator.getShortDescription();
    }

    private class Executor
    extends CheckOperationExecutor {
        private Executor() {
        }

        @Override
        protected boolean check(MatchingFrame frame, ISearchContext context) {
            try {
                Object result = ExpressionEvalCheck.this.evaluator.evaluateExpression((IValueProvider)new MatchingFrameValueProvider(frame, ExpressionEvalCheck.this.nameMap));
                if (!ExpressionEvalCheck.this.unwind && result != null) {
                    Object currentValue = frame.get(ExpressionEvalCheck.this.outputPosition);
                    return result.equals(currentValue);
                }
                if (ExpressionEvalCheck.this.unwind && result instanceof Set) {
                    Object currentValue = frame.get(ExpressionEvalCheck.this.outputPosition);
                    return ((Set)result).contains(currentValue);
                }
            }
            catch (Exception e) {
                context.getLogger().warn((Object)"Error while evaluating expression", (Throwable)e);
            }
            return false;
        }

        @Override
        public ISearchOperation getOperation() {
            return ExpressionEvalCheck.this;
        }
    }
}

