/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.planner.compiler;

import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.query.runtime.emf.EMFQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EClassUnscopedTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EDataTypeInSlotsKey;
import org.eclipse.viatra.query.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.InstanceOfClassCheck;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.InstanceOfDataTypeCheck;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.InstanceOfJavaClassCheck;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.StructuralFeatureCheck;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.nobase.ScopeCheck;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.ExtendToEStructuralFeatureSource;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.ExtendToEStructuralFeatureTarget;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.IterateOverContainers;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.nobase.IterateOverEClassInstances;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.nobase.IterateOverEDatatypeInstances;
import org.eclipse.viatra.query.runtime.localsearch.planner.compiler.AbstractOperationCompiler;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.context.common.JavaTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.TypeFilterConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;

public class EMFOperationCompiler
extends AbstractOperationCompiler {
    private boolean baseIndexAvailable;
    private final EMFQueryRuntimeContext runtimeContext;

    public EMFOperationCompiler(IQueryRuntimeContext runtimeContext) {
        this(runtimeContext, false);
    }

    public EMFOperationCompiler(IQueryRuntimeContext runtimeContext, boolean baseIndexAvailable) {
        super(runtimeContext);
        this.runtimeContext = (EMFQueryRuntimeContext)runtimeContext;
        this.baseIndexAvailable = baseIndexAvailable;
    }

    @Override
    protected void createCheck(TypeFilterConstraint typeConstraint, Map<PVariable, Integer> variableMapping) {
        IInputKey inputKey = typeConstraint.getInputKey();
        if (inputKey instanceof JavaTransitiveInstancesKey) {
            this.operations.add(new InstanceOfJavaClassCheck(variableMapping.get(typeConstraint.getVariablesTuple().get(0)), ((JavaTransitiveInstancesKey)inputKey).getInstanceClass()));
        } else if (inputKey instanceof EDataTypeInSlotsKey) {
            this.operations.add(new InstanceOfDataTypeCheck(variableMapping.get(typeConstraint.getVariablesTuple().get(0)), (EDataType)((EDataTypeInSlotsKey)inputKey).getEmfKey()));
        } else if (inputKey instanceof EClassUnscopedTransitiveInstancesKey) {
            this.operations.add(new InstanceOfClassCheck(variableMapping.get(typeConstraint.getVariablesTuple().get(0)), (EClass)((EClassUnscopedTransitiveInstancesKey)inputKey).getEmfKey()));
        } else {
            String msg = "Unsupported type: " + inputKey;
            throw new QueryProcessingException(msg, null, msg, null);
        }
    }

    @Override
    protected void createCheck(TypeConstraint typeConstraint, Map<PVariable, Integer> variableMapping) {
        IInputKey inputKey = (IInputKey)typeConstraint.getSupplierKey();
        if (inputKey instanceof EClassTransitiveInstancesKey) {
            this.operations.add(new InstanceOfClassCheck(variableMapping.get(typeConstraint.getVariablesTuple().get(0)), (EClass)((EClassTransitiveInstancesKey)inputKey).getEmfKey()));
            this.operations.add(new ScopeCheck(variableMapping.get(typeConstraint.getVariablesTuple().get(0)), this.runtimeContext.getEmfScope()));
        } else if (inputKey instanceof EStructuralFeatureInstancesKey) {
            int sourcePosition = variableMapping.get(typeConstraint.getVariablesTuple().get(0));
            int targetPosition = variableMapping.get(typeConstraint.getVariablesTuple().get(1));
            this.operations.add(new StructuralFeatureCheck(sourcePosition, targetPosition, (EStructuralFeature)((EStructuralFeatureInstancesKey)inputKey).getEmfKey()));
        } else if (inputKey instanceof EDataTypeInSlotsKey) {
            this.operations.add(new InstanceOfDataTypeCheck(variableMapping.get(typeConstraint.getVariablesTuple().get(0)), (EDataType)((EDataTypeInSlotsKey)inputKey).getEmfKey()));
        } else {
            String msg = "Unsupported type: " + inputKey;
            throw new QueryProcessingException(msg, null, msg, null);
        }
    }

    @Override
    public void createExtend(TypeConstraint typeConstraint, Map<PVariable, Integer> variableMapping) {
        IInputKey inputKey = (IInputKey)typeConstraint.getSupplierKey();
        if (inputKey instanceof EDataTypeInSlotsKey) {
            if (this.baseIndexAvailable) {
                this.operations.add(new org.eclipse.viatra.query.runtime.localsearch.operations.extend.IterateOverEDatatypeInstances(variableMapping.get(typeConstraint.getVariableInTuple(0)), (EDataType)((EDataTypeInSlotsKey)inputKey).getEmfKey()));
            } else {
                int position = variableMapping.get(typeConstraint.getVariableInTuple(0));
                this.operations.add(new IterateOverEDatatypeInstances(position, (EDataType)((EDataTypeInSlotsKey)inputKey).getEmfKey(), this.runtimeContext.getEmfScope()));
                this.operations.add(new ScopeCheck(position, this.runtimeContext.getEmfScope()));
            }
        } else if (inputKey instanceof EClassTransitiveInstancesKey) {
            if (this.baseIndexAvailable) {
                this.operations.add(new org.eclipse.viatra.query.runtime.localsearch.operations.extend.IterateOverEClassInstances(variableMapping.get(typeConstraint.getVariableInTuple(0)), (EClass)((EClassTransitiveInstancesKey)inputKey).getEmfKey()));
            } else {
                int position = variableMapping.get(typeConstraint.getVariableInTuple(0));
                this.operations.add(new IterateOverEClassInstances(position, (EClass)((EClassTransitiveInstancesKey)inputKey).getEmfKey(), this.runtimeContext.getEmfScope()));
                this.operations.add(new ScopeCheck(position, this.runtimeContext.getEmfScope()));
            }
        } else if (inputKey instanceof EStructuralFeatureInstancesKey) {
            EStructuralFeature feature = (EStructuralFeature)((EStructuralFeatureInstancesKey)inputKey).getEmfKey();
            int sourcePosition = variableMapping.get(typeConstraint.getVariablesTuple().get(0));
            int targetPosition = variableMapping.get(typeConstraint.getVariablesTuple().get(1));
            boolean fromBound = ((Set)this.variableBindings.get(typeConstraint)).contains(sourcePosition);
            boolean toBound = ((Set)this.variableBindings.get(typeConstraint)).contains(targetPosition);
            if (fromBound && !toBound) {
                this.operations.add(new ExtendToEStructuralFeatureTarget(sourcePosition, targetPosition, feature));
                this.operations.add(new ScopeCheck(targetPosition, this.runtimeContext.getEmfScope()));
            } else if (!fromBound && toBound) {
                if (feature instanceof EReference && ((EReference)feature).isContainment()) {
                    this.operations.add(new IterateOverContainers(sourcePosition, targetPosition, false));
                    this.operations.add(new ScopeCheck(sourcePosition, this.runtimeContext.getEmfScope()));
                } else if (this.baseIndexAvailable) {
                    TupleMask mask = TupleMask.fromSelectedIndices((int)variableMapping.size(), (int[])new int[]{targetPosition});
                    this.operations.add(new ExtendToEStructuralFeatureSource(sourcePosition, targetPosition, feature, mask));
                } else {
                    this.operations.add(new org.eclipse.viatra.query.runtime.localsearch.operations.extend.nobase.ExtendToEStructuralFeatureSource(sourcePosition, targetPosition, feature));
                    this.operations.add(new ScopeCheck(sourcePosition, this.runtimeContext.getEmfScope()));
                }
            } else if (this.baseIndexAvailable) {
                this.operations.add(new org.eclipse.viatra.query.runtime.localsearch.operations.extend.IterateOverEClassInstances(sourcePosition, feature.getEContainingClass()));
                this.operations.add(new ExtendToEStructuralFeatureTarget(sourcePosition, targetPosition, feature));
            } else {
                this.operations.add(new IterateOverEClassInstances(sourcePosition, feature.getEContainingClass(), this.runtimeContext.getEmfScope()));
                this.operations.add(new ScopeCheck(sourcePosition, this.runtimeContext.getEmfScope()));
                this.operations.add(new ExtendToEStructuralFeatureTarget(sourcePosition, targetPosition, feature));
                this.operations.add(new ScopeCheck(targetPosition, this.runtimeContext.getEmfScope()));
            }
        } else {
            throw new IllegalArgumentException("Unsupported type: " + inputKey);
        }
    }
}

