/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.graph;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.gef4.graph.Graph;

public final class Node {
    private final Map<String, Object> attrs;

    public Node(Map<String, Object> attrs) {
        this.attrs = attrs;
    }

    public Map<String, Object> getAttrs() {
        return Collections.unmodifiableMap(this.attrs);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof Node)) {
            return false;
        }
        boolean attrsEqual = this.getAttrs().equals(((Node)that).getAttrs());
        return attrsEqual;
    }

    public int hashCode() {
        return this.getAttrs().hashCode();
    }

    public String toString() {
        return String.format("Node {%s attrs}", this.attrs.size());
    }

    public static class Builder {
        private Map<String, Object> attrs = new HashMap<String, Object>();

        public Builder attr(String key, Object value) {
            this.attrs.put(key, value);
            return this;
        }

        public Builder attr(Graph.Attr.Key attr, Object value) {
            return this.attr(attr.toString(), value);
        }

        public Node build() {
            return new Node(this.attrs);
        }
    }
}

