/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph.test.stub.model;

import java.util.Date;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.test.stub.model.EventImpl;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.test.stub.model.TraceImpl;

public class TraceModelImplFactory {
    private int count = 0;
    private final TraceStrings[] traceNames;
    private static final long msTons = 1000000L;
    private final Long timeRef = new Date().getTime() * 1000000L;

    public TraceModelImplFactory() {
        this.traceNames = new TraceStrings[17];
        this.loadTraceNameStrings();
    }

    public TraceImpl[] createTraces() {
        TraceImpl[] traceArr = new TraceImpl[17];
        int i = 0;
        while (i < traceArr.length) {
            TraceImpl trace = new TraceImpl(this.traceNames[i].name, this.timeRef, this.timeRef + 40L, this.traceNames[i].classNmme);
            this.count = i;
            this.createEvents(trace);
            traceArr[i] = trace;
            ++i;
        }
        return traceArr;
    }

    public TraceImpl[] createLargeTraces(int number) {
        TraceImpl[] traceArr = new TraceImpl[number];
        int i = 0;
        while (i < traceArr.length) {
            int counter = i % 17;
            long sTime = (long)i * 1000000L;
            TraceImpl trace = new TraceImpl(this.traceNames[counter].name, sTime, sTime + 20000L, this.traceNames[counter].classNmme);
            TraceModelImplFactory.create5000Events(trace);
            traceArr[i] = trace;
            ++i;
        }
        return traceArr;
    }

    private static void create5000Events(TraceImpl trace) {
        int numEvents = 5000;
        long sTime = trace.getStartTime();
        long eTime = trace.getEndTime();
        long duration = (eTime - sTime) / (long)numEvents;
        int i = 0;
        while (i < numEvents) {
            Long eventTime = sTime + (long)i * duration;
            EventImpl event = new EventImpl(eventTime, trace, TraceModelImplFactory.getEventType(i % 16));
            event.setDuration(duration);
            trace.addTraceEvent(event);
            ++i;
        }
    }

    private void createEvents(TraceImpl trace) {
        int numEvents = 17;
        long duration = 0L;
        int i = 0;
        while (i < numEvents) {
            Long eventTime = this.timeRef + 1000000L * (long)i + 5000000L * (long)this.count + (long)(5 * i);
            duration = 1000000L + (long)i * 1000000L + (long)(i % 4);
            EventImpl event = new EventImpl(eventTime, trace, TraceModelImplFactory.getEventType(i));
            event.setDuration(duration);
            trace.addTraceEvent(event);
            ++i;
        }
    }

    private static EventImpl.Type getEventType(int val) {
        if (EventImpl.Type.ALARM.ordinal() == val) {
            return EventImpl.Type.ALARM;
        }
        if (EventImpl.Type.ERROR.ordinal() == val) {
            return EventImpl.Type.ERROR;
        }
        if (EventImpl.Type.EVENT.ordinal() == val) {
            return EventImpl.Type.EVENT;
        }
        if (EventImpl.Type.INFORMATION.ordinal() == val) {
            return EventImpl.Type.INFORMATION;
        }
        if (EventImpl.Type.TIMEADJUSTMENT.ordinal() == val) {
            return EventImpl.Type.TIMEADJUSTMENT;
        }
        if (EventImpl.Type.WARNING.ordinal() == val) {
            return EventImpl.Type.WARNING;
        }
        if (EventImpl.Type.INFO1.ordinal() == val) {
            return EventImpl.Type.INFO1;
        }
        if (EventImpl.Type.INFO2.ordinal() == val) {
            return EventImpl.Type.INFO2;
        }
        if (EventImpl.Type.INFO3.ordinal() == val) {
            return EventImpl.Type.INFO3;
        }
        if (EventImpl.Type.INFO4.ordinal() == val) {
            return EventImpl.Type.INFO4;
        }
        if (EventImpl.Type.INFO5.ordinal() == val) {
            return EventImpl.Type.INFO5;
        }
        if (EventImpl.Type.INFO6.ordinal() == val) {
            return EventImpl.Type.INFO6;
        }
        if (EventImpl.Type.INFO7.ordinal() == val) {
            return EventImpl.Type.INFO7;
        }
        if (EventImpl.Type.INFO8.ordinal() == val) {
            return EventImpl.Type.INFO8;
        }
        if (EventImpl.Type.INFO9.ordinal() == val) {
            return EventImpl.Type.INFO9;
        }
        return EventImpl.Type.UNKNOWN;
    }

    private void loadTraceNameStrings() {
        this.traceNames[0] = new TraceStrings();
        this.traceNames[0].name = "TE Log - TATA BSC11";
        this.traceNames[0].classNmme = "All Boards";
        this.traceNames[1] = new TraceStrings();
        this.traceNames[1].name = "System Log";
        this.traceNames[1].classNmme = "BSC11";
        this.traceNames[2] = new TraceStrings();
        this.traceNames[2].name = "Alarm Log";
        this.traceNames[2].classNmme = "BSC11";
        this.traceNames[3] = new TraceStrings();
        this.traceNames[3].name = "Events Log";
        this.traceNames[3].classNmme = "BSC 11";
        this.traceNames[4] = new TraceStrings();
        this.traceNames[4].name = "CPU Load";
        this.traceNames[4].classNmme = "All Boards";
        this.traceNames[5] = new TraceStrings();
        this.traceNames[5].name = "Performance Log";
        this.traceNames[5].classNmme = "BSC11";
        this.traceNames[6] = new TraceStrings();
        this.traceNames[6].name = "TE Log  - TATA BSC14";
        this.traceNames[6].classNmme = "Board 24";
        this.traceNames[7] = new TraceStrings();
        this.traceNames[7].name = "TE Log - TATA BSC14";
        this.traceNames[7].classNmme = "Board 23";
        this.traceNames[8] = new TraceStrings();
        this.traceNames[8].name = "TE Log - TATA BSC14";
        this.traceNames[8].classNmme = "Board 11";
        this.traceNames[9] = new TraceStrings();
        this.traceNames[9].name = "TE Log - TATA BSC14";
        this.traceNames[9].classNmme = "Board 14, SPO";
        this.traceNames[10] = new TraceStrings();
        this.traceNames[10].name = "INFO 1";
        this.traceNames[10].classNmme = "All Boards";
        this.traceNames[11] = new TraceStrings();
        this.traceNames[11].name = "INFO2";
        this.traceNames[11].classNmme = "BSC11";
        this.traceNames[12] = new TraceStrings();
        this.traceNames[12].name = "INFO3";
        this.traceNames[12].classNmme = "Board 24";
        this.traceNames[13] = new TraceStrings();
        this.traceNames[13].name = "MISC1";
        this.traceNames[13].classNmme = "Board 23";
        this.traceNames[14] = new TraceStrings();
        this.traceNames[14].name = "MISC2";
        this.traceNames[14].classNmme = "Board 11";
        this.traceNames[15] = new TraceStrings();
        this.traceNames[15].name = "MISC3";
        this.traceNames[15].classNmme = "Board 23";
        this.traceNames[16] = new TraceStrings();
        this.traceNames[16].name = "MISC4";
        this.traceNames[16].classNmme = "Board 11";
    }

    private static class TraceStrings {
        public String name = "";
        public String classNmme = String.valueOf(this.name) + " class";

        private TraceStrings() {
        }
    }
}

