/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.views.uml2sd.loader;

import org.eclipse.tracecompass.tmf.core.component.TmfComponent;
import org.eclipse.tracecompass.tmf.core.signal.TmfEndSynchSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfStartSynchSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.ui.tests.TmfUITestPlugin;
import org.eclipse.tracecompass.tmf.ui.tests.views.uml2sd.loader.IUml2SdSignalValidator;

public class Uml2SDSignalValidator
extends TmfComponent
implements IUml2SdSignalValidator {
    private int fSignalDepth = 0;
    private boolean fIsSelectionRangeSignalReceived = false;
    private boolean fIsWindowRangeSignalReceived = false;
    private boolean fIsSignalError = false;
    private boolean fIsSourceError = false;
    private boolean fIsCurrentTimeError = false;
    private boolean fIsRangeError = false;
    private Object fSource = null;
    private ITmfTimestamp fCurrentTimestamp = null;
    private TmfTimeRange fCurrentTimeRange = null;

    @TmfSignalHandler
    public void synchToTime(TmfSelectionRangeUpdatedSignal signal) {
        this.setSourceError(this.getSource() != signal.getSource());
        if (this.isSourceError()) {
            TmfUITestPlugin.getDefault().logError("Source Error: source:" + signal.getSource() + ", expected " + this.getSource());
        }
        this.setCurrentTimeError(!this.getCurrentTime().equals(signal.getBeginTime()));
        if (this.isCurrentTimeError()) {
            TmfUITestPlugin.getDefault().logError("Current Time Error: begin time:" + signal.getBeginTime() + ", expected " + this.getCurrentTime());
        }
        this.setSelectionRangeSignalReceived(true);
    }

    @TmfSignalHandler
    public void synchToTimeRange(TmfWindowRangeUpdatedSignal signal) {
        if (this.getSource() != null) {
            this.setSourceError(this.getSource() != signal.getSource());
            if (this.isSourceError()) {
                TmfUITestPlugin.getDefault().logError("Source Error: source:" + signal.getSource() + ", expected " + this.getSource());
            }
        }
        if (this.getCurrentRange() != null) {
            this.setRangeError(!this.getCurrentRange().equals((Object)signal.getCurrentRange()));
            if (this.isRangeError()) {
                TmfUITestPlugin.getDefault().logError("Range Error: current range:" + signal.getCurrentRange() + ", expected " + this.getCurrentRange());
            }
        }
        this.setWindowRangeSignalReceived(true);
    }

    @TmfSignalHandler
    public void startSynch(TmfStartSynchSignal signal) {
        ++this.fSignalDepth;
        this.setSignalError(this.fSignalDepth > 1);
        if (this.isSignalError()) {
            TmfUITestPlugin.getDefault().logError("Signal Error: signal depth:" + this.fSignalDepth);
        }
    }

    @TmfSignalHandler
    public void endSynch(TmfEndSynchSignal signal) {
        this.fSignalDepth = this.fSignalDepth > 0 ? this.fSignalDepth - 1 : 0;
    }

    @Override
    public boolean isSelectionRangeSignalReceived() {
        return this.fIsSelectionRangeSignalReceived;
    }

    @Override
    public void setSelectionRangeSignalReceived(boolean received) {
        this.fIsSelectionRangeSignalReceived = received;
    }

    @Override
    public boolean isWindowRangeSignalReceived() {
        return this.fIsWindowRangeSignalReceived;
    }

    @Override
    public void setWindowRangeSignalReceived(boolean received) {
        this.fIsWindowRangeSignalReceived = received;
    }

    @Override
    public boolean isSourceError() {
        return this.fIsSourceError;
    }

    @Override
    public void setSourceError(boolean fIsSourceError) {
        this.fIsSourceError = fIsSourceError;
    }

    @Override
    public boolean isCurrentTimeError() {
        return this.fIsCurrentTimeError;
    }

    @Override
    public void setCurrentTimeError(boolean fIsCurrentTimeError) {
        this.fIsCurrentTimeError = fIsCurrentTimeError;
    }

    @Override
    public boolean isRangeError() {
        return this.fIsRangeError;
    }

    @Override
    public void setRangeError(boolean fIsRangeError) {
        this.fIsRangeError = fIsRangeError;
    }

    @Override
    public boolean isSignalError() {
        return this.fIsSignalError;
    }

    @Override
    public void setSignalError(boolean fIsSignalError) {
        this.fIsSignalError = fIsSignalError;
    }

    @Override
    public Object getSource() {
        return this.fSource;
    }

    @Override
    public void setSource(Object source) {
        this.fSource = source;
    }

    @Override
    public ITmfTimestamp getCurrentTime() {
        return this.fCurrentTimestamp;
    }

    @Override
    public void setCurrentTime(ITmfTimestamp currentTime) {
        this.fCurrentTimestamp = currentTime;
    }

    @Override
    public TmfTimeRange getCurrentRange() {
        return this.fCurrentTimeRange;
    }

    @Override
    public void setCurrentRange(TmfTimeRange currentRange) {
        this.fCurrentTimeRange = currentRange == null ? null : currentRange;
    }
}

