/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.AbstractXmlViewInfo;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.w3c.dom.Element;

@NonNullByDefault
public class XmlViewInfo
extends AbstractXmlViewInfo {
    private static final String XML_VIEW_ID_PROPERTY = "XmlViewId";
    private static final String XML_VIEW_FILE_PROPERTY = "XmlViewFile";
    private @Nullable String fId = null;
    private @Nullable String fFilePath = null;
    private boolean fIsDirty = false;

    public XmlViewInfo(String viewId) {
        super(viewId);
    }

    @Override
    public synchronized void setViewData(String data) {
        String[] idFile = data.split(";;;");
        this.fId = idFile.length > 0 ? idFile[0] : null;
        this.fFilePath = idFile.length > 1 ? idFile[1] : null;
        String viewName = this.getName();
        if (viewName != null) {
            this.savePersistentData();
        } else {
            this.fIsDirty = true;
        }
    }

    @Override
    public synchronized void setName(String name) {
        super.setName(name);
        if (this.fIsDirty) {
            this.savePersistentData();
        } else {
            IDialogSettings settings = this.getPersistentPropertyStore();
            this.fId = settings.get(XML_VIEW_ID_PROPERTY);
            this.fFilePath = settings.get(XML_VIEW_FILE_PROPERTY);
        }
    }

    @Override
    protected void savePersistentData() {
        IDialogSettings settings = this.getPersistentPropertyStore();
        settings.put(XML_VIEW_ID_PROPERTY, this.fId);
        settings.put(XML_VIEW_FILE_PROPERTY, this.fFilePath);
    }

    public @Nullable Element getViewElement(String xmlTag) {
        String id = this.fId;
        if (id == null) {
            return null;
        }
        Element viewElement = TmfXmlUtils.getElementInFile((String)this.fFilePath, (String)xmlTag, (String)id);
        return viewElement;
    }

    public @Nullable String getViewTitle(Element viewElement) {
        Element label;
        Element head;
        List labels;
        Iterator iterator;
        List heads = TmfXmlUtils.getChildElements((Element)viewElement, (String)"head");
        String title = null;
        if (!heads.isEmpty() && (iterator = (labels = TmfXmlUtils.getChildElements((Element)(head = (Element)heads.get(0)), (String)"label")).iterator()).hasNext() && !(label = (Element)iterator.next()).getAttribute("value").isEmpty()) {
            title = label.getAttribute("value");
        }
        return title;
    }
}

