/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.core;

import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.IAxisSet;
import org.eclipse.swtchart.IAxisTick;
import org.eclipse.swtchart.ICustomPaintListener;
import org.eclipse.swtchart.IGrid;
import org.eclipse.swtchart.ILegend;
import org.eclipse.swtchart.IPlotArea;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.ISeriesSet;
import org.eclipse.swtchart.ITitle;
import org.eclipse.swtchart.Range;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.IAxisSettings;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.ICustomSelectionHandler;
import org.eclipse.swtchart.extensions.core.IEventHandler;
import org.eclipse.swtchart.extensions.core.IExtendedChart;
import org.eclipse.swtchart.extensions.core.IPrimaryAxisSettings;
import org.eclipse.swtchart.extensions.core.IScrollableChart;
import org.eclipse.swtchart.extensions.core.ISecondaryAxisSettings;
import org.eclipse.swtchart.extensions.core.ISeriesData;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.core.Messages;
import org.eclipse.swtchart.extensions.core.RangeSelector;
import org.eclipse.swtchart.extensions.core.SeriesData;
import org.eclipse.swtchart.extensions.events.IHandledEventProcessor;
import org.eclipse.swtchart.extensions.exceptions.SeriesException;
import org.eclipse.swtchart.extensions.internal.marker.AxisZeroMarker;
import org.eclipse.swtchart.extensions.internal.marker.LegendMarker;
import org.eclipse.swtchart.extensions.internal.marker.PlotCenterMarker;
import org.eclipse.swtchart.extensions.internal.marker.PositionMarker;
import org.eclipse.swtchart.extensions.internal.marker.SeriesLabelMarker;
import org.eclipse.swtchart.extensions.menu.IChartMenuEntry;

public class ScrollableChart
extends Composite
implements IScrollableChart,
IEventHandler,
IExtendedChart {
    public static final int NO_COMPRESS_TO_LENGTH = Integer.MAX_VALUE;
    private static final String EXTENSION_POINT_MENU_ITEMS = "org.eclipse.swtchart.extensions.menuitems";
    private static final String EXTENSION_POINT_MENU_ENTRY = "MenuEntry";
    private Map<String, Set<IChartMenuEntry>> categoryMenuEntriesMap;
    private Map<String, IChartMenuEntry> menuEntryMap;
    private Slider sliderVertical;
    private Slider sliderHorizontal;
    private RangeSelector rangeSelector;
    private BaseChart baseChart;
    private boolean enableRangeSelectorHint;
    private static final int MILLISECONDS_SHOW_RANGE_INFO_HINT = 1000;
    private boolean showRangeSelectorHint;
    private RangeHintPaintListener rangeHintPaintListener;
    private List<ScrollableChart> linkedScrollableCharts;
    private PositionMarker positionMarker;
    private PlotCenterMarker plotCenterMarker;
    private LegendMarker legendMarker;
    private AxisZeroMarker axisZeroMarker;
    private SeriesLabelMarker seriesLabelMarker;
    private static final int HORIZONTAL_SCROLL_LENGTH = 1000000;
    private static final int VERTICAL_SCROLL_LENGTH = 1000000;

    public ScrollableChart() {
        this((Composite)ScrollableChart.getSeparateShell(), 0);
    }

    public ScrollableChart(Composite parent, int style) {
        super(parent, style);
        this.showRangeSelectorHint = this.enableRangeSelectorHint = false;
        this.categoryMenuEntriesMap = new HashMap<String, Set<IChartMenuEntry>>();
        this.menuEntryMap = new HashMap<String, IChartMenuEntry>();
        this.linkedScrollableCharts = new ArrayList<ScrollableChart>();
        this.initialize();
    }

    @Override
    public IChartSettings getChartSettings() {
        return this.baseChart.getChartSettings();
    }

    public void addLinkedScrollableChart(ScrollableChart scrollableChart) {
        this.linkedScrollableCharts.add(scrollableChart);
    }

    public void removeLinkedScrollableChart(ScrollableChart scrollableChart) {
        this.linkedScrollableCharts.remove(scrollableChart);
    }

    @Override
    public void applySettings(IChartSettings chartSettings) {
        this.baseChart.setChartSettings(chartSettings);
        this.baseChart.suspendUpdate(true);
        this.modifyChart();
        this.adjustSeries();
        this.baseChart.suspendUpdate(false);
        this.baseChart.redraw();
    }

    @Override
    public BaseChart getBaseChart() {
        return this.baseChart;
    }

    @Override
    public ISeries createSeries(ISeriesData seriesData, ISeriesSettings seriesSettings) throws SeriesException {
        ISeries series = this.baseChart.createSeries(seriesData, seriesSettings);
        this.resetSlider();
        return series;
    }

    public void redraw() {
        this.resetSlider();
        super.redraw();
    }

    @Override
    public void deleteSeries() {
        boolean wasSuspend = this.baseChart.isUpdateSuspended();
        if (!wasSuspend) {
            this.baseChart.suspendUpdate(true);
        }
        ISeries[] iSeriesArray = this.baseChart.getSeriesSet().getSeries();
        int n = iSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries series = iSeriesArray[n2];
            this.baseChart.deleteSeries(series.getId());
            ++n2;
        }
        if (!wasSuspend) {
            this.baseChart.suspendUpdate(false);
        }
    }

    @Override
    public void deleteSeries(String id) {
        this.baseChart.deleteSeries(id);
        this.redraw();
    }

    @Override
    public void appendSeries(ISeriesData seriesData) {
        this.baseChart.appendSeries(seriesData);
        this.adjustRange(true);
    }

    @Override
    public void setRange(String axis, Range range) {
        if (axis != null && range != null) {
            this.setRange(axis, range.lower, range.upper);
        }
    }

    @Override
    public void setRange(String axis, double start, double stop) {
        this.baseChart.setRange(axis, start, stop);
        this.setSliderSelection(false);
        this.updateLinkedCharts();
    }

    @Override
    public void adjustRange(boolean adjustMinMax) {
        this.baseChart.adjustRange(adjustMinMax);
        this.resetSlider();
    }

    public void adjustXAxis() {
        IAxis[] iAxisArray = this.baseChart.getAxisSet().getXAxes();
        int n = iAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis axis = iAxisArray[n2];
            axis.adjustRange();
            ++n2;
        }
        this.resetSlider();
    }

    public void adjustYAxis() {
        IAxis[] iAxisArray = this.baseChart.getAxisSet().getYAxes();
        int n = iAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis axis = iAxisArray[n2];
            axis.adjustRange();
            ++n2;
        }
        this.resetSlider();
    }

    public void zoomIn() {
        this.baseChart.getAxisSet().zoomIn();
        this.resetSlider();
    }

    public void zoomOut() {
        this.baseChart.getAxisSet().zoomOut();
        this.resetSlider();
    }

    @Override
    public void adjustSecondaryXAxes() {
        this.baseChart.adjustSecondaryXAxes();
    }

    @Override
    public void adjustSecondaryYAxes() {
        this.baseChart.adjustSecondaryYAxes();
    }

    @Override
    public void handleMouseDownEvent(Event event) {
        this.baseChart.handleMouseDownEvent(event);
    }

    @Override
    public void handleMouseMoveEvent(Event event) {
        this.baseChart.handleMouseMoveEvent(event);
        if (this.positionMarker.isDraw()) {
            this.positionMarker.setActualPosition(event.x, event.y);
            this.redrawPlotArea();
        }
        if (this.legendMarker.isDraw()) {
            this.legendMarker.setActualPosition(event.x, event.y);
            this.redrawPlotArea();
        }
    }

    private void redrawPlotArea() {
        BaseChart chart = this.getBaseChart();
        IPlotArea plot = chart.getPlotArea();
        if (plot instanceof Control) {
            ((Control)plot).redraw();
        } else {
            chart.redraw();
        }
    }

    @Override
    public void handleMouseUpEvent(Event event) {
        this.baseChart.handleMouseUpEvent(event);
        this.updateLinkedCharts();
    }

    @Override
    public void handleMouseWheel(Event event) {
        this.baseChart.handleMouseWheel(event);
    }

    @Override
    public void handleMouseDoubleClick(Event event) {
        this.baseChart.handleMouseDoubleClick(event);
    }

    @Override
    public void handleKeyDownEvent(Event event) {
        this.baseChart.handleKeyDownEvent(event);
    }

    @Override
    public void handleKeyUpEvent(Event event) {
        this.baseChart.handleKeyUpEvent(event);
        this.resetSlider();
    }

    @Override
    public void handleSelectionEvent(Event event) {
        this.baseChart.handleSelectionEvent(event);
    }

    @Override
    public void paintControl(PaintEvent e) {
        this.baseChart.paintControl(e);
    }

    public void toggleRangeSelectorVisibility() {
        this.showRangeSelector(!this.rangeSelector.isVisible());
    }

    public void togglePositionMarkerVisibility() {
        this.positionMarker.setDraw(!this.positionMarker.isDraw());
        this.redrawPlotArea();
    }

    public void toggleCenterMarkerVisibility() {
        this.plotCenterMarker.setDraw(!this.plotCenterMarker.isDraw());
        super.redraw();
    }

    public void togglePositionLegendVisibility() {
        this.legendMarker.setDraw(!this.legendMarker.isDraw());
        super.redraw();
    }

    public void toggleSeriesLegendVisibility() {
        ILegend legend;
        legend.setVisible(!(legend = this.baseChart.getLegend()).isVisible());
        this.baseChart.redraw();
    }

    public void toggleAxisZeroVisibility() {
        this.axisZeroMarker.setDraw(!this.axisZeroMarker.isDraw());
        this.baseChart.redraw();
    }

    public void toggleSeriesLabelVisibility() {
        this.seriesLabelMarker.setDraw(!this.seriesLabelMarker.isDraw());
        this.baseChart.redraw();
    }

    public RangeSelector getRangeSelector() {
        return this.rangeSelector;
    }

    protected ISeriesData calculateSeries(ISeriesData seriesData) {
        return this.calculateSeries(seriesData, Integer.MAX_VALUE);
    }

    protected ISeriesData calculateSeries(ISeriesData seriesData, int compressToLength) {
        double[] xSeries = seriesData.getXSeries();
        double[] ySeries = seriesData.getYSeries();
        int seriesLength = ySeries.length;
        if (seriesLength > compressToLength) {
            ArrayList<Double> xSeriesCompressed = new ArrayList<Double>();
            ArrayList<Double> ySeriesCompressed = new ArrayList<Double>();
            xSeriesCompressed.add(xSeries[0]);
            ySeriesCompressed.add(ySeries[0]);
            int moduloValue = seriesLength / compressToLength;
            int i = 1;
            while (i < ySeries.length - 1) {
                double y = ySeries[i];
                boolean addValue = false;
                if (moduloValue > 0 && i % moduloValue == 0) {
                    addValue = true;
                }
                if (addValue) {
                    xSeriesCompressed.add(xSeries[i]);
                    ySeriesCompressed.add(y);
                }
                ++i;
            }
            xSeriesCompressed.add(xSeries[xSeries.length - 1]);
            ySeriesCompressed.add(ySeries[ySeries.length - 1]);
            double[] xCompressed = xSeriesCompressed.stream().mapToDouble(d -> d).toArray();
            double[] yCompressed = ySeriesCompressed.stream().mapToDouble(d -> d).toArray();
            return new SeriesData(xCompressed, yCompressed, seriesData.getId());
        }
        return seriesData;
    }

    protected boolean isLargeDataSet(double[] xSeries, double[] ySeries, int lengthHintDataPoints) {
        boolean isLargeDataSet = false;
        if (xSeries.length == ySeries.length && xSeries.length > lengthHintDataPoints) {
            isLargeDataSet = true;
        }
        return isLargeDataSet;
    }

    private static Shell getSeparateShell() {
        Display display = Display.getDefault();
        Rectangle bounds = display.getBounds();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        shell.setSize(bounds.width, bounds.height);
        shell.setLocation(0, 0);
        return shell;
    }

    private void modifyChart() {
        IChartSettings chartSettings = this.baseChart.getChartSettings();
        this.setSliderVisibility(chartSettings);
        this.setRangeInfoVisibility(chartSettings);
        ITitle title = this.baseChart.getTitle();
        title.setText(chartSettings.getTitle());
        title.setVisible(chartSettings.isTitleVisible());
        title.setForeground(chartSettings.getTitleColor());
        title.setFont(chartSettings.getTitleFont());
        ILegend legend = this.baseChart.getLegend();
        legend.setPosition(chartSettings.getLegendPosition());
        legend.setVisible(chartSettings.isLegendVisible());
        this.setBackground(chartSettings.getBackground());
        this.baseChart.setOrientation(chartSettings.getOrientation());
        this.baseChart.setBackground(chartSettings.getBackgroundChart());
        this.baseChart.setBackgroundInPlotArea(chartSettings.getBackgroundPlotArea());
        this.baseChart.enableCompress(chartSettings.isEnableCompress());
        this.baseChart.setRangeRestriction(chartSettings.getRangeRestriction());
        this.addPrimaryAxisX(chartSettings);
        this.addPrimaryAxisY(chartSettings);
        this.addSecondaryAxesX(chartSettings);
        this.addSecondaryAxesY(chartSettings);
        this.rangeSelector.resetRanges();
        this.setCustomPaintListener();
        this.updateRangeHintPaintListener();
        this.setMenuItems();
        this.setEventProcessors();
    }

    private void adjustSeries() {
        ISeriesSet seriesSet = this.baseChart.getSeriesSet();
        if (seriesSet.getSeries().length > 0) {
            this.adjustRange(true);
        }
    }

    private void setCustomPaintListener() {
        this.setPositionMarker();
        this.setPlotCenterMarker();
        this.setLegendMarker();
        this.setAxisZeroMarker();
        this.setSeriesLabelMarker();
    }

    private void setPositionMarker() {
        IPlotArea plotArea = this.baseChart.getPlotArea();
        IChartSettings chartSettings = this.baseChart.getChartSettings();
        if (this.positionMarker != null) {
            plotArea.removeCustomPaintListener((ICustomPaintListener)this.positionMarker);
        }
        this.positionMarker = new PositionMarker(this.baseChart);
        this.positionMarker.setForegroundColor(chartSettings.getColorPositionMarker());
        plotArea.addCustomPaintListener((ICustomPaintListener)this.positionMarker);
        if (chartSettings.isShowPositionMarker()) {
            this.positionMarker.setDraw(true);
        } else {
            this.positionMarker.setDraw(false);
        }
    }

    private void setPlotCenterMarker() {
        IPlotArea plotArea = this.baseChart.getPlotArea();
        IChartSettings chartSettings = this.baseChart.getChartSettings();
        if (this.plotCenterMarker != null) {
            plotArea.removeCustomPaintListener((ICustomPaintListener)this.plotCenterMarker);
        }
        this.plotCenterMarker = new PlotCenterMarker(this.baseChart);
        this.plotCenterMarker.setForegroundColor(chartSettings.getColorPlotCenterMarker());
        plotArea.addCustomPaintListener((ICustomPaintListener)this.plotCenterMarker);
        if (chartSettings.isShowPlotCenterMarker()) {
            this.plotCenterMarker.setDraw(true);
        } else {
            this.plotCenterMarker.setDraw(false);
        }
    }

    private void setLegendMarker() {
        IPlotArea plotArea = this.baseChart.getPlotArea();
        IChartSettings chartSettings = this.baseChart.getChartSettings();
        if (this.legendMarker != null) {
            plotArea.removeCustomPaintListener((ICustomPaintListener)this.legendMarker);
        }
        this.legendMarker = new LegendMarker(this.baseChart);
        this.legendMarker.setForegroundColor(chartSettings.getColorLegendMarker());
        plotArea.addCustomPaintListener((ICustomPaintListener)this.legendMarker);
        if (chartSettings.isShowLegendMarker()) {
            this.legendMarker.setDraw(true);
        } else {
            this.legendMarker.setDraw(false);
        }
    }

    private void setAxisZeroMarker() {
        IPlotArea plotArea = this.baseChart.getPlotArea();
        IChartSettings chartSettings = this.baseChart.getChartSettings();
        if (this.axisZeroMarker != null) {
            plotArea.removeCustomPaintListener((ICustomPaintListener)this.axisZeroMarker);
        }
        this.axisZeroMarker = new AxisZeroMarker(this.baseChart);
        this.axisZeroMarker.setForegroundColor(chartSettings.getColorAxisZeroMarker());
        plotArea.addCustomPaintListener((ICustomPaintListener)this.axisZeroMarker);
        if (chartSettings.isShowAxisZeroMarker()) {
            this.axisZeroMarker.setDraw(true);
        } else {
            this.axisZeroMarker.setDraw(false);
        }
    }

    private void setSeriesLabelMarker() {
        IPlotArea plotArea = this.baseChart.getPlotArea();
        IChartSettings chartSettings = this.baseChart.getChartSettings();
        if (this.seriesLabelMarker != null) {
            plotArea.removeCustomPaintListener((ICustomPaintListener)this.seriesLabelMarker);
        }
        this.seriesLabelMarker = new SeriesLabelMarker(this.baseChart);
        this.seriesLabelMarker.setForegroundColor(chartSettings.getColorSeriesLabelMarker());
        plotArea.addCustomPaintListener((ICustomPaintListener)this.seriesLabelMarker);
        if (chartSettings.isShowSeriesLabelMarker()) {
            this.seriesLabelMarker.setDraw(true);
        } else {
            this.seriesLabelMarker.setDraw(false);
        }
    }

    private void setMenuItems() {
        this.categoryMenuEntriesMap.clear();
        this.menuEntryMap.clear();
        IChartSettings chartSettings = this.baseChart.getChartSettings();
        if (chartSettings.isCreateMenu()) {
            this.addMenuItemsFromChartSettings();
            this.addMenuItemsFromExtensionPoint();
            this.createPopupMenu();
        } else {
            IPlotArea area = this.baseChart.getPlotArea();
            if (area instanceof Control) {
                Control control = (Control)area;
                Menu old = control.getMenu();
                if (old != null) {
                    old.dispose();
                }
                control.setMenu(null);
            }
        }
    }

    private void addMenuItemsFromChartSettings() {
        IChartSettings chartSettings = this.baseChart.getChartSettings();
        for (IChartMenuEntry menuEntry : chartSettings.getMenuEntries()) {
            this.addMenuEntry(menuEntry);
        }
    }

    private void setEventProcessors() {
        this.baseChart.clearEventProcessors();
        this.addHandledEventProcessorsFromChartSettings();
    }

    private void addHandledEventProcessorsFromChartSettings() {
        IChartSettings chartSettings = this.baseChart.getChartSettings();
        for (IHandledEventProcessor handledEventProcessor : chartSettings.getHandledEventProcessors()) {
            this.baseChart.addEventProcessor(handledEventProcessor);
        }
    }

    private void addMenuItemsFromExtensionPoint() {
        IExtensionRegistry extensionRegistry = RegistryFactory.getRegistry();
        if (extensionRegistry != null) {
            IConfigurationElement[] configurationElements;
            IConfigurationElement[] iConfigurationElementArray = configurationElements = extensionRegistry.getConfigurationElementsFor(EXTENSION_POINT_MENU_ITEMS);
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    IChartMenuEntry menuEntry = (IChartMenuEntry)element.createExecutableExtension(EXTENSION_POINT_MENU_ENTRY);
                    this.addMenuEntry(menuEntry);
                }
                catch (CoreException e) {
                    System.out.println((Object)e);
                }
                ++n2;
            }
        }
    }

    private void setSliderVisibility(IChartSettings chartSettings) {
        GridData gridDataVertical = (GridData)this.sliderVertical.getLayoutData();
        gridDataVertical.exclude = !chartSettings.isVerticalSliderVisible();
        this.sliderVertical.setVisible(chartSettings.isVerticalSliderVisible());
        GridData gridDataHorizontal = (GridData)this.sliderHorizontal.getLayoutData();
        gridDataHorizontal.exclude = !chartSettings.isHorizontalSliderVisible();
        this.sliderHorizontal.setVisible(chartSettings.isHorizontalSliderVisible());
        this.layout(false);
    }

    private void updateRangeHintPaintListener() {
        if (this.rangeHintPaintListener != null) {
            this.baseChart.removePaintListener(this.rangeHintPaintListener);
        }
        this.rangeHintPaintListener = new RangeHintPaintListener();
        this.baseChart.addPaintListener(this.rangeHintPaintListener);
    }

    private void showRangeSelector(boolean showRangeSelector) {
        GridData gridData = (GridData)this.rangeSelector.getLayoutData();
        gridData.exclude = !showRangeSelector;
        this.rangeSelector.setVisible(showRangeSelector);
        Composite parent = this.rangeSelector.getParent();
        parent.layout(false);
        parent.redraw();
    }

    private void setRangeInfoVisibility(IChartSettings chartSettings) {
        boolean isVisible = chartSettings.isEnableRangeSelector() && chartSettings.isShowRangeSelectorInitially();
        GridData gridData = (GridData)this.rangeSelector.getLayoutData();
        gridData.exclude = !isVisible;
        this.rangeSelector.setVisible(isVisible);
        this.layout(true);
    }

    private void resetSlider() {
        this.setSliderSelection(true);
        this.updateLinkedCharts();
    }

    private void setSliderSelection(boolean calculateIncrement) {
        IAxis xAxis = this.baseChart.getAxisSet().getXAxis(0);
        IAxis yAxis = this.baseChart.getAxisSet().getYAxis(0);
        if (xAxis != null && yAxis != null) {
            int maxX = 1000000;
            int maxY = 1000000;
            double deltaX = this.baseChart.getMaxX() - this.baseChart.getMinX();
            double deltaY = this.baseChart.getMaxY() - this.baseChart.getMinY();
            if (deltaX > 0.0 && deltaY > 0.0) {
                double coeffX = (double)maxX / deltaX;
                double coeffY = (double)maxY / deltaY;
                double minRangeX = (xAxis.getRange().lower - this.baseChart.getMinX()) * coeffX;
                double maxRangeX = (xAxis.getRange().upper - this.baseChart.getMinX()) * coeffX;
                double thumbRangeX = maxRangeX - minRangeX;
                if (Double.isNaN(minRangeX) || Double.isNaN(maxRangeX)) {
                    return;
                }
                double minRangeY = (yAxis.getRange().lower - this.baseChart.getMinY()) * coeffY;
                double maxRangeY = (yAxis.getRange().upper - this.baseChart.getMaxY()) * coeffY;
                double thumbRangeY = maxRangeY - minRangeY;
                if (Double.isNaN(minRangeY) || Double.isNaN(maxRangeY)) {
                    return;
                }
                int minSelectionX = minRangeX < 0.0 ? 0 : (int)minRangeX;
                int thumbSelectionX = thumbRangeX < 1.0 ? 1 : (int)thumbRangeX;
                int minSelectionY = minRangeY < 0.0 ? 0 : (int)minRangeY;
                int thumbSelectionY = thumbRangeY < 1.0 ? 1 : (int)thumbRangeY;
                boolean isHorizontal = this.isOrientationHorizontal();
                this.sliderVertical.setMinimum(0);
                this.sliderVertical.setMaximum(isHorizontal ? maxY : maxX);
                this.sliderVertical.setThumb(isHorizontal ? thumbSelectionY : thumbSelectionX);
                this.sliderVertical.setSelection(isHorizontal ? minSelectionY : minSelectionX);
                this.sliderHorizontal.setMinimum(0);
                this.sliderHorizontal.setMaximum(isHorizontal ? maxX : maxY);
                this.sliderHorizontal.setThumb(isHorizontal ? thumbSelectionX : thumbSelectionY);
                this.sliderHorizontal.setSelection(isHorizontal ? minSelectionX : minSelectionY);
                if (calculateIncrement) {
                    int incrementX = this.calculateIncrement(maxX, this.baseChart.getSeriesMaxDataPoints());
                    int incrementY = this.calculateIncrement(maxY, this.baseChart.getSeriesMaxDataPoints());
                    if (incrementX >= 1 && incrementY >= 1) {
                        this.sliderHorizontal.setIncrement(isHorizontal ? incrementX : incrementY);
                        this.sliderHorizontal.setPageIncrement(isHorizontal ? incrementX : incrementY);
                        this.sliderVertical.setIncrement(isHorizontal ? incrementY : incrementX);
                        this.sliderVertical.setPageIncrement(isHorizontal ? incrementY : incrementX);
                    }
                }
                this.displayRangeInfo(xAxis, yAxis);
            }
        }
    }

    private boolean isOrientationHorizontal() {
        return this.baseChart.getOrientation() == 256;
    }

    private int calculateIncrement(double selection, double length) {
        if (length == 0.0) {
            return 0;
        }
        int increment = (int)(selection / length);
        return increment < 1 || Double.isNaN(increment) ? 1 : increment;
    }

    private Range calculateShiftedRange(Range range, Slider slider, int sliderOrientation) {
        int maxX = 1000000;
        int maxY = 1000000;
        double deltaX = this.baseChart.getMaxX() - this.baseChart.getMinX();
        double deltaY = this.baseChart.getMaxY() - this.baseChart.getMinY();
        if (deltaX > 0.0 && deltaY > 0.0) {
            double coeffX = (double)maxX / deltaX;
            double coeffY = (double)maxY / deltaY;
            double shiftX = -coeffX * this.baseChart.getMinX();
            double shiftY = -coeffY * this.baseChart.getMinY();
            if (coeffX != 0.0 && !Double.isNaN(shiftX) && coeffY != 0.0 && !Double.isNaN(shiftY)) {
                int selection = slider.getSelection();
                boolean isChartHorizontal = this.isOrientationHorizontal();
                double min = sliderOrientation == 256 && isChartHorizontal || sliderOrientation == 512 && !isChartHorizontal ? ((double)selection - shiftX) / coeffX : ((double)selection - shiftY) / coeffY;
                double max = min + (range.upper - range.lower);
                if (!Double.isNaN(min) && !Double.isNaN(max)) {
                    return new Range(min, max);
                }
            }
        }
        return null;
    }

    private void addPrimaryAxisX(IChartSettings chartSettings) {
        IAxisSet axisSet = this.baseChart.getAxisSet();
        IAxis xAxisPrimary = axisSet.getXAxis(0);
        IPrimaryAxisSettings primaryAxisSettings = chartSettings.getPrimaryAxisSettingsX();
        this.setAxisSettings(xAxisPrimary, primaryAxisSettings);
        this.baseChart.putXAxisSettings(0, primaryAxisSettings);
    }

    private void addPrimaryAxisY(IChartSettings chartSettings) {
        IAxisSet axisSet = this.baseChart.getAxisSet();
        IAxis yAxisPrimary = axisSet.getYAxis(0);
        IPrimaryAxisSettings primaryAxisSettings = chartSettings.getPrimaryAxisSettingsY();
        this.setAxisSettings(yAxisPrimary, primaryAxisSettings);
        this.baseChart.putYAxisSettings(0, primaryAxisSettings);
    }

    private void addSecondaryAxesX(IChartSettings chartSettings) {
        IAxisSet axisSet = this.baseChart.getAxisSet();
        int[] nArray = axisSet.getXAxisIds();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            if (id != 0) {
                axisSet.deleteXAxis(id);
            }
            ++n2;
        }
        this.baseChart.removeXAxisSettings();
        for (ISecondaryAxisSettings secondaryAxisSettings : chartSettings.getSecondaryAxisSettingsListX()) {
            int xAxisId = axisSet.createXAxis();
            IAxis xAxisSecondary = axisSet.getXAxis(xAxisId);
            this.setAxisSettings(xAxisSecondary, secondaryAxisSettings);
            this.baseChart.putXAxisSettings(xAxisId, secondaryAxisSettings);
        }
    }

    private void addSecondaryAxesY(IChartSettings chartSettings) {
        IAxisSet axisSet = this.baseChart.getAxisSet();
        int[] nArray = axisSet.getYAxisIds();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            if (id != 0) {
                axisSet.deleteYAxis(id);
            }
            ++n2;
        }
        this.baseChart.removeYAxisSettings();
        for (ISecondaryAxisSettings secondaryAxisSettings : chartSettings.getSecondaryAxisSettingsListY()) {
            int yAxisId = axisSet.createYAxis();
            IAxis yAxisSecondary = axisSet.getYAxis(yAxisId);
            this.setAxisSettings(yAxisSecondary, secondaryAxisSettings);
            this.baseChart.putYAxisSettings(yAxisId, secondaryAxisSettings);
        }
    }

    private void setAxisSettings(IAxis axis, IAxisSettings axisSettings) {
        if (axis != null && axisSettings != null) {
            String axisText = axisSettings.getTitle();
            ITitle title = axis.getTitle();
            title.setText(axisText);
            title.setVisible(axisSettings.isVisible() && axisSettings.isTitleVisible());
            title.setFont(axisSettings.getTitleFont());
            IAxisTick axisTick = axis.getTick();
            axisTick.setFormat((Format)axisSettings.getDecimalFormat());
            axisTick.setVisible(axisSettings.isVisible());
            IGrid grid = axis.getGrid();
            grid.setForeground(axisSettings.getGridColor());
            grid.setStyle(axisSettings.getGridLineStyle());
            axis.setPosition(axisSettings.getPosition());
            Color color = axisSettings.getColor();
            if (color != null) {
                title.setForeground(color);
                axisTick.setForeground(color);
            }
            Font font = title.getFont();
            int length = axisText.length() - 1;
            StyleRange styleRange = new StyleRange();
            styleRange.length = length > 0 ? length : 0;
            styleRange.background = this.baseChart.getBackground();
            styleRange.foreground = color != null ? color : this.baseChart.getForeground();
            styleRange.font = font;
            styleRange.rise = this.getAxisExtraSpaceTitle(axis, axisSettings);
            title.setStyleRanges(new StyleRange[]{styleRange});
            axis.enableLogScale(axisSettings.isEnableLogScale());
            axis.setReversed(axisSettings.isReversed());
            if (axisSettings instanceof IPrimaryAxisSettings) {
                IPrimaryAxisSettings primaryAxisSettings = (IPrimaryAxisSettings)axisSettings;
                axis.enableLogScale(primaryAxisSettings.isEnableLogScale());
                if (axis.getDirection() == IAxis.Direction.X) {
                    axis.enableCategory(primaryAxisSettings.isEnableCategory());
                    axis.setCategorySeries(primaryAxisSettings.getCategorySeries());
                }
            }
        }
    }

    private int getAxisExtraSpaceTitle(IAxis axis, IAxisSettings axisSettings) {
        int extraSpaceTitle = axisSettings.getExtraSpaceTitle();
        int orientation = this.getChartSettings().getOrientation();
        IAxis.Direction direction = axis.getDirection();
        if (direction.equals((Object)IAxis.Direction.X)) {
            if (axisSettings.getPosition().equals((Object)IAxis.Position.Primary)) {
                extraSpaceTitle *= -1;
            }
        } else if (axisSettings.getPosition().equals((Object)IAxis.Position.Secondary)) {
            extraSpaceTitle *= -1;
        }
        if (orientation == 512) {
            extraSpaceTitle *= -1;
        }
        return extraSpaceTitle;
    }

    private void fireUpdateCustomRangeSelectionHandlers(Event event) {
        this.baseChart.fireUpdateCustomRangeSelectionHandlers(event);
        this.updateLinkedCharts();
    }

    private void displayRangeInfo(IAxis xAxis, IAxis yAxis) {
        this.rangeSelector.adjustRanges(true);
    }

    private void initialize() {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.createSliderVertical(composite);
        this.createChart(composite);
        this.createSliderHorizontal(composite);
    }

    private void createSliderVertical(Composite parent) {
        this.sliderVertical = new Slider(parent, 512);
        this.sliderVertical.setLayoutData((Object)new GridData(1040));
        this.sliderVertical.setOrientation(0x4000000);
        this.sliderVertical.setVisible(true);
        this.sliderVertical.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Range range;
                IAxis xAxis = ScrollableChart.this.baseChart.getAxisSet().getXAxis(0);
                IAxis yAxis = ScrollableChart.this.baseChart.getAxisSet().getYAxis(0);
                if (xAxis != null && yAxis != null && (range = ScrollableChart.this.calculateShiftedRange(yAxis.getRange(), ScrollableChart.this.sliderVertical, 512)) != null) {
                    if (ScrollableChart.this.isOrientationHorizontal()) {
                        if (ScrollableChart.this.baseChart.isRangeValid(range)) {
                            yAxis.setRange(range);
                            ScrollableChart.this.baseChart.adjustMinMaxRange(yAxis);
                            ScrollableChart.this.adjustSecondaryYAxes();
                        }
                    } else if (ScrollableChart.this.baseChart.isRangeValid(range)) {
                        xAxis.setRange(range);
                        ScrollableChart.this.baseChart.adjustMinMaxRange(xAxis);
                        ScrollableChart.this.adjustSecondaryXAxes();
                    }
                    ScrollableChart.this.displayRangeInfo(xAxis, yAxis);
                    ScrollableChart.this.fireUpdateCustomRangeSelectionHandlers(event);
                    ScrollableChart.this.baseChart.redraw();
                }
            }
        });
    }

    private void createChart(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(1, true));
        this.createRangeInfoUI(composite);
        this.createBaseChart(composite);
    }

    private void createRangeInfoUI(Composite parent) {
        this.rangeSelector = new RangeSelector(parent, 0, this);
        this.rangeSelector.setLayoutData(new GridData(768));
    }

    private void createBaseChart(Composite parent) {
        this.baseChart = new BaseChart(parent, 0);
        this.baseChart.setLayoutData(new GridData(1808));
        this.baseChart.addCustomRangeSelectionHandler(new ICustomSelectionHandler(){

            @Override
            public void handleUserSelection(Event event) {
                ScrollableChart.this.setSliderSelection(false);
                if (ScrollableChart.this.getChartSettings().isEnableRangeSelector()) {
                    ScrollableChart.this.rangeSelector.adjustRanges(false);
                }
                ScrollableChart.this.updateLinkedCharts();
            }
        });
        this.baseChart.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                IChartSettings chartSettings = ScrollableChart.this.baseChart.getChartSettings();
                if (chartSettings.isEnableRangeSelector() && !ScrollableChart.this.rangeSelector.isVisible() && e.y <= 47) {
                    ScrollableChart.this.showRangeSelectorHint = ScrollableChart.this.enableRangeSelectorHint;
                    ScrollableChart.this.showRangeSelector(ScrollableChart.this.showRangeSelectorHint);
                }
            }
        });
        this.rangeHintPaintListener = new RangeHintPaintListener();
        this.baseChart.addPaintListener(this.rangeHintPaintListener);
        IPlotArea area = this.baseChart.getPlotArea();
        if (area instanceof Control) {
            Control plotArea = (Control)area;
            plotArea.addListener(1, (Listener)this);
            plotArea.addListener(2, (Listener)this);
            plotArea.addListener(5, (Listener)this);
            plotArea.addListener(3, (Listener)this);
            plotArea.addListener(4, (Listener)this);
            plotArea.addListener(37, (Listener)this);
            plotArea.addListener(8, (Listener)this);
            plotArea.addListener(11, (Listener)this);
            plotArea.addPaintListener((PaintListener)this);
        }
    }

    private void createSliderHorizontal(Composite parent) {
        this.sliderHorizontal = new Slider(parent, 256);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.sliderHorizontal.setLayoutData((Object)gridData);
        this.sliderHorizontal.setOrientation(0x2000000);
        this.sliderHorizontal.setVisible(true);
        this.sliderHorizontal.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Range range;
                IAxis xAxis = ScrollableChart.this.baseChart.getAxisSet().getXAxis(0);
                IAxis yAxis = ScrollableChart.this.baseChart.getAxisSet().getYAxis(0);
                if (xAxis != null && yAxis != null && (range = ScrollableChart.this.calculateShiftedRange(xAxis.getRange(), ScrollableChart.this.sliderHorizontal, 256)) != null) {
                    if (ScrollableChart.this.isOrientationHorizontal()) {
                        if (ScrollableChart.this.baseChart.isRangeValid(range)) {
                            xAxis.setRange(range);
                            ScrollableChart.this.baseChart.adjustMinMaxRange(xAxis);
                            ScrollableChart.this.adjustSecondaryXAxes();
                        }
                    } else if (ScrollableChart.this.baseChart.isRangeValid(range)) {
                        yAxis.setRange(range);
                        ScrollableChart.this.baseChart.adjustMinMaxRange(yAxis);
                        ScrollableChart.this.adjustSecondaryYAxes();
                    }
                    ScrollableChart.this.displayRangeInfo(xAxis, yAxis);
                    ScrollableChart.this.fireUpdateCustomRangeSelectionHandlers(event);
                    ScrollableChart.this.baseChart.redraw();
                }
            }
        });
    }

    private void updateLinkedCharts() {
        IAxisSet axisSet = this.baseChart.getAxisSet();
        Range rangeX = axisSet.getXAxis(0).getRange();
        Range rangeY = axisSet.getYAxis(0).getRange();
        for (ScrollableChart linkedScrollableChart : this.linkedScrollableCharts) {
            IAxisSet axisSetLinked = linkedScrollableChart.getBaseChart().getAxisSet();
            axisSetLinked.getXAxis(0).setRange(rangeX);
            axisSetLinked.getYAxis(0).setRange(rangeY);
            linkedScrollableChart.getBaseChart().adjustSecondaryAxes();
            linkedScrollableChart.getBaseChart().redraw();
            linkedScrollableChart.setSliderSelection(false);
            if (!linkedScrollableChart.getChartSettings().isEnableRangeSelector()) continue;
            linkedScrollableChart.getRangeSelector().adjustRanges(false);
        }
    }

    private void createPopupMenu() {
        IPlotArea area = this.baseChart.getPlotArea();
        if (area instanceof Control) {
            Control plotArea = (Control)area;
            Menu menu = new Menu(plotArea);
            Menu m = plotArea.getMenu();
            if (m != null) {
                m.dispose();
            }
            plotArea.setMenu(menu);
            this.createMenuItems(menu);
        }
    }

    private void addMenuEntry(IChartMenuEntry menuEntry) {
        if (menuEntry != null) {
            String category = menuEntry.getCategory();
            Set<IChartMenuEntry> menuEntries = this.categoryMenuEntriesMap.get(category);
            if (menuEntries == null) {
                menuEntries = new HashSet<IChartMenuEntry>();
                this.categoryMenuEntriesMap.put(category, menuEntries);
            }
            menuEntries.add(menuEntry);
            this.menuEntryMap.put(menuEntry.getName(), menuEntry);
        }
    }

    private void createMenuItems(Menu menu) {
        ArrayList<String> categories = new ArrayList<String>(this.categoryMenuEntriesMap.keySet());
        Collections.sort(categories);
        Iterator iterator = categories.iterator();
        while (iterator.hasNext()) {
            String category = (String)iterator.next();
            Set<IChartMenuEntry> menuEntries = this.categoryMenuEntriesMap.get(category);
            this.createMenuCategory(menu, category, menuEntries);
            if (!iterator.hasNext()) continue;
            new MenuItem(menu, 2);
        }
    }

    private void createMenuCategory(Menu menu, String category, Set<IChartMenuEntry> menuEntries) {
        MenuItem menuItem;
        Menu subMenu;
        if (category.equals("")) {
            subMenu = menu;
        } else {
            menuItem = new MenuItem(menu, 64);
            menuItem.setText(category);
            subMenu = new Menu(menuItem);
            menuItem.setMenu(subMenu);
        }
        for (Map.Entry<String, IChartMenuEntry> name : this.getSortedNames(menuEntries).entrySet()) {
            menuItem = new MenuItem(subMenu, 8);
            menuItem.setText(name.getKey());
            final IChartMenuEntry menuEntry = name.getValue();
            menuItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    menuEntry.execute(ScrollableChart.this.getShell(), ScrollableChart.this);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            String toolTipText = menuEntry.getToolTipText();
            if (toolTipText == null) continue;
            menuItem.setToolTipText(toolTipText);
        }
    }

    private Map<String, IChartMenuEntry> getSortedNames(Set<IChartMenuEntry> menuEntries) {
        TreeMap<String, IChartMenuEntry> names = new TreeMap<String, IChartMenuEntry>(String.CASE_INSENSITIVE_ORDER);
        for (IChartMenuEntry menuEntry : menuEntries) {
            if (!menuEntry.isEnabled(this)) continue;
            names.put(menuEntry.getName(), menuEntry);
        }
        return names;
    }

    private class RangeHintPaintListener
    implements PaintListener {
        private RangeHintPaintListener() {
        }

        public void paintControl(PaintEvent e) {
            IChartSettings chartSettings = ScrollableChart.this.baseChart.getChartSettings();
            if (!ScrollableChart.this.rangeSelector.isVisible() && chartSettings.isEnableRangeSelector() && ScrollableChart.this.showRangeSelectorHint) {
                int lineWidth = 1;
                Rectangle rectangle = ScrollableChart.this.baseChart.getBounds();
                int width = rectangle.width - lineWidth;
                e.gc.setForeground(chartSettings.getColorHintRangeSelector());
                e.gc.setLineWidth(lineWidth);
                Rectangle rectangleInfo = new Rectangle(0, 0, width, 26);
                e.gc.drawRectangle(rectangleInfo);
                ITitle title = ScrollableChart.this.getBaseChart().getTitle();
                if (title.getForeground().equals((Object)ScrollableChart.this.baseChart.getBackground())) {
                    String label = Messages.getString(Messages.DOUBLE_CLICK_TO_SHOW_RANGE_INFO);
                    Point labelSize = e.gc.textExtent(label);
                    e.gc.drawText(label, (int)((double)width / 2.0 - (double)labelSize.x / 2.0), 5, true);
                }
                ScrollableChart.this.getBaseChart().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            System.out.println(e);
                        }
                        ScrollableChart.this.showRangeSelectorHint = false;
                        ScrollableChart.this.baseChart.redraw();
                    }
                });
            }
        }
    }
}

