/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.preferences;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.registry.IGrammarDefinition;
import org.eclipse.tm4e.registry.IGrammarRegistryManager;
import org.eclipse.tm4e.registry.TMEclipseRegistryPlugin;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.internal.TMUIMessages;
import org.eclipse.tm4e.ui.internal.widgets.ColumnSelectionAdapter;
import org.eclipse.tm4e.ui.internal.widgets.ColumnViewerComparator;
import org.eclipse.tm4e.ui.internal.widgets.GrammarDefinitionContentProvider;
import org.eclipse.tm4e.ui.internal.widgets.GrammarDefinitionLabelProvider;
import org.eclipse.tm4e.ui.internal.widgets.TMViewer;
import org.eclipse.tm4e.ui.internal.widgets.ThemeContentProvider;
import org.eclipse.tm4e.ui.internal.widgets.ThemeLabelProvider;
import org.eclipse.tm4e.ui.themes.ITheme;
import org.eclipse.tm4e.ui.themes.IThemeManager;
import org.eclipse.tm4e.ui.themes.Theme;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.service.prefs.BackingStoreException;

public class ThemePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "org.eclipse.tm4e.ui.preferences.ThemePreferencePage";
    private TableViewer themeViewer;
    private Button themeRemoveButton;
    private ComboViewer grammarViewer;
    private TMViewer previewViewer;
    private final IGrammarRegistryManager grammarRegistryManager;
    private final IThemeManager themeManager;
    private Button darkThemeButton;
    private Button defaultThemeButton;
    private ITheme selectedTheme;

    public ThemePreferencePage() {
        this.setDescription(TMUIMessages.ThemePreferencePage_description);
        this.grammarRegistryManager = TMEclipseRegistryPlugin.getGrammarRegistryManager();
        this.themeManager = TMUIPlugin.getThemeManager();
    }

    protected Control createContents(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Composite innerParent = new Composite(parent, 0);
        GridLayout innerLayout = new GridLayout();
        innerLayout.numColumns = 2;
        innerLayout.marginHeight = 0;
        innerLayout.marginWidth = 0;
        innerParent.setLayout((Layout)innerLayout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        innerParent.setLayoutData((Object)gd);
        this.createThemesContent(innerParent);
        this.createThemeDetailContent(innerParent);
        this.createPreviewContent(innerParent);
        this.grammarViewer.setInput((Object)this.grammarRegistryManager);
        if (this.grammarViewer.getCombo().getItemCount() > 0) {
            this.grammarViewer.getCombo().select(0);
        }
        this.themeViewer.setInput((Object)this.themeManager);
        Dialog.applyDialogFont((Control)parent);
        innerParent.layout();
        return parent;
    }

    private void createThemesContent(Composite parent) {
        Composite tableComposite = new Composite(parent, 0);
        GridData data = new GridData(1808);
        data.widthHint = 360;
        data.heightHint = this.convertHeightInCharsToPixels(10);
        tableComposite.setLayoutData((Object)data);
        TableColumnLayout columnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)columnLayout);
        Table table = new Table(tableComposite, 68354);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GC gc = new GC((Drawable)this.getShell());
        gc.setFont(JFaceResources.getDialogFont());
        ColumnViewerComparator viewerComparator = new ColumnViewerComparator();
        this.themeViewer = new TableViewer(table);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(TMUIMessages.ThemePreferencePage_column_name);
        int minWidth = this.computeMinimumColumnWidth(gc, TMUIMessages.ThemePreferencePage_column_name);
        columnLayout.setColumnData((Widget)column1, (ColumnLayoutData)new ColumnWeightData(2, minWidth, true));
        column1.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(column1, this.themeViewer, 0, viewerComparator));
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(TMUIMessages.ThemePreferencePage_column_path);
        minWidth = this.computeMinimumColumnWidth(gc, TMUIMessages.ThemePreferencePage_column_path);
        columnLayout.setColumnData((Widget)column2, (ColumnLayoutData)new ColumnWeightData(2, minWidth, true));
        column2.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(column2, this.themeViewer, 1, viewerComparator));
        TableColumn column3 = new TableColumn(table, 0);
        column3.setText(TMUIMessages.ThemePreferencePage_column_pluginId);
        minWidth = this.computeMinimumColumnWidth(gc, TMUIMessages.ThemePreferencePage_column_pluginId);
        columnLayout.setColumnData((Widget)column3, (ColumnLayoutData)new ColumnWeightData(2, minWidth, true));
        column3.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(column3, this.themeViewer, 2, viewerComparator));
        gc.dispose();
        this.themeViewer.setLabelProvider((IBaseLabelProvider)new ThemeLabelProvider());
        this.themeViewer.setContentProvider((IContentProvider)new ThemeContentProvider());
        this.themeViewer.setComparator((ViewerComparator)viewerComparator);
        this.themeViewer.addSelectionChangedListener(e -> {
            this.selectedTheme = (ITheme)((IStructuredSelection)this.themeViewer.getSelection()).getFirstElement();
            if (this.selectedTheme != null) {
                this.darkThemeButton.setSelection(this.selectedTheme.isDark());
                this.defaultThemeButton.setSelection(this.selectedTheme.isDefault());
                this.themeRemoveButton.setEnabled(this.selectedTheme.getPluginId() == null);
            }
            this.preview();
        });
        table.setSortColumn(column1);
        table.setSortDirection(viewerComparator.getDirection());
        BidiUtils.applyTextDirection((Control)this.themeViewer.getControl(), (String)"default");
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        Button themeNewButton = new Button(buttons, 8);
        themeNewButton.setText(TMUIMessages.Button_new);
        themeNewButton.setLayoutData((Object)ThemePreferencePage.getButtonGridData(themeNewButton));
        themeNewButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ITheme newTheme = this.addTheme();
                if (newTheme != null) {
                    ThemePreferencePage.this.themeManager.registerTheme(newTheme);
                    ThemePreferencePage.this.selectedTheme = newTheme;
                    ThemePreferencePage.this.themeViewer.refresh();
                    ThemePreferencePage.this.themeViewer.setSelection((ISelection)new StructuredSelection((Object)newTheme));
                }
            }

            private ITheme addTheme() {
                FileDialog dialog = new FileDialog(ThemePreferencePage.this.getShell());
                dialog.setText("Select textmate theme file");
                dialog.setFilterExtensions(new String[]{"*.css"});
                String res = dialog.open();
                if (res == null) {
                    return null;
                }
                File file = new File(res);
                String name = file.getName().substring(0, file.getName().length() - ".css".length());
                return new Theme(name, file.getAbsolutePath(), name, false, false);
            }
        });
        this.themeRemoveButton = new Button(buttons, 8);
        this.themeRemoveButton.setText(TMUIMessages.Button_remove);
        this.themeRemoveButton.setLayoutData((Object)ThemePreferencePage.getButtonGridData(this.themeRemoveButton));
        this.themeRemoveButton.addListener(13, e -> {
            this.themeManager.unregisterTheme(this.selectedTheme);
            this.themeViewer.refresh();
        });
    }

    private void createThemeDetailContent(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        parent.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        parent.setLayout((Layout)layout);
        this.darkThemeButton = new Button(parent, 32);
        this.darkThemeButton.setText(TMUIMessages.ThemePreferencePage_darkThemeButton_label);
        this.darkThemeButton.setEnabled(false);
        this.defaultThemeButton = new Button(parent, 32);
        this.defaultThemeButton.setText(TMUIMessages.ThemePreferencePage_defaultThemeButton_label);
        this.defaultThemeButton.setEnabled(false);
    }

    private void createPreviewContent(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        parent.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        this.previewViewer = this.doCreateViewer(parent);
    }

    private int computeMinimumColumnWidth(GC gc, String string) {
        return gc.stringExtent((String)string).x + 10;
    }

    private static GridData getButtonGridData(Button button) {
        GridData data = new GridData(768);
        return data;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setTitle(TMUIMessages.ThemePreferencePage_title);
        }
    }

    public void init(IWorkbench workbench) {
    }

    private void preview() {
        IStructuredSelection selection = (IStructuredSelection)this.themeViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        ITheme theme = (ITheme)selection.getFirstElement();
        selection = (IStructuredSelection)this.grammarViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        IGrammarDefinition definition = (IGrammarDefinition)selection.getFirstElement();
        IGrammar grammar = this.grammarRegistryManager.getGrammarForScope(definition.getScopeName());
        this.previewViewer.setTheme(theme);
        this.previewViewer.setGrammar(grammar);
    }

    private TMViewer doCreateViewer(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(TMUIMessages.ThemePreferencePage_preview);
        GridData data = new GridData();
        label.setLayoutData((Object)data);
        this.grammarViewer = new ComboViewer(parent);
        this.grammarViewer.setContentProvider((IContentProvider)new GrammarDefinitionContentProvider());
        this.grammarViewer.setLabelProvider((IBaseLabelProvider)new GrammarDefinitionLabelProvider());
        this.grammarViewer.addSelectionChangedListener(e -> this.preview());
        this.grammarViewer.getControl().setLayoutData((Object)new GridData(768));
        TMViewer viewer = this.createViewer(parent);
        Control control = viewer.getControl();
        data = new GridData(1808);
        data.horizontalSpan = 2;
        data.heightHint = this.convertHeightInCharsToPixels(5);
        control.setLayoutData((Object)data);
        return viewer;
    }

    protected TMViewer createViewer(Composite parent) {
        return new TMViewer(parent, null, null, false, 2816);
    }

    public boolean performOk() {
        try {
            this.themeManager.save();
            this.grammarRegistryManager.save();
            return true;
        }
        catch (BackingStoreException e) {
            TMUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.tm4e.ui", e.getMessage(), (Throwable)e));
            return false;
        }
    }
}

