/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.clientserver.java;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class EnhancedClassLoader
extends ClassLoader {
    private String rootPath;

    public EnhancedClassLoader(String rootPath) {
        this.setRootPath(rootPath);
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        try {
            byte[] b = this.loadClassData(name);
            return this.defineClass(name, b, 0, b.length);
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException();
        }
    }

    private byte[] loadClassData(String name) throws IOException {
        String parentPath = this.rootPath;
        String fileSep = System.getProperty("file.separator");
        if (!parentPath.endsWith(fileSep)) {
            parentPath = String.valueOf(parentPath) + fileSep;
        }
        StringBuffer buf = new StringBuffer(parentPath);
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c == '.') {
                buf.append(fileSep);
            } else {
                buf.append(c);
            }
            ++i;
        }
        String filePath = buf.append(".class").toString();
        File file = new File(filePath);
        FileInputStream fileStream = new FileInputStream(file);
        int length = (int)file.length();
        byte[] classData = new byte[length];
        int bytesRead = 0;
        int offset = 0;
        int available = fileStream.available();
        while (available > 0) {
            int bytesToRead = Math.min(available, 256000);
            bytesRead = fileStream.read(classData, offset, bytesToRead);
            if (bytesRead == -1) break;
            offset += bytesRead;
            available = fileStream.available();
        }
        return classData;
    }
}

