/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.subsystems.shells.local.model;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.shells.IHostOutput;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IHostShellChangeEvent;
import org.eclipse.rse.services.shells.ParsedOutput;
import org.eclipse.rse.services.shells.Patterns;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.shells.core.model.RemoteError;
import org.eclipse.rse.subsystems.shells.core.model.RemoteOutput;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteOutput;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.ServiceCommandShell;

public class LocalServiceCommandShell
extends ServiceCommandShell {
    private Patterns _patterns = new Patterns();
    private String _workingDir;
    private IRemoteFileSubSystem _fs;

    public LocalServiceCommandShell(IRemoteCmdSubSystem cmdSS, IHostShell hostShell) {
        super(cmdSS, hostShell);
        this._patterns.update("cmd");
        ISubSystem[] sses = cmdSS.getHost().getSubSystems();
        int i = 0;
        while (i < sses.length) {
            if (sses[i] instanceof IRemoteFileSubSystem) {
                this._fs = (IRemoteFileSubSystem)sses[i];
            }
            ++i;
        }
    }

    public Object getContext() {
        String workingDir = this._workingDir;
        if (workingDir != null && workingDir.length() > 0) {
            try {
                return this._fs.getRemoteFileObject(workingDir, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public String getContextString() {
        return this._workingDir;
    }

    public void shellOutputChanged(IHostShellChangeEvent event) {
        IHostOutput[] lines = event.getLines();
        IRemoteOutput[] outputs = new IRemoteOutput[lines.length];
        int i = 0;
        while (i < lines.length) {
            String line = lines[i].getString();
            ParsedOutput parsedMsg = null;
            try {
                parsedMsg = this._patterns.matchLine(line);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            Object output = null;
            String type = "stdout";
            if (parsedMsg != null) {
                type = parsedMsg.type;
            }
            output = event.isError() ? new RemoteError((Object)this, type) : new RemoteOutput((Object)this, type);
            output.setText(line);
            if (parsedMsg != null) {
                String file = parsedMsg.file;
                if (type.equals("prompt")) {
                    this._workingDir = file;
                    output.setAbsolutePath(this._workingDir);
                } else {
                    output.setAbsolutePath(String.valueOf(this._workingDir) + File.separatorChar + file);
                }
            }
            this.addOutput(output);
            outputs[i] = output;
            ++i;
        }
        this.notifyOutputChanged(outputs, false);
    }

    public void writeToShell(String cmd) {
        this._patterns.update(cmd);
        super.writeToShell(cmd);
    }
}

