/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.dom.JdtASTMatcher;
import org.eclipse.jdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.jdt.internal.corext.fix.ConvertLoopOperation;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroupCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.text.edits.TextEditGroup;

public class ConvertForLoopOperation
extends ConvertLoopOperation {
    private static final String LENGTH_QUERY = "length";
    private static final String SIZE_QUERY = "size";
    private static final String GET_QUERY = "get";
    private static final String ISEMPTY_QUERY = "isEmpty";
    private IVariableBinding fIndexBinding;
    private IVariableBinding fLengthBinding;
    private IBinding fArrayBinding;
    private Expression fArrayAccess;
    private VariableDeclarationFragment fElementDeclaration;
    private boolean fMakeFinal;
    private boolean fIsCollection;
    private IMethodBinding fSizeMethodBinding;
    private IMethodBinding fGetMethodBinding;
    private MethodInvocation fSizeMethodAccess;
    private boolean fCheckLoopVarUsed;
    private boolean fLoopVarReferenced;

    public ConvertForLoopOperation(ForStatement forStatement) {
        this(forStatement, new String[0], false, false);
    }

    public ConvertForLoopOperation(ForStatement forStatement, String[] usedNames, boolean makeFinal, boolean checkLoopVarUsed) {
        super(forStatement, usedNames);
        this.fMakeFinal = makeFinal;
        this.fCheckLoopVarUsed = checkLoopVarUsed;
    }

    @Override
    public IStatus satisfiesPreconditions() {
        ForStatement statement = this.getForStatement();
        CompilationUnit ast = (CompilationUnit)statement.getRoot();
        IJavaElement javaElement = ast.getJavaElement();
        if (javaElement == null) {
            return ERROR_STATUS;
        }
        if (!JavaModelUtil.is50OrHigher(javaElement.getJavaProject())) {
            return ERROR_STATUS;
        }
        if (!this.validateInitializers(statement)) {
            return ERROR_STATUS;
        }
        if (!this.validateExpression(statement)) {
            return ERROR_STATUS;
        }
        if (!this.validateUpdaters(statement)) {
            return ERROR_STATUS;
        }
        if (!this.validateBody(statement)) {
            return ERROR_STATUS;
        }
        if (this.fCheckLoopVarUsed && !this.fLoopVarReferenced) {
            return ERROR_STATUS;
        }
        return Status.OK_STATUS;
    }

    private boolean validateInitializers(ForStatement statement) {
        List initializers = statement.initializers();
        if (initializers.size() != 1) {
            return false;
        }
        Expression expression = (Expression)initializers.get(0);
        if (!(expression instanceof VariableDeclarationExpression)) {
            return false;
        }
        VariableDeclarationExpression declaration = (VariableDeclarationExpression)expression;
        ITypeBinding declarationBinding = declaration.resolveTypeBinding();
        if (declarationBinding == null) {
            return false;
        }
        if (!declarationBinding.isPrimitive()) {
            return false;
        }
        if (!PrimitiveType.INT.toString().equals(declarationBinding.getQualifiedName())) {
            return false;
        }
        List fragments = declaration.fragments();
        if (fragments.size() == 1) {
            IVariableBinding indexBinding = this.getIndexBindingFromFragment((VariableDeclarationFragment)fragments.get(0));
            if (indexBinding == null) {
                return false;
            }
            this.fIndexBinding = indexBinding;
            return true;
        }
        if (fragments.size() == 2) {
            IVariableBinding indexBinding = this.getIndexBindingFromFragment((VariableDeclarationFragment)fragments.get(0));
            if (indexBinding == null) {
                indexBinding = this.getIndexBindingFromFragment((VariableDeclarationFragment)fragments.get(1));
                if (indexBinding == null) {
                    return false;
                }
                if (!this.validateLengthFragment((VariableDeclarationFragment)fragments.get(0))) {
                    return false;
                }
            } else if (!this.validateLengthFragment((VariableDeclarationFragment)fragments.get(1))) {
                return false;
            }
            this.fIndexBinding = indexBinding;
            return true;
        }
        return false;
    }

    private boolean validateLengthFragment(VariableDeclarationFragment fragment) {
        Expression initializer = fragment.getInitializer();
        if (initializer == null) {
            return false;
        }
        if (!this.validateLengthQuery(initializer)) {
            return false;
        }
        IVariableBinding lengthBinding = (IVariableBinding)fragment.getName().resolveBinding();
        if (lengthBinding == null) {
            return false;
        }
        this.fLengthBinding = lengthBinding;
        return true;
    }

    private IVariableBinding getIndexBindingFromFragment(VariableDeclarationFragment fragment) {
        if (!Long.valueOf(0L).equals(ASTNodes.getIntegerLiteral(fragment.getInitializer()))) {
            return null;
        }
        return (IVariableBinding)fragment.getName().resolveBinding();
    }

    private boolean validateExpression(ForStatement statement) {
        Expression expression = statement.getExpression();
        if (!(expression instanceof InfixExpression)) {
            return false;
        }
        InfixExpression infix = (InfixExpression)expression;
        Expression left = infix.getLeftOperand();
        Expression right = infix.getRightOperand();
        if (left instanceof SimpleName && right instanceof SimpleName) {
            IVariableBinding lengthBinding = this.fLengthBinding;
            if (lengthBinding == null) {
                return false;
            }
            IBinding leftBinding = ((SimpleName)left).resolveBinding();
            IBinding righBinding = ((SimpleName)right).resolveBinding();
            if (this.fIndexBinding.equals((Object)leftBinding)) {
                return lengthBinding.equals((Object)righBinding) && ASTNodes.hasOperator(infix, InfixExpression.Operator.LESS, InfixExpression.Operator.NOT_EQUALS);
            }
            if (this.fIndexBinding.equals((Object)righBinding)) {
                return lengthBinding.equals((Object)leftBinding) && ASTNodes.hasOperator(infix, InfixExpression.Operator.GREATER, InfixExpression.Operator.NOT_EQUALS);
            }
        } else {
            if (left instanceof SimpleName) {
                if (!this.fIndexBinding.equals((Object)((SimpleName)left).resolveBinding())) {
                    return false;
                }
                if (!ASTNodes.hasOperator(infix, InfixExpression.Operator.LESS, InfixExpression.Operator.NOT_EQUALS)) {
                    return false;
                }
                return this.validateLengthQuery(right);
            }
            if (right instanceof SimpleName) {
                if (!this.fIndexBinding.equals((Object)((SimpleName)right).resolveBinding())) {
                    return false;
                }
                if (!ASTNodes.hasOperator(infix, InfixExpression.Operator.GREATER, InfixExpression.Operator.NOT_EQUALS)) {
                    return false;
                }
                return this.validateLengthQuery(left);
            }
        }
        return false;
    }

    private boolean validateLengthQuery(Expression lengthQuery) {
        if (lengthQuery instanceof QualifiedName) {
            QualifiedName qualifiedName = (QualifiedName)lengthQuery;
            SimpleName name = qualifiedName.getName();
            if (!LENGTH_QUERY.equals(name.getIdentifier())) {
                return false;
            }
            Name arrayAccess = qualifiedName.getQualifier();
            ITypeBinding accessType = arrayAccess.resolveTypeBinding();
            if (accessType == null) {
                return false;
            }
            if (!accessType.isArray()) {
                return false;
            }
            IBinding arrayBinding = arrayAccess.resolveBinding();
            if (arrayBinding == null) {
                return false;
            }
            this.fArrayBinding = arrayBinding;
            this.fArrayAccess = arrayAccess;
            return true;
        }
        if (lengthQuery instanceof FieldAccess) {
            FieldAccess fieldAccess = (FieldAccess)lengthQuery;
            SimpleName name = fieldAccess.getName();
            if (!LENGTH_QUERY.equals(name.getIdentifier())) {
                return false;
            }
            Expression arrayAccess = fieldAccess.getExpression();
            ITypeBinding accessType = arrayAccess.resolveTypeBinding();
            if (accessType == null) {
                return false;
            }
            if (!accessType.isArray()) {
                return false;
            }
            IBinding arrayBinding = ConvertForLoopOperation.getBinding(arrayAccess);
            if (arrayBinding == null) {
                return false;
            }
            this.fArrayBinding = arrayBinding;
            this.fArrayAccess = arrayAccess;
            return true;
        }
        if (lengthQuery instanceof MethodInvocation) {
            MethodInvocation methodCall = (MethodInvocation)lengthQuery;
            SimpleName name = methodCall.getName();
            if (!SIZE_QUERY.equals(name.getIdentifier()) || !methodCall.arguments().isEmpty()) {
                return false;
            }
            IMethodBinding methodBinding = methodCall.resolveMethodBinding();
            if (methodBinding == null) {
                return false;
            }
            ITypeBinding classBinding = methodBinding.getDeclaringClass();
            if (this.isCollection(classBinding)) {
                this.fIsCollection = true;
                this.fSizeMethodBinding = methodBinding;
                this.fSizeMethodAccess = methodCall;
                return true;
            }
        }
        return false;
    }

    private boolean isCollection(ITypeBinding classBinding) {
        if (classBinding.getErasure().getQualifiedName().startsWith("java.util.Collection")) {
            return true;
        }
        ITypeBinding superClass = classBinding.getSuperclass();
        if (superClass != null && this.isCollection(superClass)) {
            return true;
        }
        ITypeBinding[] iTypeBindingArray = classBinding.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding binding = iTypeBindingArray[n2];
            if (this.isCollection(binding)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean validateUpdaters(ForStatement statement) {
        List updaters = statement.updaters();
        if (updaters.size() != 1) {
            return false;
        }
        Expression updater = (Expression)updaters.get(0);
        if (updater instanceof PostfixExpression) {
            PostfixExpression postfix = (PostfixExpression)updater;
            if (!PostfixExpression.Operator.INCREMENT.equals(postfix.getOperator())) {
                return false;
            }
            IBinding binding = ConvertForLoopOperation.getBinding(postfix.getOperand());
            return this.fIndexBinding.equals((Object)binding);
        }
        if (updater instanceof PrefixExpression) {
            PrefixExpression prefix = (PrefixExpression)updater;
            if (!PrefixExpression.Operator.INCREMENT.equals(prefix.getOperator())) {
                return false;
            }
            IBinding binding = ConvertForLoopOperation.getBinding(prefix.getOperand());
            return this.fIndexBinding.equals((Object)binding);
        }
        if (updater instanceof Assignment) {
            Assignment assignment = (Assignment)updater;
            Expression left = assignment.getLeftHandSide();
            IBinding binding = ConvertForLoopOperation.getBinding(left);
            if (!this.fIndexBinding.equals((Object)binding)) {
                return false;
            }
            if (Assignment.Operator.PLUS_ASSIGN.equals(assignment.getOperator())) {
                return Long.valueOf(1L).equals(ASTNodes.getIntegerLiteral(assignment.getRightHandSide()));
            }
            if (Assignment.Operator.ASSIGN.equals(assignment.getOperator())) {
                Expression right = assignment.getRightHandSide();
                if (!(right instanceof InfixExpression)) {
                    return false;
                }
                InfixExpression infixExpression = (InfixExpression)right;
                Expression leftOperand = infixExpression.getLeftOperand();
                IBinding leftBinding = ConvertForLoopOperation.getBinding(leftOperand);
                Expression rightOperand = infixExpression.getRightOperand();
                IBinding rightBinding = ConvertForLoopOperation.getBinding(rightOperand);
                if (this.fIndexBinding.equals((Object)leftBinding)) {
                    return Long.valueOf(1L).equals(ASTNodes.getIntegerLiteral(rightOperand));
                }
                if (this.fIndexBinding.equals((Object)rightBinding)) {
                    return Long.valueOf(1L).equals(ASTNodes.getIntegerLiteral(leftOperand));
                }
            }
        }
        return false;
    }

    private boolean validateBody(ForStatement statement) {
        Statement body = statement.getBody();
        try {
            body.accept((ASTVisitor)new GenericVisitor(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                protected boolean visitNode(ASTNode node) {
                    if (node instanceof ContinueStatement) {
                        return false;
                    }
                    if (node instanceof Name) {
                        Name name = (Name)node;
                        IBinding nameBinding = name.resolveBinding();
                        if (nameBinding == null) {
                            throw new InvalidBodyError();
                        }
                        if (nameBinding.equals((Object)ConvertForLoopOperation.this.fIndexBinding)) {
                            ConvertForLoopOperation.this.fLoopVarReferenced = true;
                            if (node.getLocationInParent() == ArrayAccess.INDEX_PROPERTY) {
                                IBinding binding;
                                if (ConvertForLoopOperation.this.fIsCollection) {
                                    throw new InvalidBodyError();
                                }
                                ArrayAccess arrayAccess = (ArrayAccess)node.getParent();
                                Expression array = arrayAccess.getArray();
                                if (array instanceof QualifiedName) {
                                    if (!(ConvertForLoopOperation.this.fArrayAccess instanceof QualifiedName)) {
                                        throw new InvalidBodyError();
                                    }
                                    IBinding varBinding1 = ((QualifiedName)array).getQualifier().resolveBinding();
                                    if (varBinding1 == null) {
                                        throw new InvalidBodyError();
                                    }
                                    IBinding varBinding2 = ((QualifiedName)ConvertForLoopOperation.this.fArrayAccess).getQualifier().resolveBinding();
                                    if (!varBinding1.equals((Object)varBinding2)) {
                                        throw new InvalidBodyError();
                                    }
                                } else if (array instanceof FieldAccess) {
                                    Expression arrayExpression = ((FieldAccess)array).getExpression();
                                    if (arrayExpression instanceof ThisExpression) {
                                        Expression arrayAccessExpression;
                                        if (ConvertForLoopOperation.this.fArrayAccess instanceof FieldAccess ? !((arrayAccessExpression = ((FieldAccess)ConvertForLoopOperation.this.fArrayAccess).getExpression()) instanceof ThisExpression) : ConvertForLoopOperation.this.fArrayAccess instanceof QualifiedName) {
                                            throw new InvalidBodyError();
                                        }
                                    } else {
                                        if (!(ConvertForLoopOperation.this.fArrayAccess instanceof FieldAccess)) {
                                            throw new InvalidBodyError();
                                        }
                                        Expression arrayAccessExpression = ((FieldAccess)ConvertForLoopOperation.this.fArrayAccess).getExpression();
                                        if (!arrayExpression.subtreeMatch((ASTMatcher)new JdtASTMatcher(), (Object)arrayAccessExpression)) {
                                            throw new InvalidBodyError();
                                        }
                                    }
                                } else {
                                    Expression arrayAccessExpression;
                                    if (ConvertForLoopOperation.this.fArrayAccess instanceof QualifiedName) {
                                        throw new InvalidBodyError();
                                    }
                                    if (ConvertForLoopOperation.this.fArrayAccess instanceof FieldAccess && !((arrayAccessExpression = ((FieldAccess)ConvertForLoopOperation.this.fArrayAccess).getExpression()) instanceof ThisExpression)) {
                                        throw new InvalidBodyError();
                                    }
                                }
                                if ((binding = ConvertForLoopOperation.getBinding(array)) == null) {
                                    throw new InvalidBodyError();
                                }
                                if (ConvertForLoopOperation.this.fArrayBinding.equals((Object)binding)) return true;
                                throw new InvalidBodyError();
                            }
                            if (node.getLocationInParent() != MethodInvocation.ARGUMENTS_PROPERTY) throw new InvalidBodyError();
                            MethodInvocation method = (MethodInvocation)node.getParent();
                            IMethodBinding methodBinding = method.resolveMethodBinding();
                            if (methodBinding == null) {
                                throw new InvalidBodyError();
                            }
                            ITypeBinding[] parms = methodBinding.getParameterTypes();
                            if (!(ConvertForLoopOperation.this.fIsCollection && ConvertForLoopOperation.GET_QUERY.equals(method.getName().getFullyQualifiedName()) && parms.length == 1 && "int".equals(parms[0].getName()) && ConvertForLoopOperation.areTypeBindingEqual(ConvertForLoopOperation.this.fSizeMethodBinding.getDeclaringClass(), methodBinding.getDeclaringClass()) && ConvertForLoopOperation.this.fSizeMethodAccess.getExpression() != null && ConvertForLoopOperation.this.fSizeMethodAccess.getExpression().subtreeMatch(new ASTMatcher(), (Object)method.getExpression()))) {
                                throw new InvalidBodyError();
                            }
                            ConvertForLoopOperation.this.fGetMethodBinding = methodBinding;
                            return true;
                        } else {
                            if (nameBinding.equals((Object)ConvertForLoopOperation.this.fArrayBinding)) {
                                if (!this.isAssigned(node)) return true;
                                throw new InvalidBodyError();
                            }
                            if (nameBinding.equals((Object)ConvertForLoopOperation.this.fLengthBinding)) {
                                throw new InvalidBodyError();
                            }
                            if (ConvertForLoopOperation.this.fElementDeclaration == null || !nameBinding.equals((Object)ConvertForLoopOperation.this.fElementDeclaration.getName().resolveBinding()) || !this.isAssigned(node)) return true;
                            ConvertForLoopOperation.this.fElementDeclaration = null;
                        }
                        return true;
                    } else {
                        String methodName;
                        if (!ConvertForLoopOperation.this.fIsCollection || !(node instanceof MethodInvocation)) return true;
                        MethodInvocation method = (MethodInvocation)node;
                        IMethodBinding binding = method.resolveMethodBinding();
                        if (binding == null) {
                            throw new InvalidBodyError();
                        }
                        if (!ConvertForLoopOperation.areTypeBindingEqual(ConvertForLoopOperation.this.fSizeMethodBinding.getDeclaringClass(), binding.getDeclaringClass()) || ConvertForLoopOperation.SIZE_QUERY.equals(methodName = method.getName().getFullyQualifiedName()) || ConvertForLoopOperation.GET_QUERY.equals(methodName) || ConvertForLoopOperation.ISEMPTY_QUERY.equals(methodName)) return true;
                        throw new InvalidBodyError();
                    }
                }

                private boolean isAssigned(ASTNode current) {
                    while (current != null && !(current instanceof Statement)) {
                        if (current.getLocationInParent() == Assignment.LEFT_HAND_SIDE_PROPERTY) {
                            return true;
                        }
                        if (current instanceof PrefixExpression && !((PrefixExpression)current).getOperator().equals(PrefixExpression.Operator.NOT)) {
                            return true;
                        }
                        if (current instanceof PostfixExpression) {
                            return true;
                        }
                        current = current.getParent();
                    }
                    return false;
                }

                @Override
                public boolean visit(ArrayAccess node) {
                    IBinding index;
                    if (ConvertForLoopOperation.this.fElementDeclaration != null) {
                        return super.visit(node);
                    }
                    IBinding binding = ConvertForLoopOperation.getBinding(node.getArray());
                    if (!ConvertForLoopOperation.this.fIsCollection && ConvertForLoopOperation.this.fArrayBinding.equals((Object)binding) && ConvertForLoopOperation.this.fIndexBinding.equals((Object)(index = ConvertForLoopOperation.getBinding(node.getIndex()))) && node.getLocationInParent() == VariableDeclarationFragment.INITIALIZER_PROPERTY) {
                        ConvertForLoopOperation.this.fElementDeclaration = (VariableDeclarationFragment)node.getParent();
                    }
                    return super.visit(node);
                }

                @Override
                public boolean visit(MethodInvocation node) {
                    IBinding index;
                    if (ConvertForLoopOperation.this.fElementDeclaration != null || !ConvertForLoopOperation.this.fIsCollection) {
                        return super.visit(node);
                    }
                    IMethodBinding nodeBinding = node.resolveMethodBinding();
                    if (nodeBinding == null) {
                        return super.visit(node);
                    }
                    ITypeBinding[] args = nodeBinding.getParameterTypes();
                    if (ConvertForLoopOperation.GET_QUERY.equals(nodeBinding.getName()) && args.length == 1 && "int".equals(args[0].getName()) && ConvertForLoopOperation.areTypeBindingEqual(nodeBinding.getDeclaringClass(), ConvertForLoopOperation.this.fSizeMethodBinding.getDeclaringClass()) && ConvertForLoopOperation.this.fIndexBinding.equals((Object)(index = ConvertForLoopOperation.getBinding((Expression)node.arguments().get(0)))) && node.getLocationInParent() == VariableDeclarationFragment.INITIALIZER_PROPERTY) {
                        ConvertForLoopOperation.this.fElementDeclaration = (VariableDeclarationFragment)node.getParent();
                    }
                    return super.visit(node);
                }
            });
        }
        catch (InvalidBodyError invalidBodyError) {
            return false;
        }
        return true;
    }

    private static boolean areTypeBindingEqual(ITypeBinding binding1, ITypeBinding binding2) {
        if (binding1 == null || binding2 == null) {
            return false;
        }
        if (binding1.isEqualTo((IBinding)binding2)) {
            return true;
        }
        if (binding1.getErasure() == null || binding2.getErasure() == null || binding1.getTypeArguments() == null || binding2.getTypeArguments() == null || binding1.getTypeArguments().length != binding2.getTypeArguments().length || binding1.getDimensions() != binding2.getDimensions() || binding1.isAnonymous() || binding2.isAnonymous()) {
            return false;
        }
        return binding1.getErasure().isEqualTo((IBinding)binding2.getErasure());
    }

    private static IBinding getBinding(Expression expression) {
        if (expression instanceof FieldAccess) {
            return ((FieldAccess)expression).resolveFieldBinding();
        }
        if (expression instanceof Name) {
            return ((Name)expression).resolveBinding();
        }
        return null;
    }

    @Override
    public String getIntroducedVariableName() {
        if (this.fElementDeclaration != null) {
            return this.fElementDeclaration.getName().getIdentifier();
        }
        ForStatement forStatement = this.getForStatement();
        IJavaProject javaProject = ((CompilationUnit)forStatement.getRoot()).getJavaElement().getJavaProject();
        String[] proposals = null;
        proposals = this.fIsCollection ? this.getVariableNameProposalsCollection(this.fSizeMethodAccess, javaProject) : this.getVariableNameProposals(this.fArrayAccess.resolveTypeBinding(), javaProject);
        return proposals[0];
    }

    @Override
    protected Statement convert(CompilationUnitRewrite cuRewrite, TextEditGroup group, LinkedProposalModelCore positionGroups) throws CoreException {
        ASTRewrite rewrite = cuRewrite.getASTRewrite();
        ImportRewrite importRewrite = cuRewrite.getImportRewrite();
        ForStatement forStatement = this.getForStatement();
        IJavaProject javaProject = ((CompilationUnit)forStatement.getRoot()).getJavaElement().getJavaProject();
        String[] proposals = null;
        proposals = this.fIsCollection ? this.getVariableNameProposalsCollection(this.fSizeMethodAccess, javaProject) : this.getVariableNameProposals(this.fArrayAccess.resolveTypeBinding(), javaProject);
        String parameterName = this.fElementDeclaration != null ? this.fElementDeclaration.getName().getIdentifier() : proposals[0];
        LinkedProposalPositionGroupCore pg = positionGroups.getPositionGroup(parameterName, true);
        if (this.fElementDeclaration != null) {
            pg.addProposal(parameterName, 10);
        }
        String[] stringArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            String proposal = stringArray[n2];
            pg.addProposal(proposal, 10);
            ++n2;
        }
        AST ast = forStatement.getAST();
        EnhancedForStatement result = ast.newEnhancedForStatement();
        SingleVariableDeclaration parameterDeclaration = null;
        Expression parameterExpression = null;
        if (this.fIsCollection) {
            parameterExpression = this.fSizeMethodAccess.getExpression();
            parameterDeclaration = this.createParameterDeclarationCollection(parameterName, this.fElementDeclaration, (Expression)this.fSizeMethodAccess, forStatement, importRewrite, rewrite, group, pg, this.fMakeFinal);
        } else {
            parameterExpression = this.fArrayAccess;
            parameterDeclaration = this.createParameterDeclaration(parameterName, this.fElementDeclaration, this.fArrayAccess, forStatement, importRewrite, rewrite, group, pg, this.fMakeFinal);
        }
        result.setParameter(parameterDeclaration);
        result.setExpression((Expression)rewrite.createCopyTarget((ASTNode)parameterExpression));
        if (this.fIsCollection) {
            this.convertBodyCollection(forStatement.getBody(), (IBinding)this.fIndexBinding, (IBinding)this.fGetMethodBinding, parameterName, rewrite, group, pg);
        } else {
            this.convertBody(forStatement.getBody(), (IBinding)this.fIndexBinding, this.fArrayBinding, parameterName, rewrite, group, pg);
        }
        result.setBody(this.getBody(cuRewrite, group, positionGroups));
        positionGroups.setEndPosition(rewrite.track((ASTNode)result));
        return result;
    }

    private void convertBody(Statement body, final IBinding indexBinding, final IBinding arrayBinding, final String parameterName, final ASTRewrite rewrite, final TextEditGroup editGroup, final LinkedProposalPositionGroupCore pg) {
        final AST ast = body.getAST();
        body.accept((ASTVisitor)new GenericVisitor(){

            @Override
            public boolean visit(ArrayAccess node) {
                IBinding index;
                IBinding binding = ConvertForLoopOperation.getBinding(node.getArray());
                if (arrayBinding.equals((Object)binding) && indexBinding.equals((Object)(index = ConvertForLoopOperation.getBinding(node.getIndex())))) {
                    this.replaceAccess((ASTNode)node);
                }
                return super.visit(node);
            }

            private void replaceAccess(ASTNode node) {
                if (ConvertForLoopOperation.this.fElementDeclaration != null && node.getLocationInParent() == VariableDeclarationFragment.INITIALIZER_PROPERTY) {
                    VariableDeclarationFragment fragment = (VariableDeclarationFragment)node.getParent();
                    IBinding targetBinding = fragment.getName().resolveBinding();
                    if (targetBinding != null) {
                        VariableDeclarationStatement statement = (VariableDeclarationStatement)fragment.getParent();
                        if (statement.fragments().size() == 1) {
                            rewrite.remove((ASTNode)statement, editGroup);
                        } else {
                            ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)statement, VariableDeclarationStatement.FRAGMENTS_PROPERTY);
                            listRewrite.remove((ASTNode)fragment, editGroup);
                        }
                    } else {
                        SimpleName name = ast.newSimpleName(parameterName);
                        ASTNodes.replaceButKeepComment(rewrite, node, (ASTNode)name, editGroup);
                        pg.addPosition(rewrite.track((ASTNode)name), true);
                    }
                } else {
                    SimpleName name = ast.newSimpleName(parameterName);
                    ASTNodes.replaceButKeepComment(rewrite, node, (ASTNode)name, editGroup);
                    pg.addPosition(rewrite.track((ASTNode)name), true);
                }
            }
        });
    }

    private SingleVariableDeclaration createParameterDeclaration(String parameterName, VariableDeclarationFragment fragement, Expression arrayAccess, ForStatement statement, ImportRewrite importRewrite, ASTRewrite rewrite, TextEditGroup group, LinkedProposalPositionGroupCore pg, boolean makeFinal) {
        CompilationUnit compilationUnit = (CompilationUnit)arrayAccess.getRoot();
        AST ast = compilationUnit.getAST();
        SingleVariableDeclaration result = ast.newSingleVariableDeclaration();
        SimpleName name = ast.newSimpleName(parameterName);
        pg.addPosition(rewrite.track((ASTNode)name), true);
        result.setName(name);
        ITypeBinding arrayTypeBinding = arrayAccess.resolveTypeBinding();
        Type type = this.importType(arrayTypeBinding.getElementType(), (ASTNode)statement, importRewrite, compilationUnit, arrayTypeBinding.getDimensions() == 1 ? ImportRewrite.TypeLocation.LOCAL_VARIABLE : ImportRewrite.TypeLocation.ARRAY_CONTENTS);
        if (arrayTypeBinding.getDimensions() != 1) {
            type = ast.newArrayType(type, arrayTypeBinding.getDimensions() - 1);
        }
        result.setType(type);
        if (fragement != null) {
            VariableDeclarationStatement declaration = (VariableDeclarationStatement)fragement.getParent();
            ModifierRewrite.create(rewrite, (ASTNode)result).copyAllModifiers((ASTNode)declaration, group);
        }
        if (makeFinal && (fragement == null || ASTNodes.findModifierNode(16, ASTNodes.getModifiers((VariableDeclaration)fragement)) == null)) {
            ModifierRewrite.create(rewrite, (ASTNode)result).setModifiers(16, 0, group);
        }
        return result;
    }

    private String[] getVariableNameProposals(ITypeBinding arrayTypeBinding, IJavaProject project) {
        String[] variableNames = this.getUsedVariableNames();
        String baseName = ConvertForLoopOperation.modifyBaseName(this.fArrayBinding.getName());
        String[] elementSuggestions = StubUtility.getLocalNameSuggestions(project, baseName, 0, variableNames);
        String type = arrayTypeBinding.getElementType().getName();
        String[] typeSuggestions = StubUtility.getLocalNameSuggestions(project, type, arrayTypeBinding.getDimensions() - 1, variableNames);
        String[] result = new String[elementSuggestions.length + typeSuggestions.length];
        System.arraycopy(elementSuggestions, 0, result, 0, elementSuggestions.length);
        System.arraycopy(typeSuggestions, 0, result, elementSuggestions.length, typeSuggestions.length);
        return result;
    }

    private String[] getVariableNameProposalsCollection(MethodInvocation sizeMethodAccess, IJavaProject project) {
        String[] variableNames = this.getUsedVariableNames();
        Expression exp = sizeMethodAccess.getExpression();
        String name = exp instanceof SimpleName ? ((SimpleName)exp).getFullyQualifiedName() : "";
        String baseName = ConvertForLoopOperation.modifyBaseName(name);
        String[] elementSuggestions = StubUtility.getLocalNameSuggestions(project, baseName, 0, variableNames);
        ITypeBinding[] typeArgs = this.fSizeMethodBinding.getDeclaringClass().getTypeArguments();
        String type = typeArgs == null || typeArgs.length == 0 ? "Object" : (typeArgs[0].isCapture() ? ASTResolving.normalizeWildcardType(typeArgs[0], true, sizeMethodAccess.getRoot().getAST()).getName() : typeArgs[0].getName());
        String[] typeSuggestions = StubUtility.getLocalNameSuggestions(project, type, 0, variableNames);
        String[] result = new String[elementSuggestions.length + typeSuggestions.length];
        System.arraycopy(elementSuggestions, 0, result, 0, elementSuggestions.length);
        System.arraycopy(typeSuggestions, 0, result, elementSuggestions.length, typeSuggestions.length);
        return result;
    }

    private void convertBodyCollection(Statement body, final IBinding indexBinding, final IBinding getBinding, final String parameterName, final ASTRewrite rewrite, final TextEditGroup editGroup, final LinkedProposalPositionGroupCore pg) {
        final AST ast = body.getAST();
        body.accept((ASTVisitor)new GenericVisitor(){

            @Override
            public boolean visit(MethodInvocation node) {
                List args;
                IMethodBinding binding = node.resolveMethodBinding();
                if (binding != null && binding.isEqualTo(getBinding) && (args = node.arguments()).size() == 1 && args.get(0) instanceof SimpleName && indexBinding.isEqualTo(((SimpleName)args.get(0)).resolveBinding())) {
                    this.replaceAccess(node);
                }
                return super.visit(node);
            }

            private void replaceAccess(MethodInvocation node) {
                if (ConvertForLoopOperation.this.fElementDeclaration != null && node.getLocationInParent() == VariableDeclarationFragment.INITIALIZER_PROPERTY) {
                    VariableDeclarationFragment fragment = (VariableDeclarationFragment)node.getParent();
                    IBinding targetBinding = fragment.getName().resolveBinding();
                    if (targetBinding != null && fragment.getName().getFullyQualifiedName().equals(parameterName)) {
                        VariableDeclarationStatement statement = (VariableDeclarationStatement)fragment.getParent();
                        if (statement.fragments().size() == 1) {
                            rewrite.remove((ASTNode)statement, editGroup);
                        } else {
                            ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)statement, VariableDeclarationStatement.FRAGMENTS_PROPERTY);
                            listRewrite.remove((ASTNode)fragment, editGroup);
                        }
                    } else {
                        SimpleName name = ast.newSimpleName(parameterName);
                        ASTNodes.replaceButKeepComment(rewrite, (ASTNode)node, (ASTNode)name, editGroup);
                        pg.addPosition(rewrite.track((ASTNode)name), true);
                    }
                } else {
                    SimpleName name = ast.newSimpleName(parameterName);
                    ASTNodes.replaceButKeepComment(rewrite, (ASTNode)node, (ASTNode)name, editGroup);
                    pg.addPosition(rewrite.track((ASTNode)name), true);
                }
            }
        });
    }

    private SingleVariableDeclaration createParameterDeclarationCollection(String parameterName, VariableDeclarationFragment fragment, Expression sizeAccess, ForStatement statement, ImportRewrite importRewrite, ASTRewrite rewrite, TextEditGroup group, LinkedProposalPositionGroupCore pg, boolean makeFinal) {
        CompilationUnit compilationUnit = (CompilationUnit)sizeAccess.getRoot();
        AST ast = compilationUnit.getAST();
        SingleVariableDeclaration result = ast.newSingleVariableDeclaration();
        SimpleName name = ast.newSimpleName(parameterName);
        pg.addPosition(rewrite.track((ASTNode)name), true);
        result.setName(name);
        IMethodBinding sizeTypeBinding = ((MethodInvocation)sizeAccess).resolveMethodBinding();
        ITypeBinding[] sizeTypeArguments = sizeTypeBinding.getDeclaringClass().getTypeArguments();
        ITypeBinding elementType = sizeTypeArguments == null || sizeTypeArguments.length == 0 ? this.fSizeMethodAccess.getAST().resolveWellKnownType("java.lang.Object") : (sizeTypeArguments[0].isCapture() ? ASTResolving.normalizeWildcardType(sizeTypeArguments[0], true, ast) : sizeTypeArguments[0]);
        Type type = this.importType(elementType, (ASTNode)statement, importRewrite, compilationUnit, ImportRewrite.TypeLocation.LOCAL_VARIABLE);
        result.setType(type);
        if (fragment != null) {
            VariableDeclarationStatement declaration = (VariableDeclarationStatement)fragment.getParent();
            ModifierRewrite.create(rewrite, (ASTNode)result).copyAllModifiers((ASTNode)declaration, group);
        }
        if (makeFinal && (fragment == null || ASTNodes.findModifierNode(16, ASTNodes.getModifiers((VariableDeclaration)fragment)) == null)) {
            ModifierRewrite.create(rewrite, (ASTNode)result).setModifiers(16, 0, group);
        }
        return result;
    }

    private static final class InvalidBodyError
    extends Error {
        private static final long serialVersionUID = 1L;

        private InvalidBodyError() {
        }
    }
}

