/*********************************************************************
 * Copyright (c) 2019 Kichwa Coders and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
/// <reference types="node" />
/// <reference types="node" />
import { GDBDebugSession, RequestArguments } from './GDBDebugSession';
import { DebugProtocol } from '@vscode/debugprotocol';
import { ChildProcess } from 'child_process';
import { SerialPort } from 'serialport';
import { Socket } from 'net';
interface UARTArguments {
    serialPort?: string;
    socketPort?: string;
    baudRate?: number;
    characterSize?: 5 | 6 | 7 | 8;
    parity?: 'none' | 'even' | 'odd' | 'mark' | 'space';
    stopBits?: 1 | 1.5 | 2;
    handshakingMethod?: 'none' | 'XON/XOFF' | 'RTS/CTS';
    eolCharacter?: 'LF' | 'CRLF';
}
export interface TargetAttachArguments {
    type?: string;
    parameters?: string[];
    host?: string;
    port?: string;
    connectCommands?: string[];
    uart?: UARTArguments;
}
export interface TargetLaunchArguments extends TargetAttachArguments {
    server?: string;
    serverParameters?: string[];
    environment?: Record<string, string | null>;
    serverPortRegExp?: string;
    serverStartupDelay?: number;
    automaticallyKillServer?: boolean;
    cwd?: string;
}
export interface ImageAndSymbolArguments {
    symbolFileName?: string;
    symbolOffset?: string;
    imageFileName?: string;
    imageOffset?: string;
}
export interface TargetAttachRequestArguments extends RequestArguments {
    target?: TargetAttachArguments;
    imageAndSymbols?: ImageAndSymbolArguments;
    preRunCommands?: string[];
}
export interface TargetLaunchRequestArguments extends TargetAttachRequestArguments {
    target?: TargetLaunchArguments;
    imageAndSymbols?: ImageAndSymbolArguments;
    preRunCommands?: string[];
}
export declare class GDBTargetDebugSession extends GDBDebugSession {
    protected gdbserver?: ChildProcess;
    protected killGdbServer: boolean;
    protected serialPort?: SerialPort;
    protected socket?: Socket;
    /**
     * Define the target type here such that we can run the "disconnect"
     * command when servicing the disconnect request if the target type
     * is remote.
     */
    protected targetType?: string;
    protected attachOrLaunchRequest(response: DebugProtocol.Response, request: 'launch' | 'attach', args: TargetLaunchRequestArguments | TargetAttachRequestArguments): Promise<void>;
    protected launchRequest(response: DebugProtocol.LaunchResponse, args: TargetLaunchRequestArguments): Promise<void>;
    protected attachRequest(response: DebugProtocol.AttachResponse, args: TargetAttachRequestArguments): Promise<void>;
    protected setupCommonLoggerAndHandlers(args: TargetLaunchRequestArguments): void;
    protected startGDBServer(args: TargetLaunchRequestArguments): Promise<void>;
    protected initializeUARTConnection(uart: UARTArguments, host: string | undefined): void;
    protected startGDBAndAttachToTarget(response: DebugProtocol.AttachResponse | DebugProtocol.LaunchResponse, args: TargetAttachRequestArguments): Promise<void>;
    protected stopGDBServer(): Promise<void>;
    protected disconnectRequest(response: DebugProtocol.DisconnectResponse, _args: DebugProtocol.DisconnectArguments): Promise<void>;
}
export {};
