"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.sendBreakFunctionInsert = exports.sendBreakList = exports.sendBreakDelete = exports.sendBreakInsert = exports.breakpointFunctionLocation = exports.breakpointLocation = void 0;
function cleanupBreakpointResponse(raw) {
    if (Array.isArray(raw.bkpt)) {
        const bkpt = raw.bkpt[0];
        const multiple = raw.bkpt.slice(1);
        return {
            _class: raw._class,
            bkpt,
            multiple,
        };
    }
    return {
        _class: raw._class,
        bkpt: raw.bkpt,
    };
}
function breakpointLocation(gdb, source, line = '', forInsert = false) {
    const version8 = gdb.gdbVersionAtLeast('8.0');
    if (forInsert) {
        if (version8) {
            return `--source ${gdb.standardEscape(source)} --line ${line}`;
        }
        else {
            // double-escaping/quoting needed for old GDBs
            const location = `"${source}:${line}"`;
            return `${gdb.standardEscape(location, true)}`;
        }
    }
    else {
        return version8
            ? `-source ${source} -line ${line}`
            : `${source}:${line}`;
    }
}
exports.breakpointLocation = breakpointLocation;
function breakpointFunctionLocation(gdb, fn, forInsert = false) {
    const version8 = gdb.gdbVersionAtLeast('8.0');
    if (forInsert) {
        return version8 ? `--function ${fn}` : fn;
    }
    else {
        return version8 ? `-function ${fn}` : fn;
    }
}
exports.breakpointFunctionLocation = breakpointFunctionLocation;
function sendBreakInsert(gdb, request) {
    return __awaiter(this, void 0, void 0, function* () {
        // Todo: lots of options
        const temp = request.temporary ? '-t ' : '';
        const ignore = request.ignoreCount ? `-i ${request.ignoreCount} ` : '';
        const hwBreakpoint = request.hardware ? '-h ' : '';
        const pend = request.pending ? '-f ' : '';
        const location = yield breakpointLocation(gdb, request.source, request.line.toString(), true);
        const command = `-break-insert ${temp}${hwBreakpoint}${ignore}${pend}${location}`;
        const result = yield gdb.sendCommand(command);
        const clean = cleanupBreakpointResponse(result);
        if (request.condition) {
            yield gdb.sendCommand(`-break-condition ${clean.bkpt.number} ${request.condition}`);
        }
        return clean;
    });
}
exports.sendBreakInsert = sendBreakInsert;
function sendBreakDelete(gdb, request) {
    return gdb.sendCommand(`-break-delete ${request.breakpoints.join(' ')}`);
}
exports.sendBreakDelete = sendBreakDelete;
function sendBreakList(gdb) {
    return gdb.sendCommand('-break-list');
}
exports.sendBreakList = sendBreakList;
function sendBreakFunctionInsert(gdb, fn, request) {
    return __awaiter(this, void 0, void 0, function* () {
        const temp = (request === null || request === void 0 ? void 0 : request.temporary) ? '-t ' : '';
        const hwBreakpoint = (request === null || request === void 0 ? void 0 : request.hardware) ? '-h ' : '';
        const pend = (request === null || request === void 0 ? void 0 : request.pending) ? '-f ' : '';
        const location = yield breakpointFunctionLocation(gdb, fn, true);
        const command = `-break-insert ${temp}${hwBreakpoint}${pend}${location}`;
        const result = yield gdb.sendCommand(command);
        const clean = cleanupBreakpointResponse(result);
        return clean;
    });
}
exports.sendBreakFunctionInsert = sendBreakFunctionInsert;
//# sourceMappingURL=breakpoint.js.map