"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.XYOutputOverviewComponent = void 0;
const responses_1 = require("tsp-typescript-client/lib/models/response/responses");
const React = __importStar(require("react"));
const xy_output_component_utils_1 = require("./utils/xy-output-component-utils");
const abstract_xy_output_component_1 = require("./abstract-xy-output-component");
const abstract_xy_output_component_2 = require("./abstract-xy-output-component");
const react_fontawesome_1 = require("@fortawesome/react-fontawesome");
const free_solid_svg_icons_1 = require("@fortawesome/free-solid-svg-icons");
const trace_overview_selection_dialog_component_1 = require("./trace-overview-selection-dialog-component");
const COLOR = {
    SELECTION_RANGE: '#259fd8',
    VIEW_RANGE: '#ffa500',
};
/**
 * The overview uses the viewRange for the orange overlay, selectionRange for the blue overlay.
 * It will only be setting these properties.
 */
class XYOutputOverviewComponent extends abstract_xy_output_component_2.AbstractXYOutputComponent {
    constructor(props) {
        super(props);
        this.initialViewRangeStartPosition = 0;
        this.initialViewRangeEndPosition = 0;
        this.viewRangeMoveStartOffsetX = 0;
        this.state = {
            outputStatus: responses_1.ResponseStatus.RUNNING,
            selectedSeriesId: [],
            xyTree: [],
            checkedSeries: [],
            collapsedNodes: [],
            orderedNodes: [],
            xyData: {},
            columns: [{ title: 'Name', sortable: true }],
            allMax: 0,
            allMin: 0,
            cursor: 'default',
            shiftKey: false,
            optionsDropdownOpen: false,
            showModal: false
        };
        this.keyMapping = this.getKeyActionMap();
        this.afterChartDraw = this.afterChartDraw.bind(this);
        this.closeOverviewOutputSelector = this.closeOverviewOutputSelector.bind(this);
    }
    renderChart() {
        var _a, _b;
        if (this.state.outputStatus === responses_1.ResponseStatus.COMPLETED && ((_b = (_a = this.state.xyData) === null || _a === void 0 ? void 0 : _a.datasets) === null || _b === void 0 ? void 0 : _b.length) === 0) {
            return React.createElement(React.Fragment, null,
                React.createElement("div", { className: 'chart-message' }, "Select a checkbox to see analysis results"));
        }
        return React.createElement(React.Fragment, null, this.state.outputStatus === responses_1.ResponseStatus.COMPLETED ?
            React.createElement("div", { id: this.getOutputComponentDomId() + 'focusContainer', className: 'xy-main', tabIndex: 0, onKeyDown: event => this.onKeyDown(event), onKeyUp: event => this.onKeyUp(event), onWheel: event => this.onWheel(event), onMouseMove: event => this.onMouseMove(event), onContextMenu: event => event.preventDefault(), onMouseLeave: event => this.onMouseLeave(event), onMouseDown: event => this.onMouseDown(event), style: { height: this.props.style.height, position: 'relative', cursor: this.state.cursor }, ref: this.divRef }, this.chooseChart()) :
            React.createElement("div", { id: this.getOutputComponentDomId() + 'focusContainer', className: 'analysis-running' },
                React.createElement("i", { className: 'fa fa-refresh fa-spin', style: { marginRight: '5px' } }),
                React.createElement("span", null, "Analysis running")));
    }
    getDisplayedRange() {
        return this.props.range;
    }
    afterChartDraw(ctx, chartArea) {
        var _a;
        if (ctx) {
            if (this.props.viewRange) {
                const startPixel = this.getXForTime(this.props.viewRange.getStart());
                const endPixel = this.getXForTime(this.props.viewRange.getEnd());
                ctx.strokeStyle = COLOR.VIEW_RANGE;
                ctx.fillStyle = COLOR.VIEW_RANGE;
                (0, xy_output_component_utils_1.drawSelection)(ctx, chartArea, startPixel, endPixel, this.isBarPlot, this.props);
            }
            if (this.props.selectionRange) {
                const selectionRangeStart = this.getXForTime(this.props.selectionRange.getStart());
                const selectionRangeEnd = this.getXForTime(this.props.selectionRange.getEnd());
                ctx.strokeStyle = COLOR.SELECTION_RANGE;
                ctx.fillStyle = COLOR.SELECTION_RANGE;
                (0, xy_output_component_utils_1.drawSelection)(ctx, chartArea, selectionRangeStart, selectionRangeEnd, this.isBarPlot, this.props);
            }
            if (this.clickedMouseButton === abstract_xy_output_component_1.MouseButton.RIGHT) {
                const offset = (_a = this.props.viewRange.getOffset()) !== null && _a !== void 0 ? _a : BigInt(0);
                const startPixel = this.getXForTime((this.startPositionMouseRightClick + offset));
                const endPixel = this.positionXMove;
                ctx.strokeStyle = COLOR.VIEW_RANGE;
                ctx.fillStyle = COLOR.VIEW_RANGE;
                (0, xy_output_component_utils_1.drawSelection)(ctx, chartArea, startPixel, endPixel, this.isBarPlot, this.props);
            }
        }
    }
    getZoomTime() {
        return (this.props.unitController.viewRange.start + this.props.unitController.viewRange.end) / BigInt(2);
    }
    getKeyActionMap() {
        const map = new Map();
        // Key that corresponds to the zoom in action
        map.set('W', abstract_xy_output_component_2.XY_OUTPUT_KEY_ACTIONS.ZOOM_IN);
        map.set('w', abstract_xy_output_component_2.XY_OUTPUT_KEY_ACTIONS.ZOOM_IN);
        map.set('I', abstract_xy_output_component_2.XY_OUTPUT_KEY_ACTIONS.ZOOM_IN);
        map.set('i', abstract_xy_output_component_2.XY_OUTPUT_KEY_ACTIONS.ZOOM_IN);
        // Key that corresponds to the zoom out action
        map.set('S', abstract_xy_output_component_2.XY_OUTPUT_KEY_ACTIONS.ZOOM_OUT);
        map.set('s', abstract_xy_output_component_2.XY_OUTPUT_KEY_ACTIONS.ZOOM_OUT);
        map.set('K', abstract_xy_output_component_2.XY_OUTPUT_KEY_ACTIONS.ZOOM_OUT);
        map.set('k', abstract_xy_output_component_2.XY_OUTPUT_KEY_ACTIONS.ZOOM_OUT);
        // Key that corresponds to the pan left action
        map.set('A', abstract_xy_output_component_2.XY_OUTPUT_KEY_ACTIONS.PAN_LEFT);
        map.set('a', abstract_xy_output_component_2.XY_OUTPUT_KEY_ACTIONS.PAN_LEFT);
        map.set('J', abstract_xy_output_component_2.XY_OUTPUT_KEY_ACTIONS.PAN_LEFT);
        map.set('j', abstract_xy_output_component_2.XY_OUTPUT_KEY_ACTIONS.PAN_LEFT);
        map.set('ArrowLeft', abstract_xy_output_component_2.XY_OUTPUT_KEY_ACTIONS.PAN_LEFT);
        // Key that corresponds to the pan right action
        map.set('D', abstract_xy_output_component_2.XY_OUTPUT_KEY_ACTIONS.PAN_RIGHT);
        map.set('d', abstract_xy_output_component_2.XY_OUTPUT_KEY_ACTIONS.PAN_RIGHT);
        map.set('L', abstract_xy_output_component_2.XY_OUTPUT_KEY_ACTIONS.PAN_RIGHT);
        map.set('l', abstract_xy_output_component_2.XY_OUTPUT_KEY_ACTIONS.PAN_RIGHT);
        map.set('ArrowRight', abstract_xy_output_component_2.XY_OUTPUT_KEY_ACTIONS.PAN_RIGHT);
        map.set('Shift', abstract_xy_output_component_2.XY_OUTPUT_KEY_ACTIONS.SHIFT_PRESS);
        return map;
    }
    onKeyDown(key) {
        this.hideTooltip();
        if (!this.isMouseLeave) {
            const action = this.keyMapping.get(key.key);
            switch (action) {
                case abstract_xy_output_component_2.XY_OUTPUT_KEY_ACTIONS.ZOOM_IN: {
                    this.zoom(abstract_xy_output_component_2.FLAG_ZOOM_IN);
                    break;
                }
                case abstract_xy_output_component_2.XY_OUTPUT_KEY_ACTIONS.ZOOM_OUT: {
                    this.zoom(abstract_xy_output_component_2.FLAG_ZOOM_OUT);
                    break;
                }
                case abstract_xy_output_component_2.XY_OUTPUT_KEY_ACTIONS.PAN_LEFT: {
                    this.pan(abstract_xy_output_component_2.FLAG_PAN_LEFT);
                    break;
                }
                case abstract_xy_output_component_2.XY_OUTPUT_KEY_ACTIONS.PAN_RIGHT: {
                    this.pan(abstract_xy_output_component_2.FLAG_PAN_RIGHT);
                    break;
                }
                case abstract_xy_output_component_2.XY_OUTPUT_KEY_ACTIONS.SHIFT_PRESS: {
                    this.shiftKeyPress();
                    break;
                }
            }
        }
    }
    onKeyUp(key) {
        if (key.key === 'Shift') {
            const change = { shiftKey: false };
            if (!this.mouseIsDown) {
                change.cursor = 'default';
            }
            this.setState(change);
        }
    }
    onMouseDown(event) {
        this.isMouseLeave = false;
        this.mouseIsDown = true;
        this.clickedMouseButton = event.button;
        if (this.clickedMouseButton === abstract_xy_output_component_1.MouseButton.RIGHT) {
            this.onRightButtonClick(event);
        }
        else if (this.clickedMouseButton === abstract_xy_output_component_1.MouseButton.MID) {
            this.onMidButtonClick(event);
        }
        else {
            this.onLeftButtonClick(event);
        }
        document.addEventListener('mouseup', this.endSelection);
    }
    onMouseMove(event) {
        this.positionXMove = event.nativeEvent.offsetX;
        this.isMouseLeave = false;
        if (this.mouseIsDown && this.clickedMouseButton === abstract_xy_output_component_1.MouseButton.LEFT) {
            this.updateSelection();
        }
        if (this.mouseIsDown && this.clickedMouseButton === abstract_xy_output_component_1.MouseButton.MID) {
            this.updateViewRange();
        }
        if (this.mouseIsDown && this.clickedMouseButton === abstract_xy_output_component_1.MouseButton.RIGHT) {
            this.forceUpdate();
        }
        if (this.state.xyData.datasets.length > 0) {
            this.tooltip(event.nativeEvent.x, event.nativeEvent.y);
        }
    }
    onMouseLeave(event) {
        this.isMouseLeave = true;
        const width = this.isBarPlot ? this.getChartWidth() : this.chartRef.current.chartInstance.width;
        this.positionXMove = Math.max(0, Math.min(event.nativeEvent.offsetX, width));
        this.forceUpdate();
        if (this.mouseIsDown && !(this.clickedMouseButton === abstract_xy_output_component_1.MouseButton.RIGHT)) {
            this.updateSelection();
        }
        this.hideTooltip();
    }
    onMidButtonClick(event) {
        this.setState({ cursor: 'grab' });
        this.initialViewRangeStartPosition = this.getXForTime(this.props.viewRange.getStart());
        this.initialViewRangeEndPosition = this.getXForTime(this.props.viewRange.getEnd());
        this.viewRangeMoveStartOffsetX = event.nativeEvent.offsetX;
    }
    onRightButtonClick(event) {
        this.setState({ cursor: 'crosshair' });
        this.startPositionMouseRightClick = this.getTimeForX(event.nativeEvent.offsetX);
    }
    onLeftButtonClick(event) {
        const startTime = this.getTimeForX(event.nativeEvent.offsetX);
        this.setState({ cursor: 'crosshair' });
        if (event.shiftKey && this.props.unitController.selectionRange) {
            this.props.unitController.selectionRange = {
                start: this.props.unitController.selectionRange.start,
                end: startTime
            };
        }
        else {
            this.props.unitController.selectionRange = {
                start: startTime,
                end: startTime
            };
        }
        this.onMouseMove(event);
    }
    updateViewRange() {
        // Calculate the moved distance
        const pixelsMoved = this.positionXMove - this.viewRangeMoveStartOffsetX;
        let startPixel = this.initialViewRangeStartPosition + pixelsMoved;
        let endPixel = this.initialViewRangeEndPosition + pixelsMoved;
        const leftLimit = this.chartRef.current.chartInstance.chartArea.left;
        const rightLimit = this.chartRef.current.chartInstance.chartArea.right;
        // The user moved out-of-graph on the left side
        if (startPixel < leftLimit) {
            startPixel = leftLimit;
            endPixel = this.initialViewRangeEndPosition - this.initialViewRangeStartPosition;
        }
        // The user moved out-of-graph on the right side
        else if (endPixel > rightLimit) {
            startPixel = rightLimit - (this.initialViewRangeStartPosition - this.initialViewRangeEndPosition);
            endPixel = rightLimit;
        }
        if (this.props.unitController.viewRange) {
            this.props.unitController.viewRange = {
                start: this.getTimeForX(startPixel),
                end: this.getTimeForX(endPixel)
            };
        }
    }
    onWheel(wheel) {
        this.isMouseLeave = false;
        if (wheel.shiftKey) {
            if (wheel.deltaY < 0) {
                this.pan(abstract_xy_output_component_2.FLAG_PAN_LEFT);
            }
            else if (wheel.deltaY > 0) {
                this.pan(abstract_xy_output_component_2.FLAG_PAN_RIGHT);
            }
        }
        else if (wheel.ctrlKey) {
            if (wheel.deltaY < 0) {
                this.zoom(abstract_xy_output_component_2.FLAG_ZOOM_IN);
            }
            else if (wheel.deltaY > 0) {
                this.zoom(abstract_xy_output_component_2.FLAG_ZOOM_OUT);
            }
        }
    }
    shiftKeyPress() {
        if (this.clickedMouseButton !== abstract_xy_output_component_1.MouseButton.RIGHT) {
            this.setState({ cursor: 'crosshair', shiftKey: true });
        }
    }
    getOutputComponentDomId() {
        return this.props.traceId + this.props.outputDescriptor.id + 'overview';
    }
    getOutputComponentName() {
        return 'Overview';
    }
    getTitleBarTooltip() {
        return this.props.outputDescriptor.name + ' overview';
    }
    showOptionsMenu() {
        return React.createElement(React.Fragment, null, React.createElement("div", { className: 'options-menu-container' },
            React.createElement("button", { title: "Select overview output source", className: 'options-menu-button', onClick: () => { this.openOverviewOutputSelector(); } },
                React.createElement(react_fontawesome_1.FontAwesomeIcon, { icon: free_solid_svg_icons_1.faCog })),
            React.createElement(trace_overview_selection_dialog_component_1.TraceOverviewSelectionDialogComponent, { isOpen: this.state.showModal, title: "Select overview output source", tspClient: this.props.tspClient, traceID: this.props.traceId, onCloseDialog: this.closeOverviewOutputSelector })));
    }
    closeOverviewOutputSelector() {
        this.setState({ showModal: false });
    }
    openOverviewOutputSelector() {
        this.setState({ showModal: true });
    }
}
exports.XYOutputOverviewComponent = XYOutputOverviewComponent;
//# sourceMappingURL=xy-output-overview-component.js.map