"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TableHeader = void 0;
const React = __importStar(require("react"));
class TableHeader extends React.Component {
    constructor(props) {
        super(props);
        this.mouseDownX = 0;
        this.originalWidth = 0;
        this.resizedHeader = undefined;
        this.resizedIndex = 0;
        this.handleSortChange = (sortColumn, ev) => {
            const resizeHandle = ev.currentTarget.querySelector('.resize-handle');
            if (resizeHandle && ev.clientX >= resizeHandle.getBoundingClientRect().x) {
                /* Don't sort if click is over the resize handle */
                return;
            }
            this.props.onSort(sortColumn);
        };
        this.handleResizeDoubleClick = (ev, index) => {
            var _a, _b, _c, _d;
            if ((_a = ev.currentTarget.parentElement) === null || _a === void 0 ? void 0 : _a.parentElement) {
                const resizedHeader = (_b = ev.currentTarget.parentElement) === null || _b === void 0 ? void 0 : _b.parentElement;
                const table = (_d = (_c = resizedHeader.parentElement) === null || _c === void 0 ? void 0 : _c.parentElement) === null || _d === void 0 ? void 0 : _d.parentElement;
                if (table) {
                    this.gridTemplateColumns[index] = 'max-content';
                    table.style.gridTemplateColumns = this.gridTemplateColumns.join(' ');
                }
            }
        };
        this.handleResizeMouseDown = (ev, index) => {
            var _a, _b;
            if ((_a = ev.currentTarget.parentElement) === null || _a === void 0 ? void 0 : _a.parentElement) {
                this.resizedHeader = (_b = ev.currentTarget.parentElement) === null || _b === void 0 ? void 0 : _b.parentElement;
                this.resizedIndex = index;
                this.mouseDownX = ev.clientX;
                this.originalWidth = this.resizedHeader.clientWidth;
                window.addEventListener('mousemove', this.handleResizeMouseMove);
                window.addEventListener('mouseup', this.handleResizeMouseUp);
                ev.preventDefault();
            }
        };
        this.handleResizeMouseMove = (ev) => {
            var _a, _b;
            if (this.resizedHeader) {
                const table = (_b = (_a = this.resizedHeader.parentElement) === null || _a === void 0 ? void 0 : _a.parentElement) === null || _b === void 0 ? void 0 : _b.parentElement;
                if (table) {
                    const width = Math.max(18, this.originalWidth + ev.clientX - this.mouseDownX);
                    this.gridTemplateColumns[this.resizedIndex] = width + 'px';
                    table.style.gridTemplateColumns = this.gridTemplateColumns.join(' ');
                }
            }
        };
        this.handleResizeMouseUp = () => {
            window.removeEventListener('mousemove', this.handleResizeMouseMove);
            window.removeEventListener('mouseup', this.handleResizeMouseUp);
            this.resizedHeader = undefined;
            this.resizedIndex = 0;
            this.mouseDownX = 0;
            this.originalWidth = 0;
        };
        /* Capitalize first character and add non-breaking spaces to make room for icons in default width calcluation */
        this.toHeaderTitle = (name) => (name.charAt(0).toUpperCase() + name.slice(1) + '\xa0\xa0\xa0\xa0\xa0');
        this.renderSortIcon = (column) => {
            if (this.props.sortableColumns.includes(column)) {
                const state = this.props.sortConfig.find((config) => config.column === column);
                return state
                    ? React.createElement("span", { className: 'sort-icon' }, state.sortState)
                    : undefined;
            }
            return undefined;
        };
        this.renderResizeIcon = (index) => (this.props.columns[index].resizable)
            ? React.createElement("span", { className: 'resize-handle', onMouseDown: ev => this.handleResizeMouseDown(ev, index), onDoubleClick: ev => this.handleResizeDoubleClick(ev, index) }, "|")
            : undefined;
        this.renderHeader = () => {
            const header = this.props.columns.map((column, index) => React.createElement("th", { key: 'th-' + index, onClick: ev => this.handleSortChange(column.title, ev) },
                React.createElement("span", null,
                    this.toHeaderTitle(column.title),
                    this.renderResizeIcon(index),
                    this.renderSortIcon(column.title))));
            header.push(React.createElement("th", { key: 'th-filler', className: 'filler' }));
            return header;
        };
        this.gridTemplateColumns = this.props.columns.map(() => 'max-content');
        this.gridTemplateColumns.push('minmax(0px, 1fr)');
    }
    render() {
        return React.createElement("thead", null,
            React.createElement("tr", null, this.renderHeader()));
    }
}
exports.TableHeader = TableHeader;
//# sourceMappingURL=table-header.js.map