"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SearchFilterRenderer = exports.CellRenderer = exports.LoadingRenderer = void 0;
const free_solid_svg_icons_1 = require("@fortawesome/free-solid-svg-icons");
const react_fontawesome_1 = require("@fortawesome/react-fontawesome");
const lodash_debounce_1 = __importDefault(require("lodash.debounce"));
const React = __importStar(require("react"));
class LoadingRenderer extends React.Component {
    render() {
        return React.createElement(React.Fragment, null, this.props.value ? this.props.value : React.createElement(react_fontawesome_1.FontAwesomeIcon, { icon: free_solid_svg_icons_1.faSpinner }));
    }
}
exports.LoadingRenderer = LoadingRenderer;
class CellRenderer extends React.Component {
    render() {
        var _a;
        if (this.props.value === undefined) {
            return React.createElement(React.Fragment, null,
                React.createElement(react_fontawesome_1.FontAwesomeIcon, { icon: free_solid_svg_icons_1.faSpinner }));
        }
        const currField = (_a = this.props.colDef) === null || _a === void 0 ? void 0 : _a.field;
        const currFieldVal = this.props.value || '';
        const isMatched = this.props.data && this.props.data['isMatched'];
        let cellElement;
        const searchTerm = (currField && this.props.filterModel.get(currField)) || '';
        if (this.props.filterModel.size > 0) {
            if (isMatched) {
                cellElement = React.createElement(React.Fragment, null, currFieldVal.split(new RegExp(searchTerm)).map((tag, index, array) => React.createElement("span", { key: index.toString() },
                    React.createElement(React.Fragment, null, tag),
                    React.createElement(React.Fragment, null, index < array.length - 1 ?
                        React.createElement("span", { style: { backgroundColor: this.props.searchResultsColor } }, currFieldVal.match(new RegExp(searchTerm))[0])
                        : React.createElement(React.Fragment, null)))));
            }
            else {
                cellElement = React.createElement("span", { style: { color: '#808080' } },
                    " ",
                    currFieldVal,
                    " ");
            }
        }
        else {
            cellElement = React.createElement(React.Fragment, null, currFieldVal || '');
        }
        return React.createElement(React.Fragment, null, cellElement);
    }
}
exports.CellRenderer = CellRenderer;
class SearchFilterRenderer extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            hasHovered: false,
            hasClicked: false
        };
        this.debouncedChangeHandler = (0, lodash_debounce_1.default)((colName, inputVal) => {
            this.props.onFilterChange(colName, inputVal);
        }, 500);
        this.onInputBoxChanged = this.onInputBoxChanged.bind(this);
        this.onMouseEnterHandler = this.onMouseEnterHandler.bind(this);
        this.onMouseLeaveHandler = this.onMouseLeaveHandler.bind(this);
        this.onClickHandler = this.onClickHandler.bind(this);
        this.onDownClickHandler = this.onDownClickHandler.bind(this);
        this.onUpClickHandler = this.onUpClickHandler.bind(this);
        this.onCloseClickHandler = this.onCloseClickHandler.bind(this);
        this.onKeyDownEvent = this.onKeyDownEvent.bind(this);
    }
    render() {
        return (React.createElement("div", { "data-testid": "search-filter-element-parent", onMouseEnter: this.onMouseEnterHandler, onMouseLeave: this.onMouseLeaveHandler, onClick: this.onClickHandler },
            !this.state.hasClicked && !this.state.hasHovered &&
                React.createElement(react_fontawesome_1.FontAwesomeIcon, { style: { marginLeft: '10px' }, icon: free_solid_svg_icons_1.faSearch }),
            !this.state.hasClicked && this.state.hasHovered &&
                React.createElement("div", { style: { cursor: 'pointer' } },
                    React.createElement(react_fontawesome_1.FontAwesomeIcon, { style: { marginLeft: '10px' }, icon: free_solid_svg_icons_1.faSearch }),
                    React.createElement("span", { style: { marginLeft: '10px', fontSize: '13px', width: '50px', overflow: 'hidden', textOverflow: 'ellipsis' } }, "Search")),
            this.state.hasClicked &&
                React.createElement("div", null,
                    React.createElement("input", { "data-testid": "search-filter-element-input", type: "text", autoFocus: true, onKeyDown: this.onKeyDownEvent, onInput: this.onInputBoxChanged, style: { width: '50%', margin: '10px' } }),
                    React.createElement(react_fontawesome_1.FontAwesomeIcon, { className: 'hoverClass', icon: free_solid_svg_icons_1.faTimes, style: { marginTop: '20px' }, onClick: this.onCloseClickHandler }),
                    React.createElement(react_fontawesome_1.FontAwesomeIcon, { className: 'hoverClass', icon: free_solid_svg_icons_1.faAngleDown, style: { marginLeft: '10px', marginTop: '20px' }, onClick: this.onDownClickHandler }),
                    React.createElement(react_fontawesome_1.FontAwesomeIcon, { className: 'hoverClass', icon: free_solid_svg_icons_1.faAngleUp, style: { marginLeft: '10px', marginTop: '20px' }, onClick: this.onUpClickHandler }))));
    }
    onKeyDownEvent(event) {
        if (event.key === 'Enter') {
            if (event.shiftKey) {
                this.props.onclickPrevious();
            }
            else {
                this.props.onclickNext();
            }
        }
        else if (event.key === 'Escape') {
            this.setState({
                hasClicked: false
            });
            this.props.onFilterChange(this.props.colName, '');
        }
        return;
    }
    onInputBoxChanged(event) {
        this.debouncedChangeHandler(this.props.colName, event.target.value);
        return;
    }
    onMouseEnterHandler() {
        this.setState({
            hasHovered: true
        });
        return;
    }
    onMouseLeaveHandler() {
        this.setState({
            hasHovered: false
        });
        return;
    }
    onClickHandler() {
        this.setState({
            hasClicked: true
        });
        return;
    }
    onDownClickHandler() {
        this.props.onclickNext();
        return;
    }
    onUpClickHandler() {
        this.props.onclickPrevious();
        return;
    }
    onCloseClickHandler(event) {
        this.setState({
            hasClicked: false
        });
        this.props.onFilterChange(this.props.colName, '');
        event.stopPropagation();
        return;
    }
}
exports.SearchFilterRenderer = SearchFilterRenderer;
//# sourceMappingURL=table-renderer-components.js.map