"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeRange = void 0;
class TimeRange {
    constructor(a, b, c) {
        if (typeof a === 'bigint' && typeof b === 'bigint') {
            this.start = a;
            this.end = b;
            this.offset = c;
        }
        else if (typeof a === 'object') {
            const timeRangeString = a;
            const { start, end, offset } = timeRangeString;
            this.start = BigInt(start);
            this.end = BigInt(end);
            this.offset = offset ? BigInt(offset) : undefined;
        }
        else {
            this.start = BigInt(0);
            this.end = BigInt(0);
            this.offset = undefined;
        }
    }
    /**
     * Get the range start time.
     * If an offset is present the return value is start + offset.
     */
    getStart() {
        if (this.offset !== undefined) {
            return this.start + this.offset;
        }
        return this.start;
    }
    /**
     * Get the range end time.
     * If an offset is present the return value is end + offset.
     */
    getEnd() {
        if (this.offset !== undefined) {
            return this.end + this.offset;
        }
        return this.end;
    }
    /**
     * Get range duration
     */
    getDuration() {
        return this.end - this.start;
    }
    /**
     * Return the time offset
     */
    getOffset() {
        return this.offset;
    }
    /**
     * Create a string object that can be JSON.stringified
     */
    toString() {
        var _a;
        return {
            start: this.start.toString(),
            end: this.end.toString(),
            offset: (_a = this.offset) === null || _a === void 0 ? void 0 : _a.toString()
        };
    }
}
exports.TimeRange = TimeRange;
//# sourceMappingURL=time-range.js.map