"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeGraphRowController = void 0;
var time_graph_render_controller_1 = require("./time-graph-render-controller");
var TimeGraphRowController = /** @class */ (function () {
    function TimeGraphRowController(rowHeight, _totalHeight) {
        this.rowHeight = rowHeight;
        this._totalHeight = _totalHeight;
        this._selectedRow = undefined;
        this._selectedRowIndex = -1;
        this.selectedRowChangedHandlers = [];
        this.verticalOffsetChangedHandlers = [];
        this.totalHeightChangedHandlers = [];
        this._verticalOffset = 0;
    }
    TimeGraphRowController.prototype.handleVerticalOffsetChanged = function () {
        var _this = this;
        this.verticalOffsetChangedHandlers.forEach(function (h) { return h(_this._verticalOffset); });
        this.startRender();
    };
    TimeGraphRowController.prototype.handleSelectedRowChanged = function () {
        var selectedRow = this._selectedRow;
        if (selectedRow) {
            this.selectedRowChangedHandlers.forEach(function (h) { return h(selectedRow); });
        }
    };
    TimeGraphRowController.prototype.handleTotalHeightChanged = function () {
        var _this = this;
        this.totalHeightChangedHandlers.forEach(function (h) { return h(_this._totalHeight); });
        this.startRender();
    };
    TimeGraphRowController.prototype.startRender = function () {
        time_graph_render_controller_1.RenderEvents.startRender();
    };
    TimeGraphRowController.prototype.onSelectedRowChangedHandler = function (handler) {
        this.selectedRowChangedHandlers.push(handler);
    };
    TimeGraphRowController.prototype.removeSelectedRowChangedHandler = function (handler) {
        var index = this.selectedRowChangedHandlers.indexOf(handler);
        if (index > -1) {
            this.selectedRowChangedHandlers.splice(index, 1);
        }
    };
    TimeGraphRowController.prototype.onVerticalOffsetChangedHandler = function (handler) {
        this.verticalOffsetChangedHandlers.push(handler);
    };
    TimeGraphRowController.prototype.removeVerticalOffsetChangedHandler = function (handler) {
        var index = this.verticalOffsetChangedHandlers.indexOf(handler);
        if (index > -1) {
            this.verticalOffsetChangedHandlers.splice(index, 1);
        }
    };
    TimeGraphRowController.prototype.onTotalHeightChangedHandler = function (handler) {
        this.totalHeightChangedHandlers.push(handler);
    };
    TimeGraphRowController.prototype.removeTotalHeightChangedHandler = function (handler) {
        var index = this.totalHeightChangedHandlers.indexOf(handler);
        if (index > -1) {
            this.totalHeightChangedHandlers.splice(index, 1);
        }
    };
    Object.defineProperty(TimeGraphRowController.prototype, "totalHeight", {
        get: function () {
            return this._totalHeight;
        },
        set: function (height) {
            this._totalHeight = height;
            this.handleTotalHeightChanged();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TimeGraphRowController.prototype, "verticalOffset", {
        get: function () {
            return this._verticalOffset;
        },
        set: function (value) {
            this._verticalOffset = value;
            this.handleVerticalOffsetChanged();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TimeGraphRowController.prototype, "selectedRow", {
        get: function () {
            return this._selectedRow;
        },
        set: function (value) {
            this._selectedRow = value;
            this.handleSelectedRowChanged();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TimeGraphRowController.prototype, "selectedRowIndex", {
        get: function () {
            return this._selectedRowIndex;
        },
        set: function (index) {
            this._selectedRowIndex = index;
            this.handleSelectedRowChanged();
        },
        enumerable: false,
        configurable: true
    });
    return TimeGraphRowController;
}());
exports.TimeGraphRowController = TimeGraphRowController;
//# sourceMappingURL=time-graph-row-controller.js.map